/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_WebComponentsBinding_h__
#define mozilla_dom_WebComponentsBinding_h__

#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/Nullable.h"

namespace mozilla {
namespace dom {

struct LifecycleCallbacks;
class LifecycleCreatedCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct LifecycleCallbacks : public MainThreadDictionaryBase
{
  nsRefPtr<LifecycleCreatedCallback> mCreated;

private:
  static bool initedIds;
  static jsid created_id;

  LifecycleCallbacks(const LifecycleCallbacks&) MOZ_DELETE;
  void operator=(const LifecycleCallbacks) MOZ_DELETE;

public:
  inline LifecycleCallbacks()
  {
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

private:
  static bool
  InitIds(JSContext* cx);
};
struct LifecycleCallbacksInitializer : public LifecycleCallbacks
{
  inline LifecycleCallbacksInitializer()
  {
    // Safe to pass a null context if we pass a null value
    Init(nullptr, JS::NullHandleValue);
  }
};


struct ElementRegistrationOptions : public MainThreadDictionaryBase
{
  LifecycleCallbacks mLifecycle;
  JSObject* mPrototype;

private:
  static bool initedIds;
  static jsid lifecycle_id;
  static jsid prototype_id;

  ElementRegistrationOptions(const ElementRegistrationOptions&) MOZ_DELETE;
  void operator=(const ElementRegistrationOptions) MOZ_DELETE;

public:
  inline ElementRegistrationOptions()
    : mPrototype(nullptr)
  {
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

private:
  static bool
  InitIds(JSContext* cx);
};
struct ElementRegistrationOptionsInitializer : public ElementRegistrationOptions
{
  inline ElementRegistrationOptionsInitializer()
  {
    // Safe to pass a null context if we pass a null value
    Init(nullptr, JS::NullHandleValue);
  }
};


class LifecycleCreatedCallback : public CallbackFunction
{
public:
  explicit inline LifecycleCreatedCallback(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline LifecycleCreatedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, ErrorResult& aRv);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WebComponentsBinding_h__
