/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_InputMethodBinding_h__
#define mozilla_dom_InputMethodBinding_h__

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "nsDOMEventTargetHelper.h"

namespace mozilla {
namespace dom {

struct CompositionClauseParameters;
struct CompositionClauseParametersAtoms;
class EventHandlerNonNull;
class MozInputContext;
class MozInputMethod;
class MozInputMethodManager;
class NativePropertyHooks;
class Promise;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {


MOZ_BEGIN_ENUM_CLASS(CompositionClauseSelectionType, uint32_t)
  Raw_input,
  Selected_raw_text,
  Converted_text,
  Selected_converted_text
MOZ_END_ENUM_CLASS(CompositionClauseSelectionType)

namespace CompositionClauseSelectionTypeValues {
extern const EnumEntry strings[5];
} // namespace CompositionClauseSelectionTypeValues


struct CompositionClauseParameters : public MainThreadDictionaryBase
{
  Optional<int32_t > mLength;
  nsString mSelectionType;

  inline CompositionClauseParameters()
  {
  }

  explicit inline CompositionClauseParameters(const CompositionClauseParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const CompositionClauseParameters& aOther);

private:
  static bool
  InitIds(JSContext* cx, CompositionClauseParametersAtoms* atomsCache);
};
struct CompositionClauseParametersInitializer : public CompositionClauseParameters
{
  CompositionClauseParametersInitializer();
};


namespace MozInputContextBinding {

  typedef mozilla::dom::MozInputContext NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::MozInputContext* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Heap<JSObject*>* aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace MozInputContextBinding



namespace MozInputMethodBinding {

  typedef mozilla::dom::MozInputMethod NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* cx, JS::Handle<JSObject*> obj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::MozInputMethod* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Heap<JSObject*>* aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace MozInputMethodBinding



namespace MozInputMethodManagerBinding {

  typedef mozilla::dom::MozInputMethodManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::MozInputMethodManager* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Heap<JSObject*>* aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace MozInputMethodManagerBinding



class MozInputContextJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputContextJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  already_AddRefed<Promise> GetText(JSCompartment* aCompartment, const Optional<int32_t >& offset, const Optional<int32_t >& length, ErrorResult& aRv);

  already_AddRefed<Promise> SetSelectionRange(JSCompartment* aCompartment, int32_t start, int32_t length, ErrorResult& aRv);

  already_AddRefed<Promise> ReplaceSurroundingText(JSCompartment* aCompartment, const nsAString& text, const Optional<int32_t >& offset, const Optional<int32_t >& length, ErrorResult& aRv);

  already_AddRefed<Promise> DeleteSurroundingText(JSCompartment* aCompartment, int32_t offset, int32_t length, ErrorResult& aRv);

  already_AddRefed<Promise> SendKey(JSCompartment* aCompartment, int32_t keyCode, int32_t charCode, int32_t modifiers, ErrorResult& aRv);

  already_AddRefed<Promise> SetComposition(JSCompartment* aCompartment, const nsAString& text, const Optional<int32_t >& cursor, const Optional<Sequence<CompositionClauseParameters > >& clauses, ErrorResult& aRv);

  already_AddRefed<Promise> EndComposition(JSCompartment* aCompartment, const Optional<nsAString >& text, ErrorResult& aRv);

  void GetType(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  void GetInputType(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  void GetInputMode(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  void GetLang(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  int32_t GetSelectionStart(JSCompartment* aCompartment, ErrorResult& aRv);

  int32_t GetSelectionEnd(JSCompartment* aCompartment, ErrorResult& aRv);

  void GetTextBeforeCursor(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  void GetTextAfterCursor(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnselectionchange(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnsurroundingtextchange(JSCompartment* aCompartment, ErrorResult& aRv);

  void SetOnselectionchange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnsurroundingtextchange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);
};


class MozInputContext MOZ_FINAL : public nsDOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputContext, nsDOMEventTargetHelper)

private:
  nsRefPtr<MozInputContextJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputContext(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  void GetType(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  void GetInputType(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  void GetInputMode(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  void GetLang(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> GetText(JSCompartment* aCompartment, const Optional<int32_t >& offset, const Optional<int32_t >& length, ErrorResult& aRv);

  int32_t GetSelectionStart(JSCompartment* aCompartment, ErrorResult& aRv) const;

  int32_t GetSelectionEnd(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void GetTextBeforeCursor(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  void GetTextAfterCursor(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> SetSelectionRange(JSCompartment* aCompartment, int32_t start, int32_t length, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnselectionchange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnselectionchange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> ReplaceSurroundingText(JSCompartment* aCompartment, const nsAString& text, const Optional<int32_t >& offset, const Optional<int32_t >& length, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> DeleteSurroundingText(JSCompartment* aCompartment, int32_t offset, int32_t length, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnsurroundingtextchange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnsurroundingtextchange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> SendKey(JSCompartment* aCompartment, int32_t keyCode, int32_t charCode, int32_t modifiers, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> SetComposition(JSCompartment* aCompartment, const nsAString& text, const Optional<int32_t >& cursor, const Optional<Sequence<CompositionClauseParameters > >& clauses, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> EndComposition(JSCompartment* aCompartment, const Optional<nsAString >& text, ErrorResult& aRv);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputMethodJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputMethodJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void SetActive(JSCompartment* aCompartment, bool isActive, ErrorResult& aRv);

  already_AddRefed<MozInputMethodManager> GetMgmt(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOninputcontextchange(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<MozInputContext> GetInputcontext(JSCompartment* aCompartment, ErrorResult& aRv);

  void SetOninputcontextchange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);
};


class MozInputMethod MOZ_FINAL : public nsDOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputMethod, nsDOMEventTargetHelper)

private:
  nsRefPtr<MozInputMethodJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputMethod(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<MozInputMethodManager> GetMgmt(JSCompartment* aCompartment, ErrorResult& aRv) const;

  already_AddRefed<EventHandlerNonNull> GetOninputcontextchange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOninputcontextchange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<MozInputContext> GetInputcontext(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetActive(JSCompartment* aCompartment, bool isActive, ErrorResult& aRv);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputMethodManagerJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputMethodManagerJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void ShowAll(JSCompartment* aCompartment, ErrorResult& aRv);

  void Next(JSCompartment* aCompartment, ErrorResult& aRv);

  bool SupportsSwitching(JSCompartment* aCompartment, ErrorResult& aRv);

  void Hide(JSCompartment* aCompartment, ErrorResult& aRv);
};


class MozInputMethodManager MOZ_FINAL : public nsISupports,
                                        public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozInputMethodManager)

private:
  nsRefPtr<MozInputMethodManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputMethodManager(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  void ShowAll(JSCompartment* aCompartment, ErrorResult& aRv);

  void Next(JSCompartment* aCompartment, ErrorResult& aRv);

  bool SupportsSwitching(JSCompartment* aCompartment, ErrorResult& aRv);

  void Hide(JSCompartment* aCompartment, ErrorResult& aRv);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_InputMethodBinding_h__
