/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RTCPeerConnectionBinding_h__
#define mozilla_dom_RTCPeerConnectionBinding_h__

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsDOMEventTargetHelper.h"

class JSObject;
class nsIDOMDataChannel;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class EventHandlerNonNull;
class NativePropertyHooks;
struct RTCConfiguration;
struct RTCDataChannelInit;
struct RTCDataChannelInitAtoms;
class RTCPeerConnectionErrorCallback;
class RTCSessionDescriptionCallback;
class VoidFunction;
class mozRTCIceCandidate;
class mozRTCPeerConnection;
class mozRTCSessionDescription;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {


MOZ_BEGIN_ENUM_CLASS(RTCSignalingState, uint32_t)
  Stable,
  Have_local_offer,
  Have_remote_offer,
  Have_local_pranswer,
  Have_remote_pranswer,
  Closed
MOZ_END_ENUM_CLASS(RTCSignalingState)

namespace RTCSignalingStateValues {
extern const EnumEntry strings[7];
} // namespace RTCSignalingStateValues



MOZ_BEGIN_ENUM_CLASS(RTCIceGatheringState, uint32_t)
  New,
  Gathering,
  Complete
MOZ_END_ENUM_CLASS(RTCIceGatheringState)

namespace RTCIceGatheringStateValues {
extern const EnumEntry strings[4];
} // namespace RTCIceGatheringStateValues



MOZ_BEGIN_ENUM_CLASS(RTCIceConnectionState, uint32_t)
  New,
  Checking,
  Connected,
  Completed,
  Failed,
  Disconnected,
  Closed
MOZ_END_ENUM_CLASS(RTCIceConnectionState)

namespace RTCIceConnectionStateValues {
extern const EnumEntry strings[8];
} // namespace RTCIceConnectionStateValues


struct RTCDataChannelInit : public MainThreadDictionaryBase
{
  Nullable<uint16_t> mId;
  Optional<uint16_t > mMaxRetransmitNum;
  Nullable<uint16_t> mMaxRetransmitTime;
  Nullable<uint16_t> mMaxRetransmits;
  bool mNegotiated;
  bool mOrdered;
  Optional<bool > mOutOfOrderAllowed;
  Optional<bool > mPreset;
  nsString mProtocol;
  Optional<uint16_t > mStream;

  inline RTCDataChannelInit()
  {
  }

  explicit inline RTCDataChannelInit(const RTCDataChannelInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCDataChannelInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache);
};
struct RTCDataChannelInitInitializer : public RTCDataChannelInit
{
  RTCDataChannelInitInitializer();
};


class RTCSessionDescriptionCallback : public CallbackFunction
{
public:
  explicit inline RTCSessionDescriptionCallback(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline RTCSessionDescriptionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, mozilla::dom::mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, sdp, aRv);
  }

  inline void
  Call(mozilla::dom::mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), sdp, aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, mozilla::dom::mozRTCSessionDescription& sdp, ErrorResult& aRv);
};


class RTCPeerConnectionErrorCallback : public CallbackFunction
{
public:
  explicit inline RTCPeerConnectionErrorCallback(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline RTCPeerConnectionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, const nsAString& errorInformation, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, errorInformation, aRv);
  }

  inline void
  Call(const nsAString& errorInformation, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), errorInformation, aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, const nsAString& errorInformation, ErrorResult& aRv);
};


class VoidFunction : public CallbackFunction
{
public:
  explicit inline VoidFunction(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline VoidFunction(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, ErrorResult& aRv);
};


namespace mozRTCPeerConnectionBinding {

  typedef mozilla::dom::mozRTCPeerConnection NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::mozRTCPeerConnection* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Heap<JSObject*>* aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace mozRTCPeerConnectionBinding



class mozRTCPeerConnectionJSImpl : public CallbackInterface
{
public:
  explicit inline mozRTCPeerConnectionJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void CreateOffer(JSCompartment* aCompartment, RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback* failureCallback, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void CreateAnswer(JSCompartment* aCompartment, RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback* failureCallback, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void SetLocalDescription(JSCompartment* aCompartment, mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv);

  void SetRemoteDescription(JSCompartment* aCompartment, mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv);

  void UpdateIce(JSCompartment* aCompartment, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void AddIceCandidate(JSCompartment* aCompartment, mozilla::dom::mozRTCIceCandidate& candidate, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv);

  void GetLocalStreams(JSCompartment* aCompartment, nsTArray<nsRefPtr<DOMMediaStream> >& retval, ErrorResult& aRv);

  void GetRemoteStreams(JSCompartment* aCompartment, nsTArray<nsRefPtr<DOMMediaStream> >& retval, ErrorResult& aRv);

  already_AddRefed<DOMMediaStream> GetStreamById(JSCompartment* aCompartment, const nsAString& streamId, ErrorResult& aRv);

  void AddStream(JSCompartment* aCompartment, mozilla::DOMMediaStream& stream, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void RemoveStream(JSCompartment* aCompartment, mozilla::DOMMediaStream& stream, ErrorResult& aRv);

  void Close(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(JSCompartment* aCompartment, const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv);

  void __Init(JSCompartment* aCompartment, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(JSCompartment* aCompartment, ErrorResult& aRv);

  RTCSignalingState GetSignalingState(JSCompartment* aCompartment, ErrorResult& aRv);

  RTCIceGatheringState GetIceGatheringState(JSCompartment* aCompartment, ErrorResult& aRv);

  RTCIceConnectionState GetIceConnectionState(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<RTCPeerConnectionErrorCallback> GetOnicechange(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<RTCPeerConnectionErrorCallback> GetOngatheringchange(JSCompartment* aCompartment, ErrorResult& aRv);

  JSObject* GetLocalStreams(JSCompartment* aCompartment, ErrorResult& aRv);

  JSObject* GetRemoteStreams(JSCompartment* aCompartment, ErrorResult& aRv);

  void GetReadyState(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnconnection(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnclosedconnection(JSCompartment* aCompartment, ErrorResult& aRv);

  void SetOnnegotiationneeded(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnicecandidate(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnsignalingstatechange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnaddstream(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnremovestream(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOniceconnectionstatechange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnicechange(JSCompartment* aCompartment, RTCPeerConnectionErrorCallback& arg, ErrorResult& aRv);

  void SetOngatheringchange(JSCompartment* aCompartment, RTCPeerConnectionErrorCallback& arg, ErrorResult& aRv);

  void SetOndatachannel(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnconnection(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  void SetOnclosedconnection(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);
};


class mozRTCPeerConnection MOZ_FINAL : public nsDOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(mozRTCPeerConnection, nsDOMEventTargetHelper)

private:
  nsRefPtr<mozRTCPeerConnectionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  mozRTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<mozRTCPeerConnection> Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void CreateOffer(JSCompartment* aCompartment, RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback* failureCallback, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void CreateAnswer(JSCompartment* aCompartment, RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback* failureCallback, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void SetLocalDescription(JSCompartment* aCompartment, mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv);

  void SetRemoteDescription(JSCompartment* aCompartment, mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(JSCompartment* aCompartment, ErrorResult& aRv) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(JSCompartment* aCompartment, ErrorResult& aRv) const;

  RTCSignalingState GetSignalingState(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void UpdateIce(JSCompartment* aCompartment, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void AddIceCandidate(JSCompartment* aCompartment, mozilla::dom::mozRTCIceCandidate& candidate, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv);

  RTCIceGatheringState GetIceGatheringState(JSCompartment* aCompartment, ErrorResult& aRv) const;

  RTCIceConnectionState GetIceConnectionState(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void GetLocalStreams(JSCompartment* aCompartment, nsTArray<// Mark this as resultNotAddRefed to return raw pointers
  nsRefPtr<DOMMediaStream> >& retval, ErrorResult& aRv);

  void GetRemoteStreams(JSCompartment* aCompartment, nsTArray<// Mark this as resultNotAddRefed to return raw pointers
  nsRefPtr<DOMMediaStream> >& retval, ErrorResult& aRv);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMMediaStream> GetStreamById(JSCompartment* aCompartment, const nsAString& streamId, ErrorResult& aRv);

  void AddStream(JSCompartment* aCompartment, mozilla::DOMMediaStream& stream, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void RemoveStream(JSCompartment* aCompartment, mozilla::DOMMediaStream& stream, ErrorResult& aRv);

  void Close(JSCompartment* aCompartment, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnnegotiationneeded(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnicecandidate(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnsignalingstatechange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnaddstream(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnremovestream(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOniceconnectionstatechange(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<RTCPeerConnectionErrorCallback> GetOnicechange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnicechange(JSCompartment* aCompartment, RTCPeerConnectionErrorCallback& arg, ErrorResult& aRv);

  already_AddRefed<RTCPeerConnectionErrorCallback> GetOngatheringchange(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOngatheringchange(JSCompartment* aCompartment, RTCPeerConnectionErrorCallback& arg, ErrorResult& aRv);

  JSObject* GetLocalStreams(JSCompartment* aCompartment, ErrorResult& aRv) const;

  JSObject* GetRemoteStreams(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void GetReadyState(JSCompartment* aCompartment, nsString& retval, ErrorResult& aRv) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(JSCompartment* aCompartment, const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOndatachannel(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnconnection(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnconnection(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  already_AddRefed<EventHandlerNonNull> GetOnclosedconnection(JSCompartment* aCompartment, ErrorResult& aRv) const;

  void SetOnclosedconnection(JSCompartment* aCompartment, EventHandlerNonNull* arg, ErrorResult& aRv);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCPeerConnectionBinding_h__
