/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_WindowBinding_h__
#define mozilla_dom_WindowBinding_h__

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"

class nsGlobalWindow;

namespace mozilla {
namespace dom {

class FrameRequestCallback;
class NativePropertyHooks;
struct ScrollOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {


MOZ_BEGIN_ENUM_CLASS(ScrollBehavior, uint32_t)
  Auto,
  Instant,
  Smooth
MOZ_END_ENUM_CLASS(ScrollBehavior)

namespace ScrollBehaviorValues {
extern const EnumEntry strings[4];
} // namespace ScrollBehaviorValues


struct ScrollOptions : public MainThreadDictionaryBase
{
  ScrollBehavior mBehavior;

  ScrollOptions();

  explicit inline ScrollOptions(const ScrollOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ScrollOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ScrollOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ScrollOptions& aOther);
};

namespace dictionary_detail {
struct FastScrollOptions : public ScrollOptions
{
  inline FastScrollOptions()
    : ScrollOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


class FrameRequestCallback : public CallbackFunction
{
public:
  explicit inline FrameRequestCallback(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline FrameRequestCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, double time, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, time, aRv);
  }

  inline void
  Call(double time, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(CallbackPreserveColor(), aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), time, aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, double time, ErrorResult& aRv);
};


namespace WindowBinding {

  typedef nsGlobalWindow NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, nsGlobalWindow* aObject, nsWrapperCache* aCache, JS::CompartmentOptions& aOptions, JSPrincipals* aPrincipal);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Heap<JSObject*>* aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace WindowBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WindowBinding_h__
