/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RTCPeerConnectionBinding_h__
#define mozilla_dom_RTCPeerConnectionBinding_h__

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsDOMEventTargetHelper.h"
#include "nsWeakReference.h"

class JSObject;
class nsIDOMDataChannel;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class EventHandlerNonNull;
struct MediaConstraintSet;
struct MediaConstraintSetAtoms;
struct MediaConstraints;
struct MediaConstraintsAtoms;
struct MediaConstraintsInternalAtoms;
class MediaStreamTrack;
class NativePropertyHooks;
class ProtoAndIfaceArray;
struct RTCConfiguration;
struct RTCDataChannelInit;
struct RTCDataChannelInitAtoms;
class RTCLogCallback;
class RTCPeerConnectionErrorCallback;
class RTCSessionDescriptionCallback;
class RTCStatsCallback;
class RTCStatsReport;
class VoidFunction;
class WebrtcGlobalInformation;
class mozRTCIceCandidate;
class mozRTCPeerConnection;
class mozRTCSessionDescription;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {


MOZ_BEGIN_ENUM_CLASS(RTCSignalingState, uint32_t)
  Stable,
  Have_local_offer,
  Have_remote_offer,
  Have_local_pranswer,
  Have_remote_pranswer,
  Closed
MOZ_END_ENUM_CLASS(RTCSignalingState)

namespace RTCSignalingStateValues {
extern const EnumEntry strings[7];
} // namespace RTCSignalingStateValues



MOZ_BEGIN_ENUM_CLASS(RTCIceGatheringState, uint32_t)
  New,
  Gathering,
  Complete
MOZ_END_ENUM_CLASS(RTCIceGatheringState)

namespace RTCIceGatheringStateValues {
extern const EnumEntry strings[4];
} // namespace RTCIceGatheringStateValues



MOZ_BEGIN_ENUM_CLASS(RTCIceConnectionState, uint32_t)
  New,
  Checking,
  Connected,
  Completed,
  Failed,
  Disconnected,
  Closed
MOZ_END_ENUM_CLASS(RTCIceConnectionState)

namespace RTCIceConnectionStateValues {
extern const EnumEntry strings[8];
} // namespace RTCIceConnectionStateValues


struct MediaConstraintSet : public MainThreadDictionaryBase
{
  Optional<bool > mMozDontOfferDataChannel;
  Optional<bool > mOfferToReceiveAudio;
  Optional<bool > mOfferToReceiveVideo;

  MediaConstraintSet();

  explicit inline MediaConstraintSet(const MediaConstraintSet& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline MediaConstraintSet(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, MediaConstraintSetAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MediaConstraintSet& aOther);
};

namespace dictionary_detail {
struct FastMediaConstraintSet : public MediaConstraintSet
{
  inline FastMediaConstraintSet()
    : MediaConstraintSet(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct RTCDataChannelInit : public MainThreadDictionaryBase
{
  Nullable<uint16_t> mId;
  Optional<uint16_t > mMaxRetransmitNum;
  Nullable<uint16_t> mMaxRetransmitTime;
  Nullable<uint16_t> mMaxRetransmits;
  bool mNegotiated;
  bool mOrdered;
  Optional<bool > mOutOfOrderAllowed;
  Optional<bool > mPreset;
  nsString mProtocol;
  Optional<uint16_t > mStream;

  RTCDataChannelInit();

  explicit inline RTCDataChannelInit(const RTCDataChannelInit& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline RTCDataChannelInit(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCDataChannelInit& aOther);
};

namespace dictionary_detail {
struct FastRTCDataChannelInit : public RTCDataChannelInit
{
  inline FastRTCDataChannelInit()
    : RTCDataChannelInit(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct MediaConstraints : public MainThreadDictionaryBase
{
  Optional<JSObject* > mMandatory;
  Optional<Sequence<MediaConstraintSet > > mOptional;

  MediaConstraints();

protected:
  explicit inline MediaConstraints(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  MediaConstraints(const MediaConstraints&) MOZ_DELETE;
  void operator=(const MediaConstraints) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, MediaConstraintsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace dictionary_detail {
struct FastMediaConstraints : public MediaConstraints
{
  inline FastMediaConstraints()
    : MediaConstraints(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct MediaConstraintsInternal : public MainThreadDictionaryBase
{
  MediaConstraintSet mMandatory;
  Optional<Sequence<MediaConstraintSet > > mOptional;

  MediaConstraintsInternal();

  explicit inline MediaConstraintsInternal(const MediaConstraintsInternal& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline MediaConstraintsInternal(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, MediaConstraintsInternalAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MediaConstraintsInternal& aOther);
};

namespace dictionary_detail {
struct FastMediaConstraintsInternal : public MediaConstraintsInternal
{
  inline FastMediaConstraintsInternal()
    : MediaConstraintsInternal(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


class RTCSessionDescriptionCallback : public CallbackFunction
{
public:
  explicit inline RTCSessionDescriptionCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
  }

  explicit inline RTCSessionDescriptionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, mozilla::dom::mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, sdp, aRv);
  }

  inline void
  Call(mozilla::dom::mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), sdp, aRv);
  }

  inline bool
  operator==(const RTCSessionDescriptionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, mozilla::dom::mozRTCSessionDescription& sdp, ErrorResult& aRv);
};


class RTCPeerConnectionErrorCallback : public CallbackFunction
{
public:
  explicit inline RTCPeerConnectionErrorCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
  }

  explicit inline RTCPeerConnectionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, const nsAString& errorInformation, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, errorInformation, aRv);
  }

  inline void
  Call(const nsAString& errorInformation, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), errorInformation, aRv);
  }

  inline bool
  operator==(const RTCPeerConnectionErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, const nsAString& errorInformation, ErrorResult& aRv);
};


class VoidFunction : public CallbackFunction
{
public:
  explicit inline VoidFunction(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
  }

  explicit inline VoidFunction(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), aRv);
  }

  inline bool
  operator==(const VoidFunction& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, ErrorResult& aRv);
};


class RTCStatsCallback : public CallbackFunction
{
public:
  explicit inline RTCStatsCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
  }

  explicit inline RTCStatsCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, mozilla::dom::RTCStatsReport& report, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, report, aRv);
  }

  inline void
  Call(mozilla::dom::RTCStatsReport& report, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), report, aRv);
  }

  inline bool
  operator==(const RTCStatsCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, mozilla::dom::RTCStatsReport& report, ErrorResult& aRv);
};


class RTCLogCallback : public CallbackFunction
{
public:
  explicit inline RTCLogCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
  }

  explicit inline RTCLogCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, const Sequence<nsString >& logMessages, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, logMessages, aRv);
  }

  inline void
  Call(const Sequence<nsString >& logMessages, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), logMessages, aRv);
  }

  inline bool
  operator==(const RTCLogCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, const Sequence<nsString >& logMessages, ErrorResult& aRv);
};


namespace WebrtcGlobalInformationBinding {

  typedef mozilla::dom::WebrtcGlobalInformation NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::WebrtcGlobalInformation* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace WebrtcGlobalInformationBinding



namespace mozRTCPeerConnectionBinding {

  typedef mozilla::dom::mozRTCPeerConnection NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::mozRTCPeerConnection* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace mozRTCPeerConnectionBinding



class WebrtcGlobalInformationJSImpl : public CallbackInterface
{
public:
  explicit inline WebrtcGlobalInformationJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void GetAllStats(RTCStatsCallback& callback, RTCPeerConnectionErrorCallback& errorCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetCandPairLogs(const nsAString& candPairId, RTCLogCallback& callback, RTCPeerConnectionErrorCallback& errorCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const WebrtcGlobalInformationJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }
};


class WebrtcGlobalInformation MOZ_FINAL : public nsSupportsWeakReference,
                                          public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(WebrtcGlobalInformation)

private:
  nsRefPtr<WebrtcGlobalInformationJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  WebrtcGlobalInformation(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<WebrtcGlobalInformation> Constructor(const GlobalObject& global, JSContext* cx, ErrorResult& aRv);

  void GetAllStats(RTCStatsCallback& callback, RTCPeerConnectionErrorCallback& errorCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetCandPairLogs(const nsAString& candPairId, RTCLogCallback& callback, RTCPeerConnectionErrorCallback& errorCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class mozRTCPeerConnectionJSImpl : public CallbackInterface
{
public:
  explicit inline mozRTCPeerConnectionJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetLocalDescription(mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetRemoteDescription(mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void UpdateIce(const RTCConfiguration& configuration, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddIceCandidate(mozilla::dom::mozRTCIceCandidate& candidate, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<nsRefPtr<DOMMediaStream> >& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<nsRefPtr<DOMMediaStream> >& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(mozilla::DOMMediaStream& stream, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveStream(mozilla::DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStats(mozilla::dom::MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStatsInternal(mozilla::dom::MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const mozRTCPeerConnectionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnconnection(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnclosedconnection(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnconnection(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnclosedconnection(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class mozRTCPeerConnection MOZ_FINAL : public nsDOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(mozRTCPeerConnection, nsDOMEventTargetHelper)

private:
  nsRefPtr<mozRTCPeerConnectionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  mozRTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<mozRTCPeerConnection> Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*> >& constraints, ErrorResult& aRv);

  void CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetLocalDescription(mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetRemoteDescription(mozilla::dom::mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void UpdateIce(const RTCConfiguration& configuration, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddIceCandidate(mozilla::dom::mozRTCIceCandidate& candidate, const Optional<OwningNonNull<VoidFunction> >& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback> >& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetLocalStreams(nsTArray<// Mark this as resultNotAddRefed to return raw pointers
  nsRefPtr<DOMMediaStream> >& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<// Mark this as resultNotAddRefed to return raw pointers
  nsRefPtr<DOMMediaStream> >& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(mozilla::DOMMediaStream& stream, const MediaConstraints& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveStream(mozilla::DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStats(mozilla::dom::MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStatsInternal(mozilla::dom::MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnconnection(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnconnection(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnclosedconnection(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnclosedconnection(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCPeerConnectionBinding_h__
