/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_DataStoreBinding_h__
#define mozilla_dom_DataStoreBinding_h__

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionTypes.h"
#include "nsDOMEventTargetHelper.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class DataStore;
class DataStoreCursor;
struct DataStoreTaskAtoms;
class EventHandlerNonNull;
class NativePropertyHooks;
class OwningStringOrUnsignedLong;
class Promise;
class ProtoAndIfaceArray;
class StringOrUnsignedLong;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {


MOZ_BEGIN_ENUM_CLASS(DataStoreOperation, uint32_t)
  Add,
  Update,
  Remove,
  Clear,
  Done
MOZ_END_ENUM_CLASS(DataStoreOperation)

namespace DataStoreOperationValues {
extern const EnumEntry strings[6];
} // namespace DataStoreOperationValues


struct DataStoreTask : public MainThreadDictionaryBase
{
  Optional<JS::Value > mData;
  Optional<OwningStringOrUnsignedLong > mId;
  Optional<DataStoreOperation > mOperation;
  Optional<nsString > mRevisionId;

  DataStoreTask();

protected:
  explicit inline DataStoreTask(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  DataStoreTask(const DataStoreTask&) MOZ_DELETE;
  void operator=(const DataStoreTask) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, DataStoreTaskAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace dictionary_detail {
struct FastDataStoreTask : public DataStoreTask
{
  inline FastDataStoreTask()
    : DataStoreTask(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


namespace DataStoreBinding {

  typedef mozilla::dom::DataStore NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::DataStore* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreBinding



namespace DataStoreCursorBinding {

  typedef mozilla::dom::DataStoreCursor NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::DataStoreCursor* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreCursorBinding



class DataStoreJSImpl : public CallbackInterface
{
public:
  explicit inline DataStoreJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Get(const nsTArray<OwningStringOrUnsignedLong >& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Put(JS::Handle<JS::Value> obj, const StringOrUnsignedLong& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Add(JS::Handle<JS::Value> obj, const Optional<StringOrUnsignedLong >& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Remove(const StringOrUnsignedLong& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Clear(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetLength(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DataStoreCursor> Sync(const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DataStoreJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetName(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetOwner(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetReadOnly(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRevisionId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class DataStore MOZ_FINAL : public nsDOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(DataStore, nsDOMEventTargetHelper)

private:
  nsRefPtr<DataStoreJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DataStore(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  void GetName(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetOwner(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetReadOnly(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Get(const Sequence<OwningStringOrUnsignedLong >& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Put(JS::Handle<JS::Value> obj, const StringOrUnsignedLong& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Add(JS::Handle<JS::Value> obj, const Optional<StringOrUnsignedLong >& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Remove(const StringOrUnsignedLong& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Clear(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRevisionId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  already_AddRefed<EventHandlerNonNull> GetOnchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> GetLength(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DataStoreCursor> Sync(const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class DataStoreCursorJSImpl : public CallbackInterface
{
public:
  explicit inline DataStoreCursorJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DataStoreCursorJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<DataStore> GetStore(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class DataStoreCursor MOZ_FINAL : public nsSupportsWeakReference,
                                  public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(DataStoreCursor)

private:
  nsRefPtr<DataStoreCursorJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DataStoreCursor(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DataStore> GetStore(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DataStoreBinding_h__
