/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
// IWYU pragma: private, include "nsGkAtoms.h"

/*
  This file contains the list of all atoms used by gklayout;
  see nsGkAtoms for access to the atoms.
*/

/*
  This file is designed to be used as inline input to nsGkAtoms.cpp and nsGkAtoms.h
  *only* through the magic of C preprocessing.

  All entries must be enclosed in the macro GK_ATOM which will have cruel
  and unusual things done to it

  The first argument to GK_ATOM is the C++ name of the atom
  The second argument it GK_ATOM is the string value of the atom
*/

// OUTPUT_CLASS=nsGkAtoms
// MACRO_NAME=GK_ATOM
#ifdef small
#undef small
#endif

//---------------------------------------------------------------------------
// Generic atoms
//---------------------------------------------------------------------------

GK_ATOM(_empty, "")
GK_ATOM(moz, "_moz")
GK_ATOM(mozframetype, "mozframetype")
GK_ATOM(mozallowfullscreen, "mozallowfullscreen")
GK_ATOM(moztype, "_moz-type")
GK_ATOM(mozdirty, "_moz_dirty")
GK_ATOM(mozdisallowselectionprint, "mozdisallowselectionprint")
GK_ATOM(moznomarginboxes, "moznomarginboxes")
GK_ATOM(mozdonotsend, "moz-do-not-send")
GK_ATOM(mozeditorbogusnode, "_moz_editor_bogus_node")
GK_ATOM(mozgeneratedcontentbefore, "_moz_generated_content_before")
GK_ATOM(mozgeneratedcontentafter, "_moz_generated_content_after")
GK_ATOM(mozgeneratedcontentimage, "_moz_generated_content_image")
GK_ATOM(mozquote, "_moz_quote")
GK_ATOM(mozsignature, "moz-signature")
GK_ATOM(_moz_is_glyph, "-moz-is-glyph")
GK_ATOM(_moz_original_size, "_moz_original_size")
GK_ATOM(_moz_target, "_moz_target")
GK_ATOM(menuactive, "_moz-menuactive")
GK_ATOM(_poundDefault, "#default")
GK_ATOM(_asterix, "*")
GK_ATOM(a, "a")
GK_ATOM(abbr, "abbr")
GK_ATOM(abort, "abort")
GK_ATOM(above, "above")
GK_ATOM(acceltext, "acceltext")
GK_ATOM(accept, "accept")
GK_ATOM(acceptcharset, "accept-charset")
GK_ATOM(accesskey, "accesskey")
GK_ATOM(acronym, "acronym")
GK_ATOM(action, "action")
GK_ATOM(active, "active")
GK_ATOM(activetitlebarcolor, "activetitlebarcolor")
GK_ATOM(actuate, "actuate")
GK_ATOM(address, "address")
GK_ATOM(after, "after")
GK_ATOM(after_end, "after_end")
GK_ATOM(after_start, "after_start")
GK_ATOM(align, "align")
GK_ATOM(alink, "alink")
GK_ATOM(all, "all")
GK_ATOM(allowevents, "allowevents")
GK_ATOM(allownegativeassertions, "allownegativeassertions")
GK_ATOM(allowforms,"allow-forms")
GK_ATOM(allowfullscreen, "allowfullscreen")
GK_ATOM(allowpointerlock,"allow-pointer-lock")
GK_ATOM(allowpopups,"allow-popups")
GK_ATOM(allowsameorigin,"allow-same-origin")
GK_ATOM(allowscripts,"allow-scripts")
GK_ATOM(allowtopnavigation,"allow-top-navigation")
GK_ATOM(allowuntrusted, "allowuntrusted")
GK_ATOM(alt, "alt")
GK_ATOM(alternate, "alternate")
GK_ATOM(always, "always")
GK_ATOM(ancestor, "ancestor")
GK_ATOM(ancestorOrSelf, "ancestor-or-self")
GK_ATOM(anchor, "anchor")
GK_ATOM(_and, "and")
GK_ATOM(any, "any")
GK_ATOM(mozapp, "mozapp")
GK_ATOM(applet, "applet")
GK_ATOM(applyImports, "apply-imports")
GK_ATOM(applyTemplates, "apply-templates")
GK_ATOM(mozapptype, "mozapptype")
GK_ATOM(apz, "apz")
GK_ATOM(archive, "archive")
GK_ATOM(area, "area")
GK_ATOM(arrow, "arrow")
GK_ATOM(article, "article")
GK_ATOM(ascending, "ascending")
GK_ATOM(aside, "aside")
GK_ATOM(aspectRatio, "aspect-ratio")
GK_ATOM(assign, "assign")
GK_ATOM(async, "async")
GK_ATOM(attribute, "attribute")
GK_ATOM(attributeSet, "attribute-set")
GK_ATOM(aural, "aural")
GK_ATOM(_auto, "auto")
GK_ATOM(autocheck, "autocheck")
GK_ATOM(autocomplete, "autocomplete")
GK_ATOM(autofocus, "autofocus")
GK_ATOM(autoplay, "autoplay")
GK_ATOM(autorepeatbutton, "autorepeatbutton")
GK_ATOM(axis, "axis")
GK_ATOM(b, "b")
GK_ATOM(background, "background")
GK_ATOM(base, "base")
GK_ATOM(basefont, "basefont")
GK_ATOM(baseline, "baseline")
GK_ATOM(bdi, "bdi")
GK_ATOM(bdo, "bdo")
GK_ATOM(before, "before")
GK_ATOM(before_end, "before_end")
GK_ATOM(before_start, "before_start")
GK_ATOM(below, "below")
GK_ATOM(bgcolor, "bgcolor")
GK_ATOM(bgsound, "bgsound")
GK_ATOM(big, "big")
GK_ATOM(binding, "binding")
GK_ATOM(bindings, "bindings")
GK_ATOM(blankrow, "blankrow")
GK_ATOM(block, "block")
GK_ATOM(blockquote, "blockquote")
GK_ATOM(blur, "blur")
GK_ATOM(body, "body")
GK_ATOM(boolean, "boolean")
GK_ATOM(border, "border")
GK_ATOM(bordercolor, "bordercolor")
GK_ATOM(both, "both")
GK_ATOM(bottom, "bottom")
GK_ATOM(bottomend, "bottomend")
GK_ATOM(bottomstart, "bottomstart")
GK_ATOM(bottomleft, "bottomleft")
GK_ATOM(bottommargin, "bottommargin")
GK_ATOM(bottompadding, "bottompadding")
GK_ATOM(bottomright, "bottomright")
GK_ATOM(box, "box")
GK_ATOM(br, "br")
GK_ATOM(braille, "braille")
GK_ATOM(broadcast, "broadcast")
GK_ATOM(broadcaster, "broadcaster")
GK_ATOM(broadcasterset, "broadcasterset")
GK_ATOM(browser, "browser")
GK_ATOM(mozbrowser, "mozbrowser")
GK_ATOM(bulletinboard, "bulletinboard")
GK_ATOM(button, "button")
GK_ATOM(callTemplate, "call-template")
GK_ATOM(cancel, "cancel")
GK_ATOM(canvas, "canvas")
GK_ATOM(caption, "caption")
GK_ATOM(capture, "capture")
GK_ATOM(caseOrder, "case-order")
GK_ATOM(cdataSectionElements, "cdata-section-elements")
GK_ATOM(ceiling, "ceiling")
GK_ATOM(cell, "cell")
GK_ATOM(cellpadding, "cellpadding")
GK_ATOM(cellspacing, "cellspacing")
GK_ATOM(center, "center")
GK_ATOM(ch, "ch")
GK_ATOM(change, "change")
GK_ATOM(_char, "char")
GK_ATOM(charcode, "charcode")
GK_ATOM(charoff, "charoff")
GK_ATOM(charset, "charset")
GK_ATOM(checkbox, "checkbox")
GK_ATOM(checked, "checked")
GK_ATOM(child, "child")
GK_ATOM(children, "children")
GK_ATOM(choose, "choose")
GK_ATOM(chromemargin, "chromemargin")
GK_ATOM(chromeOnlyContent, "chromeOnlyContent")
GK_ATOM(exposeToUntrustedContent, "exposeToUntrustedContent")
GK_ATOM(circ, "circ")
GK_ATOM(circle, "circle")
GK_ATOM(cite, "cite")
GK_ATOM(_class, "class")
GK_ATOM(classid, "classid")
GK_ATOM(clear, "clear")
GK_ATOM(click, "click")
GK_ATOM(clickcount, "clickcount")
GK_ATOM(clickthrough, "clickthrough")
GK_ATOM(movetoclick, "movetoclick")
GK_ATOM(clip, "clip")
GK_ATOM(close, "close")
GK_ATOM(closed, "closed")
GK_ATOM(closemenu, "closemenu")
GK_ATOM(coalesceduplicatearcs, "coalesceduplicatearcs")
GK_ATOM(code, "code")
GK_ATOM(codebase, "codebase")
GK_ATOM(codetype, "codetype")
GK_ATOM(col, "col")
GK_ATOM(colgroup, "colgroup")
GK_ATOM(collapse, "collapse")
GK_ATOM(collapsed, "collapsed")
GK_ATOM(color, "color")
GK_ATOM(colorIndex, "color-index")
GK_ATOM(cols, "cols")
GK_ATOM(colspan, "colspan")
GK_ATOM(column, "column")
GK_ATOM(columns, "columns")
GK_ATOM(combobox, "combobox")
GK_ATOM(command, "command")
GK_ATOM(commands, "commands")
GK_ATOM(commandset, "commandset")
GK_ATOM(commandupdate, "commandupdate")
GK_ATOM(commandupdater, "commandupdater")
GK_ATOM(comment, "comment")
GK_ATOM(compact, "compact")
GK_ATOM(concat, "concat")
GK_ATOM(conditions, "conditions")
GK_ATOM(constructor, "constructor")
GK_ATOM(consumeoutsideclicks, "consumeoutsideclicks")
GK_ATOM(container, "container")
GK_ATOM(containment, "containment")
GK_ATOM(contains, "contains")
GK_ATOM(content, "content")
GK_ATOM(contenteditable, "contenteditable")
GK_ATOM(headerContentDisposition, "content-disposition")
GK_ATOM(headerContentLanguage, "content-language")
GK_ATOM(contentLocation, "content-location")
GK_ATOM(headerContentScriptType, "content-script-type")
GK_ATOM(headerContentStyleType, "content-style-type")
GK_ATOM(headerContentType, "content-type")
GK_ATOM(context, "context")
GK_ATOM(contextmenu, "contextmenu")
GK_ATOM(control, "control")
GK_ATOM(controls, "controls")
GK_ATOM(coords, "coords")
GK_ATOM(copy, "copy")
GK_ATOM(copyOf, "copy-of")
GK_ATOM(count, "count")
GK_ATOM(crop, "crop")
GK_ATOM(crossorigin, "crossorigin")
GK_ATOM(curpos, "curpos")
GK_ATOM(current, "current")
GK_ATOM(cycler, "cycler")
GK_ATOM(data, "data")
GK_ATOM(datalist, "datalist")
GK_ATOM(dataType, "data-type")
GK_ATOM(dateTime, "date-time")
GK_ATOM(datasources, "datasources")
GK_ATOM(datetime, "datetime")
GK_ATOM(dblclick, "dblclick")
GK_ATOM(dd, "dd")
GK_ATOM(debug, "debug")
GK_ATOM(decimalFormat, "decimal-format")
GK_ATOM(decimalSeparator, "decimal-separator")
GK_ATOM(deck, "deck")
GK_ATOM(declare, "declare")
GK_ATOM(decrement, "decrement")
GK_ATOM(_default, "default")
GK_ATOM(headerDefaultStyle, "default-style")
GK_ATOM(defaultAction, "defaultAction")
GK_ATOM(defaultchecked, "defaultchecked")
GK_ATOM(defaultLabel, "defaultLabel")
GK_ATOM(defaultselected, "defaultselected")
GK_ATOM(defaultvalue, "defaultvalue")
GK_ATOM(defaultplaybackrate, "defaultplaybackrate")
GK_ATOM(defer, "defer")
GK_ATOM(del, "del")
GK_ATOM(descendant, "descendant")
GK_ATOM(descendantOrSelf, "descendant-or-self")
GK_ATOM(descending, "descending")
GK_ATOM(description, "description")
GK_ATOM(destructor, "destructor")
GK_ATOM(details, "details")
GK_ATOM(deviceAspectRatio, "device-aspect-ratio")
GK_ATOM(deviceHeight, "device-height")
GK_ATOM(deviceWidth, "device-width")
GK_ATOM(dfn, "dfn")
GK_ATOM(dialog, "dialog")
GK_ATOM(difference, "difference")
GK_ATOM(digit, "digit")
GK_ATOM(dir, "dir")
GK_ATOM(dirAutoSetBy, "dirAutoSetBy")
GK_ATOM(directionality, "directionality")
GK_ATOM(disableOutputEscaping, "disable-output-escaping")
GK_ATOM(disabled, "disabled")
GK_ATOM(display, "display")
GK_ATOM(distinct, "distinct")
GK_ATOM(div, "div")
GK_ATOM(dl, "dl")
GK_ATOM(doctypePublic, "doctype-public")
GK_ATOM(doctypeSystem, "doctype-system")
GK_ATOM(document, "document")
GK_ATOM(download, "download")
GK_ATOM(DOMAttrModified, "DOMAttrModified")
GK_ATOM(DOMCharacterDataModified, "DOMCharacterDataModified")
GK_ATOM(DOMNodeInserted, "DOMNodeInserted")
GK_ATOM(DOMNodeInsertedIntoDocument, "DOMNodeInsertedIntoDocument")
GK_ATOM(DOMNodeRemoved, "DOMNodeRemoved")
GK_ATOM(DOMNodeRemovedFromDocument, "DOMNodeRemovedFromDocument")
GK_ATOM(DOMSubtreeModified, "DOMSubtreeModified")
GK_ATOM(double_, "double")
GK_ATOM(drag, "drag")
GK_ATOM(dragdrop, "dragdrop")
GK_ATOM(dragend, "dragend")
GK_ATOM(dragenter, "dragenter")
GK_ATOM(dragevent, "dragevent")
GK_ATOM(dragexit, "dragexit")
GK_ATOM(draggable, "draggable")
GK_ATOM(draggesture, "draggesture")
GK_ATOM(dragging, "dragging")
GK_ATOM(dragleave, "dragleave")
GK_ATOM(dragover, "dragover")
GK_ATOM(dragSession, "dragSession")
GK_ATOM(dragstart, "dragstart")
GK_ATOM(drawintitlebar, "drawintitlebar")
GK_ATOM(drawtitle, "drawtitle")
GK_ATOM(drop, "drop")
GK_ATOM(dropAfter, "dropAfter")
GK_ATOM(dropBefore, "dropBefore")
GK_ATOM(dropOn, "dropOn")
GK_ATOM(dropMarker, "dropmarker")
GK_ATOM(dt, "dt")
GK_ATOM(editable, "editable")
GK_ATOM(editing, "editing")
GK_ATOM(editor, "editor")
GK_ATOM(editorDisplayList, "EditorDisplay-List")
GK_ATOM(element, "element")
GK_ATOM(elementAvailable, "element-available")
GK_ATOM(elements, "elements")
GK_ATOM(em, "em")
GK_ATOM(embed, "embed")
GK_ATOM(embossed, "embossed")
GK_ATOM(empty, "empty")
GK_ATOM(encoding, "encoding")
GK_ATOM(enctype, "enctype")
GK_ATOM(end, "end")
GK_ATOM(endEvent, "endEvent")
GK_ATOM(end_after, "end_after")
GK_ATOM(end_before, "end_before")
GK_ATOM(equalsize, "equalsize")
GK_ATOM(error, "error")
GK_ATOM(even, "even")
GK_ATOM(event, "event")
GK_ATOM(events, "events")
GK_ATOM(excludeResultPrefixes, "exclude-result-prefixes")
GK_ATOM(excludes, "excludes")
GK_ATOM(expr, "expr")
GK_ATOM(expectingSystemMessage, "expecting-system-message")
GK_ATOM(extends, "extends")
GK_ATOM(extensionElementPrefixes, "extension-element-prefixes")
GK_ATOM(face, "face")
GK_ATOM(fallback, "fallback")
GK_ATOM(_false, "false")
GK_ATOM(farthest, "farthest")
GK_ATOM(field, "field")
GK_ATOM(fieldset, "fieldset")
GK_ATOM(figcaption, "figcaption")
GK_ATOM(figure, "figure")
GK_ATOM(fixed, "fixed")
GK_ATOM(flags, "flags")
GK_ATOM(flex, "flex")
GK_ATOM(flexgroup, "flexgroup")
GK_ATOM(flip, "flip")
GK_ATOM(floating, "floating")
GK_ATOM(floor, "floor")
GK_ATOM(flowlength, "flowlength")
GK_ATOM(focus, "focus")
GK_ATOM(focused, "focused")
GK_ATOM(following, "following")
GK_ATOM(followingSibling, "following-sibling")
GK_ATOM(font, "font")
GK_ATOM(fontWeight, "font-weight")
GK_ATOM(fontpicker, "fontpicker")
GK_ATOM(footer, "footer")
GK_ATOM(_for, "for")
GK_ATOM(forEach, "for-each")
GK_ATOM(forceOwnRefreshDriver, "forceOwnRefreshDriver")
GK_ATOM(form, "form")
GK_ATOM(formaction, "formaction")
GK_ATOM(format, "format")
GK_ATOM(formatNumber, "format-number")
GK_ATOM(formenctype, "formenctype")
GK_ATOM(formmethod, "formmethod")
GK_ATOM(formnovalidate, "formnovalidate")
GK_ATOM(formtarget, "formtarget")
GK_ATOM(frame, "frame")
GK_ATOM(frameborder, "frameborder")
GK_ATOM(frameset, "frameset")
GK_ATOM(from, "from")
GK_ATOM(functionAvailable, "function-available")
GK_ATOM(generateId, "generate-id")
GK_ATOM(getter, "getter")
GK_ATOM(glyphchar, "glyphchar")
GK_ATOM(glyphid, "glyphid")
GK_ATOM(grid, "grid")
GK_ATOM(grippy, "grippy")
GK_ATOM(group, "group")
GK_ATOM(groupingSeparator, "grouping-separator")
GK_ATOM(groupingSize, "grouping-size")
GK_ATOM(grow, "grow")
GK_ATOM(gutter, "gutter")
GK_ATOM(h1, "h1")
GK_ATOM(h2, "h2")
GK_ATOM(h3, "h3")
GK_ATOM(h4, "h4")
GK_ATOM(h5, "h5")
GK_ATOM(h6, "h6")
GK_ATOM(handheld, "handheld")
GK_ATOM(handheldFriendly, "HandheldFriendly")
GK_ATOM(handler, "handler")
GK_ATOM(handlers, "handlers")
GK_ATOM(HARD, "HARD")
GK_ATOM(hasSameNode, "has-same-node")
GK_ATOM(hbox, "hbox")
GK_ATOM(head, "head")
GK_ATOM(header, "header")
GK_ATOM(headers, "headers")
GK_ATOM(height, "height")
GK_ATOM(hgroup, "hgroup")
GK_ATOM(hidden, "hidden")
GK_ATOM(hidechrome, "hidechrome")
GK_ATOM(hidecolumnpicker, "hidecolumnpicker")
GK_ATOM(high, "high")
GK_ATOM(highest, "highest")
GK_ATOM(horizontal, "horizontal")
GK_ATOM(hover, "hover")
GK_ATOM(hr, "hr")
GK_ATOM(href, "href")
GK_ATOM(hreflang, "hreflang")
GK_ATOM(hspace, "hspace")
GK_ATOM(html, "html")
GK_ATOM(httpEquiv, "http-equiv")
GK_ATOM(i, "i")
GK_ATOM(icon, "icon")
GK_ATOM(id, "id")
GK_ATOM(_if, "if")
GK_ATOM(iframe, "iframe")
GK_ATOM(ignorecase, "ignorecase")
GK_ATOM(ignorekeys, "ignorekeys")
GK_ATOM(ignoreuserfocus, "ignoreuserfocus")
GK_ATOM(ilayer, "ilayer")
GK_ATOM(image, "image")
GK_ATOM(imageClickedPoint, "image-clicked-point")
GK_ATOM(img, "img")
GK_ATOM(implementation, "implementation")
GK_ATOM(implements, "implements")
GK_ATOM(import, "import")
GK_ATOM(inactivetitlebarcolor, "inactivetitlebarcolor")
GK_ATOM(include, "include")
GK_ATOM(includes, "includes")
GK_ATOM(increment, "increment")
GK_ATOM(indent, "indent")
GK_ATOM(indeterminate, "indeterminate")
GK_ATOM(index, "index")
GK_ATOM(infer, "infer")
GK_ATOM(infinity, "infinity")
GK_ATOM(inherit, "inherit")
GK_ATOM(inherits, "inherits")
GK_ATOM(inheritstyle, "inheritstyle")
GK_ATOM(initial_scale, "initial-scale")
GK_ATOM(input, "input")
GK_ATOM(inputmode, "inputmode")
GK_ATOM(ins, "ins")
GK_ATOM(insertafter, "insertafter")
GK_ATOM(insertbefore, "insertbefore")
GK_ATOM(instanceOf, "instanceOf")
GK_ATOM(int32, "int32")
GK_ATOM(int64, "int64")
GK_ATOM(integer, "integer")
GK_ATOM(intersection, "intersection")
GK_ATOM(iscontainer, "iscontainer")
GK_ATOM(isempty, "isempty")
GK_ATOM(ismap, "ismap")
GK_ATOM(itemid, "itemid")
GK_ATOM(itemprop, "itemprop")
GK_ATOM(itemref, "itemref")
GK_ATOM(itemscope, "itemscope")
GK_ATOM(itemtype, "itemtype")
GK_ATOM(kbd, "kbd")
GK_ATOM(noautofocus, "noautofocus")
GK_ATOM(keepcurrentinview, "keepcurrentinview")
GK_ATOM(keepobjectsalive, "keepobjectsalive")
GK_ATOM(key, "key")
GK_ATOM(keycode, "keycode")
GK_ATOM(keydown, "keydown")
GK_ATOM(keygen, "keygen")
GK_ATOM(keypress, "keypress")
GK_ATOM(keyset, "keyset")
GK_ATOM(keytext, "keytext")
GK_ATOM(keyup, "keyup")
GK_ATOM(kind, "kind")
GK_ATOM(label, "label")
GK_ATOM(lang, "lang")
GK_ATOM(language, "language")
GK_ATOM(last, "last")
GK_ATOM(layer, "layer")
GK_ATOM(layout, "layout")
GK_ATOM(leading, "leading")
GK_ATOM(leaf, "leaf")
GK_ATOM(left, "left")
GK_ATOM(leftmargin, "leftmargin")
GK_ATOM(leftpadding, "leftpadding")
GK_ATOM(legend, "legend")
GK_ATOM(length, "length")
GK_ATOM(letterValue, "letter-value")
GK_ATOM(level, "level")
GK_ATOM(li, "li")
GK_ATOM(line, "line")
GK_ATOM(link, "link")
GK_ATOM(list, "list")
GK_ATOM(listbox, "listbox")
GK_ATOM(listboxbody, "listboxbody")
GK_ATOM(listcell, "listcell")
GK_ATOM(listcol, "listcol")
GK_ATOM(listcols, "listcols")
GK_ATOM(listener, "listener")
GK_ATOM(listhead, "listhead")
GK_ATOM(listheader, "listheader")
GK_ATOM(listing, "listing")
GK_ATOM(listitem, "listitem")
GK_ATOM(listrows, "listrows")
GK_ATOM(load, "load")
GK_ATOM(localedir, "localedir")
GK_ATOM(localName, "local-name")
GK_ATOM(longdesc, "longdesc")
GK_ATOM(loop, "loop")
GK_ATOM(low, "low")
GK_ATOM(lowerFirst, "lower-first")
GK_ATOM(lowest, "lowest")
GK_ATOM(lowsrc, "lowsrc")
GK_ATOM(ltr, "ltr")
GK_ATOM(lwtheme, "lwtheme")
GK_ATOM(lwthemetextcolor, "lwthemetextcolor")
GK_ATOM(main, "main")
GK_ATOM(map, "map")
GK_ATOM(manifest, "manifest")
GK_ATOM(marginheight, "marginheight")
GK_ATOM(marginwidth, "marginwidth")
GK_ATOM(mark, "mark")
GK_ATOM(marquee, "marquee")
GK_ATOM(match, "match")
GK_ATOM(max, "max")
GK_ATOM(maxheight, "maxheight")
GK_ATOM(maximum_scale, "maximum-scale")
GK_ATOM(maxlength, "maxlength")
GK_ATOM(maxpos, "maxpos")
GK_ATOM(maxwidth, "maxwidth")
GK_ATOM(mayscript, "mayscript")
GK_ATOM(media, "media")
GK_ATOM(mediaType, "media-type")
GK_ATOM(member, "member")
GK_ATOM(menu, "menu")
GK_ATOM(menubar, "menubar")
GK_ATOM(menubutton, "menubutton")
GK_ATOM(menuButton, "menu-button")
GK_ATOM(menuitem, "menuitem")
GK_ATOM(menulist, "menulist")
GK_ATOM(menupopup, "menupopup")
GK_ATOM(menuseparator, "menuseparator")
GK_ATOM(message, "message")
GK_ATOM(meta, "meta")
GK_ATOM(meter, "meter")
GK_ATOM(method, "method")
GK_ATOM(microdataProperties, "microdataProperties")
GK_ATOM(middle, "middle")
GK_ATOM(min, "min")
GK_ATOM(minheight, "minheight")
GK_ATOM(minimum_scale, "minimum-scale")
GK_ATOM(minpos, "minpos")
GK_ATOM(minusSign, "minus-sign")
GK_ATOM(minwidth, "minwidth")
GK_ATOM(mod, "mod")
GK_ATOM(mode, "mode")
GK_ATOM(modifiers, "modifiers")
GK_ATOM(monochrome, "monochrome")
GK_ATOM(mousedown, "mousedown")
GK_ATOM(mousemove, "mousemove")
GK_ATOM(mouseout, "mouseout")
GK_ATOM(mouseover, "mouseover")
GK_ATOM(mousethrough, "mousethrough")
GK_ATOM(mouseup, "mouseup")
GK_ATOM(mozaudiochannel, "mozaudiochannel")
GK_ATOM(mozasyncpanzoom, "mozasyncpanzoom")
GK_ATOM(mozfullscreenchange, "mozfullscreenchange")
GK_ATOM(mozfullscreenerror, "mozfullscreenerror")
GK_ATOM(mozpasspointerevents, "mozpasspointerevents")
GK_ATOM(mozpointerlockchange, "mozpointerlockchange")
GK_ATOM(mozpointerlockerror, "mozpointerlockerror")
GK_ATOM(moz_opaque, "moz-opaque")
GK_ATOM(moz_action_hint, "mozactionhint")
GK_ATOM(x_moz_errormessage, "x-moz-errormessage")
GK_ATOM(msthemecompatible, "msthemecompatible")
GK_ATOM(multicol, "multicol")
GK_ATOM(multiple, "multiple")
GK_ATOM(muted, "muted")
GK_ATOM(name, "name")
GK_ATOM(_namespace, "namespace")
GK_ATOM(namespaceAlias, "namespace-alias")
GK_ATOM(namespaceUri, "namespace-uri")
GK_ATOM(NaN, "NaN")
GK_ATOM(nav, "nav")
GK_ATOM(negate, "negate")
GK_ATOM(never, "never")
GK_ATOM(_new, "new")
GK_ATOM(newline, "newline")
GK_ATOM(nextBidi, "NextBidi")
GK_ATOM(no, "no")
GK_ATOM(noautohide, "noautohide")
GK_ATOM(nobr, "nobr")
GK_ATOM(node, "node")
GK_ATOM(nodefaultsrc, "nodefaultsrc")
GK_ATOM(nodeSet, "node-set")
GK_ATOM(noembed, "noembed")
GK_ATOM(noframes, "noframes")
GK_ATOM(nohref, "nohref")
GK_ATOM(nonce, "nonce")
GK_ATOM(none, "none")
GK_ATOM(noresize, "noresize")
GK_ATOM(normal, "normal")
GK_ATOM(normalizeSpace, "normalize-space")
GK_ATOM(noscript, "noscript")
GK_ATOM(noshade, "noshade")
GK_ATOM(novalidate, "novalidate")
GK_ATOM(_not, "not")
GK_ATOM(nowrap, "nowrap")
GK_ATOM(number, "number")
GK_ATOM(null, "null")
GK_ATOM(object, "object")
GK_ATOM(objectType, "object-type")
GK_ATOM(observer, "observer")
GK_ATOM(observes, "observes")
GK_ATOM(odd, "odd")
GK_ATOM(OFF, "OFF")
GK_ATOM(ol, "ol")
GK_ATOM(omitXmlDeclaration, "omit-xml-declaration")
GK_ATOM(ona2dpstatuschanged, "ona2dpstatuschanged")
GK_ATOM(onabort, "onabort")
GK_ATOM(onadapteradded, "onadapteradded")
GK_ATOM(onafterprint, "onafterprint")
GK_ATOM(onafterscriptexecute, "onafterscriptexecute")
GK_ATOM(onalerting, "onalerting")
GK_ATOM(onanimationend, "onanimationend")
GK_ATOM(onanimationiteration, "onanimationiteration")
GK_ATOM(onanimationstart, "onanimationstart")
GK_ATOM(onantennaavailablechange, "onantennaavailablechange")
GK_ATOM(onAppCommand, "onAppCommand")
GK_ATOM(onaudioprocess, "onaudioprocess")
GK_ATOM(onbeforecopy, "onbeforecopy")
GK_ATOM(onbeforecut, "onbeforecut")
GK_ATOM(onbeforepaste, "onbeforepaste")
GK_ATOM(onbeforeprint, "onbeforeprint")
GK_ATOM(onbeforescriptexecute, "onbeforescriptexecute")
GK_ATOM(onbeforeunload, "onbeforeunload")
GK_ATOM(onblocked, "onblocked")
GK_ATOM(onblur, "onblur")
GK_ATOM(onbroadcast, "onbroadcast")
GK_ATOM(onbusy, "onbusy")
GK_ATOM(oncached, "oncached")
GK_ATOM(oncallschanged, "oncallschanged")
GK_ATOM(oncardstatechange, "oncardstatechange")
GK_ATOM(oncfstatechange, "oncfstatechange")
GK_ATOM(onchange, "onchange")
GK_ATOM(onchargingchange, "onchargingchange")
GK_ATOM(onchargingtimechange, "onchargingtimechange")
GK_ATOM(onchecking, "onchecking")
GK_ATOM(onclick, "onclick")
GK_ATOM(onclose, "onclose")
GK_ATOM(oncommand, "oncommand")
GK_ATOM(oncommandupdate, "oncommandupdate")
GK_ATOM(oncomplete, "oncomplete")
GK_ATOM(oncompositionend, "oncompositionend")
GK_ATOM(oncompositionstart, "oncompositionstart")
GK_ATOM(oncompositionupdate, "oncompositionupdate")
GK_ATOM(onconnect, "onconnect")
GK_ATOM(onconnected, "onconnected")
GK_ATOM(onconnecting, "onconnecting")
GK_ATOM(oncontextmenu, "oncontextmenu")
GK_ATOM(oncopy, "oncopy")
GK_ATOM(oncut, "oncut")
GK_ATOM(ondatachange, "ondatachange")
GK_ATOM(ondataerror, "ondataerror")
GK_ATOM(ondblclick, "ondblclick")
GK_ATOM(ondeliverysuccess, "ondeliverysuccess")
GK_ATOM(ondeliveryerror, "ondeliveryerror")
GK_ATOM(ondevicefound, "ondevicefound")
GK_ATOM(ondialing, "ondialing")
GK_ATOM(ondisabled, "ondisabled")
GK_ATOM(ondischargingtimechange, "ondischargingtimechange")
GK_ATOM(ondisconnected, "ondisconnected")
GK_ATOM(ondisconnecting, "ondisconnecting")
GK_ATOM(ondownloading, "ondownloading")
GK_ATOM(onDOMActivate, "onDOMActivate")
GK_ATOM(onDOMAttrModified, "onDOMAttrModified")
GK_ATOM(onDOMCharacterDataModified, "onDOMCharacterDataModified")
GK_ATOM(onDOMFocusIn, "onDOMFocusIn")
GK_ATOM(onDOMFocusOut, "onDOMFocusOut")
GK_ATOM(onDOMMouseScroll, "onDOMMouseScroll")
GK_ATOM(onDOMNodeInserted, "onDOMNodeInserted")
GK_ATOM(onDOMNodeInsertedIntoDocument, "onDOMNodeInsertedIntoDocument")
GK_ATOM(onDOMNodeRemoved, "onDOMNodeRemoved")
GK_ATOM(onDOMNodeRemovedFromDocument, "onDOMNodeRemovedFromDocument")
GK_ATOM(onDOMSubtreeModified, "onDOMSubtreeModified")
GK_ATOM(ondrag, "ondrag")
GK_ATOM(ondragdrop, "ondragdrop")
GK_ATOM(ondragend, "ondragend")
GK_ATOM(ondragenter, "ondragenter")
GK_ATOM(ondragexit, "ondragexit")
GK_ATOM(ondraggesture, "ondraggesture")
GK_ATOM(ondragleave, "ondragleave")
GK_ATOM(ondragover, "ondragover")
GK_ATOM(ondragstart, "ondragstart")
GK_ATOM(ondrop, "ondrop")
GK_ATOM(onenabled, "onenabled")
GK_ATOM(onemergencycbmodechange, "onemergencycbmodechange")
GK_ATOM(onerror, "onerror")
GK_ATOM(onfailed, "onfailed")
GK_ATOM(onfocus, "onfocus")
GK_ATOM(onfrequencychange, "onfrequencychange")
GK_ATOM(onspeakerforcedchange, "onspeakerforcedchange")
GK_ATOM(onget, "onget")
GK_ATOM(ongroupchange, "ongroupchange")
GK_ATOM(onhashchange, "onhashchange")
GK_ATOM(onheadphoneschange, "onheadphoneschange")
GK_ATOM(onheld, "onheld")
GK_ATOM(onhfpstatuschanged, "onhfpstatuschanged")
GK_ATOM(onholding, "onholding")
GK_ATOM(oniccchange, "oniccchange")
GK_ATOM(oniccdetected, "oniccdetected")
GK_ATOM(oniccinfochange, "oniccinfochange")
GK_ATOM(oniccundetected, "oniccundetected")
GK_ATOM(onincoming, "onincoming")
GK_ATOM(oninput, "oninput")
GK_ATOM(oninvalid, "oninvalid")
GK_ATOM(onkeydown, "onkeydown")
GK_ATOM(onkeypress, "onkeypress")
GK_ATOM(onkeyup, "onkeyup")
GK_ATOM(onlevelchange, "onlevelchange")
GK_ATOM(onLoad, "onLoad")
GK_ATOM(onload, "onload")
GK_ATOM(onpopstate, "onpopstate")
GK_ATOM(only, "only")               // this one is not an event
GK_ATOM(onmessage, "onmessage")
GK_ATOM(onmousedown, "onmousedown")
GK_ATOM(onmouseenter, "onmouseenter")
GK_ATOM(onmouseleave, "onmouseleave")
GK_ATOM(onmousemove, "onmousemove")
GK_ATOM(onmouseout, "onmouseout")
GK_ATOM(onmouseover, "onmouseover")
GK_ATOM(onMozMouseHittest, "onMozMouseHittest")
GK_ATOM(onmouseup, "onmouseup")
GK_ATOM(onMozAfterPaint, "onMozAfterPaint")
GK_ATOM(onmozfullscreenchange, "onmozfullscreenchange")
GK_ATOM(onmozfullscreenerror, "onmozfullscreenerror")
GK_ATOM(onmozpointerlockchange, "onmozpointerlockchange")
GK_ATOM(onmozpointerlockerror, "onmozpointerlockerror")
GK_ATOM(onmoztimechange, "onmoztimechange")
GK_ATOM(onMozMousePixelScroll, "onMozMousePixelScroll")
GK_ATOM(onMozScrolledAreaChanged, "onMozScrolledAreaChanged")
GK_ATOM(onmoznetworkupload, "onmoznetworkupload")
GK_ATOM(onmoznetworkdownload, "onmoznetworkdownload")
GK_ATOM(onnoupdate, "onnoupdate")
GK_ATOM(onobsolete, "onobsolete")
GK_ATOM(ononline, "ononline")
GK_ATOM(onoffline, "onoffline")
GK_ATOM(onopen, "onopen")
GK_ATOM(onotastatuschange, "onotastatuschange")
GK_ATOM(onoverflow, "onoverflow")
GK_ATOM(onoverflowchanged, "onoverflowchanged")
GK_ATOM(onpagehide, "onpagehide")
GK_ATOM(onpageshow, "onpageshow")
GK_ATOM(onpaint, "onpaint")
GK_ATOM(onpairedstatuschanged, "onpairedstatuschanged")
GK_ATOM(onpaste, "onpaste")
GK_ATOM(onpopuphidden, "onpopuphidden")
GK_ATOM(onpopuphiding, "onpopuphiding")
GK_ATOM(onpopupshowing, "onpopupshowing")
GK_ATOM(onpopupshown, "onpopupshown")
GK_ATOM(onradiostatechange, "onradiostatechange")
GK_ATOM(onreaderror, "onreaderror")
GK_ATOM(onreadsuccess, "onreadsuccess")
GK_ATOM(onreadystatechange, "onreadystatechange")
GK_ATOM(onreceived, "onreceived")
GK_ATOM(onremoteheld, "onremoteheld")
GK_ATOM(onremoteresumed, "onremoteresumed")
GK_ATOM(onretrieving, "onretrieving")
GK_ATOM(onRequest, "onRequest")
GK_ATOM(onrequestmediaplaystatus, "onrequestmediaplaystatus")
GK_ATOM(onreset, "onreset")
GK_ATOM(onresuming, "onresuming")
GK_ATOM(onresize, "onresize")
GK_ATOM(onscostatuschanged, "onscostatuschanged")
GK_ATOM(onscroll, "onscroll")
GK_ATOM(onselect, "onselect")
GK_ATOM(onsending, "onsending")
GK_ATOM(onsent, "onsent")
GK_ATOM(onset, "onset")
GK_ATOM(onshow, "onshow")
GK_ATOM(onstatechange, "onstatechange")
GK_ATOM(onstatuschanged, "onstatuschanged")
GK_ATOM(onstkcommand, "onstkcommand")
GK_ATOM(onstksessionend, "onstksessionend")
GK_ATOM(onsubmit, "onsubmit")
GK_ATOM(onsuccess, "onsuccess")
GK_ATOM(ontext, "ontext")
GK_ATOM(ontouchstart, "ontouchstart")
GK_ATOM(ontouchend, "ontouchend")
GK_ATOM(ontouchmove, "ontouchmove")
GK_ATOM(ontouchenter, "ontouchenter")
GK_ATOM(ontouchleave, "ontouchleave")
GK_ATOM(ontouchcancel, "ontouchcancel")
GK_ATOM(ontransitionend, "ontransitionend")
GK_ATOM(onunderflow, "onunderflow")
GK_ATOM(onunload, "onunload")
GK_ATOM(onupdateready, "onupdateready")
GK_ATOM(onupgradeneeded, "onupgradeneeded")
GK_ATOM(onussdreceived, "onussdreceived")
GK_ATOM(onversionchange, "onversionchange")
GK_ATOM(onvoicechange, "onvoicechange")
GK_ATOM(onwheel, "onwheel")
GK_ATOM(open, "open")
GK_ATOM(optgroup, "optgroup")
GK_ATOM(optimum, "optimum")
GK_ATOM(option, "option")
GK_ATOM(_or, "or")
GK_ATOM(order, "order")
GK_ATOM(ordinal, "ordinal")
GK_ATOM(orient, "orient")
GK_ATOM(orientation, "orientation")
GK_ATOM(otherwise, "otherwise")
GK_ATOM(output, "output")
GK_ATOM(overflow, "overflow")
GK_ATOM(overflowchanged, "overflowchanged")
GK_ATOM(overlay, "overlay")
GK_ATOM(overlap, "overlap")
GK_ATOM(p, "p")
GK_ATOM(pack, "pack")
GK_ATOM(page, "page")
GK_ATOM(pageincrement, "pageincrement")
GK_ATOM(pagex, "pagex")
GK_ATOM(pagey, "pagey")
GK_ATOM(paint_order, "paint-order")
GK_ATOM(palettename, "palettename")
GK_ATOM(panel, "panel")
GK_ATOM(param, "param")
GK_ATOM(parameter, "parameter")
GK_ATOM(parent, "parent")
GK_ATOM(parentfocused, "parentfocused")
GK_ATOM(parsetype, "parsetype")
GK_ATOM(pattern, "pattern")
GK_ATOM(patternSeparator, "pattern-separator")
GK_ATOM(perMille, "per-mille")
GK_ATOM(percent, "percent")
GK_ATOM(persist, "persist")
GK_ATOM(phase, "phase")
GK_ATOM(ping, "ping")
GK_ATOM(pinned,"pinned")
GK_ATOM(placeholder, "placeholder")
GK_ATOM(plaintext, "plaintext")
GK_ATOM(playbackrate, "playbackrate")
GK_ATOM(pointSize, "point-size")
GK_ATOM(poly, "poly")
GK_ATOM(polygon, "polygon")
GK_ATOM(popup, "popup")
GK_ATOM(popupalign, "popupalign")
GK_ATOM(popupanchor, "popupanchor")
GK_ATOM(popupgroup, "popupgroup")
GK_ATOM(popuphidden, "popuphidden")
GK_ATOM(popuphiding, "popuphiding")
GK_ATOM(popupset, "popupset")
GK_ATOM(popupshowing, "popupshowing")
GK_ATOM(popupshown, "popupshown")
GK_ATOM(popupsinherittooltip, "popupsinherittooltip")
GK_ATOM(position, "position")
GK_ATOM(poster, "poster")
GK_ATOM(pre, "pre")
GK_ATOM(preceding, "preceding")
GK_ATOM(precedingSibling, "preceding-sibling")
GK_ATOM(predicate, "predicate")
GK_ATOM(prefix, "prefix")
GK_ATOM(preload, "preload")
GK_ATOM(preserve, "preserve")
GK_ATOM(preserveSpace, "preserve-space")
GK_ATOM(preventdefault, "preventdefault")
GK_ATOM(primary, "primary")
GK_ATOM(print, "print")
GK_ATOM(priority, "priority")
GK_ATOM(processingInstruction, "processing-instruction")
GK_ATOM(profile, "profile")
GK_ATOM(progress, "progress")
GK_ATOM(progressmeter, "progressmeter")
GK_ATOM(progressNormal, "progressNormal")
GK_ATOM(progressUndetermined, "progressUndetermined")
GK_ATOM(projection, "projection")
GK_ATOM(prompt, "prompt")
GK_ATOM(propagate, "propagate")
GK_ATOM(properties, "properties")
GK_ATOM(property, "property")
GK_ATOM(pubdate, "pubdate")
GK_ATOM(q, "q")
GK_ATOM(query, "query")
GK_ATOM(queryset, "queryset")
GK_ATOM(querytype, "querytype")
GK_ATOM(radio, "radio")
GK_ATOM(radiogroup, "radiogroup")
GK_ATOM(range, "range")
GK_ATOM(readonly, "readonly")
GK_ATOM(rect, "rect")
GK_ATOM(rectangle, "rectangle")
GK_ATOM(ref, "ref")
GK_ATOM(refresh, "refresh")
GK_ATOM(rel, "rel")
GK_ATOM(rem, "rem")
GK_ATOM(removeelement, "removeelement")
GK_ATOM(renderingobserverlist, "renderingobserverlist")
GK_ATOM(repeat, "repeat")
GK_ATOM(replace, "replace")
GK_ATOM(required, "required")
GK_ATOM(reset, "reset")
GK_ATOM(resizeafter, "resizeafter")
GK_ATOM(resizebefore, "resizebefore")
GK_ATOM(resizer, "resizer")
GK_ATOM(resolution, "resolution")
GK_ATOM(resource, "resource")
GK_ATOM(resources, "resources")
GK_ATOM(result, "result")
GK_ATOM(resultPrefix, "result-prefix")
GK_ATOM(rev, "rev")
GK_ATOM(reverse, "reverse")
GK_ATOM(reversed, "reversed")
GK_ATOM(richlistbox, "richlistbox")
GK_ATOM(richlistitem, "richlistitem")
GK_ATOM(right, "right")
GK_ATOM(rightmargin, "rightmargin")
GK_ATOM(rightpadding, "rightpadding")
GK_ATOM(role, "role")
GK_ATOM(rolluponmousewheel, "rolluponmousewheel")
GK_ATOM(round, "round")
GK_ATOM(row, "row")
GK_ATOM(rows, "rows")
GK_ATOM(rowspan, "rowspan")
GK_ATOM(rp, "rp")
GK_ATOM(rt, "rt")
GK_ATOM(rtl, "rtl")
GK_ATOM(ruby, "ruby")
GK_ATOM(rule, "rule")
GK_ATOM(rules, "rules")
GK_ATOM(s, "s")
GK_ATOM(samp, "samp")
GK_ATOM(sandbox, "sandbox")
GK_ATOM(sbattr, "sbattr")
GK_ATOM(scale, "scale")
GK_ATOM(scan, "scan")
GK_ATOM(scheme, "scheme")
GK_ATOM(scope, "scope")
GK_ATOM(scoped, "scoped")
GK_ATOM(screen, "screen")
GK_ATOM(screenX, "screenX")
GK_ATOM(screenY, "screenY")
GK_ATOM(script, "script")
GK_ATOM(scriptEnabledBeforePrintOrPreview, "scriptEnabledBeforePrintOrPreview")
GK_ATOM(scrollbar, "scrollbar")
GK_ATOM(scrollbarbutton, "scrollbarbutton")
GK_ATOM(scrollbarDownBottom, "scrollbar-down-bottom")
GK_ATOM(scrollbarDownTop, "scrollbar-down-top")
GK_ATOM(scrollbarUpBottom, "scrollbar-up-bottom")
GK_ATOM(scrollbarUpTop, "scrollbar-up-top")
GK_ATOM(scrollbox, "scrollbox")
GK_ATOM(scrollcorner, "scrollcorner")
GK_ATOM(scrolling, "scrolling")
GK_ATOM(section, "section")
GK_ATOM(select, "select")
GK_ATOM(selectable, "selectable")
GK_ATOM(selected, "selected")
GK_ATOM(selectedIndex, "selectedIndex")
GK_ATOM(selectedindex, "selectedindex")
GK_ATOM(self, "self")
GK_ATOM(seltype, "seltype")
GK_ATOM(setcookie, "set-cookie")
GK_ATOM(setter, "setter")
GK_ATOM(shape, "shape")
GK_ATOM(show, "show")
GK_ATOM(showcaret, "showcaret")
GK_ATOM(showresizer, "showresizer")
GK_ATOM(simple, "simple")
GK_ATOM(single, "single")
GK_ATOM(size, "size")
GK_ATOM(sizemode, "sizemode")
GK_ATOM(sizetopopup, "sizetopopup")
GK_ATOM(slider, "slider")
GK_ATOM(small, "small")
GK_ATOM(smooth, "smooth")
GK_ATOM(snap, "snap")
GK_ATOM(sort, "sort")
GK_ATOM(sortActive, "sortActive")
GK_ATOM(sortDirection, "sortDirection")
GK_ATOM(sorted, "sorted")
GK_ATOM(sorthints, "sorthints")
GK_ATOM(sortLocked, "sortLocked")
GK_ATOM(sortResource, "sortResource")
GK_ATOM(sortResource2, "sortResource2")
GK_ATOM(sortSeparators, "sortSeparators")
GK_ATOM(sortStaticsLast, "sortStaticsLast")
GK_ATOM(source, "source")
GK_ATOM(space, "space")
GK_ATOM(spacer, "spacer")
GK_ATOM(span, "span")
GK_ATOM(spellcheck, "spellcheck")
GK_ATOM(spinner, "spinner")
GK_ATOM(split, "split")
GK_ATOM(splitmenu, "splitmenu")
GK_ATOM(splitter, "splitter")
GK_ATOM(spring, "spring")
GK_ATOM(src, "src")
GK_ATOM(srcdoc, "srcdoc")
GK_ATOM(srclang, "srclang")
GK_ATOM(stack, "stack")
GK_ATOM(standalone, "standalone")
GK_ATOM(standby, "standby")
GK_ATOM(start, "start")
GK_ATOM(start_after, "start_after")
GK_ATOM(start_before, "start_before")
GK_ATOM(startsWith, "starts-with")
GK_ATOM(state, "state")
GK_ATOM(statedatasource, "statedatasource")
GK_ATOM(staticHint, "staticHint")
GK_ATOM(statusbar, "statusbar")
GK_ATOM(statustext, "statustext")
GK_ATOM(step, "step")
GK_ATOM(stop, "stop")
GK_ATOM(stretch, "stretch")
GK_ATOM(strike, "strike")
GK_ATOM(string, "string")
GK_ATOM(stringLength, "string-length")
GK_ATOM(stripSpace, "strip-space")
GK_ATOM(strong, "strong")
GK_ATOM(style, "style")
GK_ATOM(stylesheet, "stylesheet")
GK_ATOM(stylesheetPrefix, "stylesheet-prefix")
GK_ATOM(subject, "subject")
GK_ATOM(submit, "submit")
GK_ATOM(substate, "substate")
GK_ATOM(substring, "substring")
GK_ATOM(substringAfter, "substring-after")
GK_ATOM(substringBefore, "substring-before")
GK_ATOM(sub, "sub")
GK_ATOM(sum, "sum")
GK_ATOM(sup, "sup")
GK_ATOM(summary, "summary")
GK_ATOM(systemProperty, "system-property")
GK_ATOM(tab, "tab")
GK_ATOM(tabbox, "tabbox")
GK_ATOM(tabindex, "tabindex")
GK_ATOM(table, "table")
GK_ATOM(tabpanel, "tabpanel")
GK_ATOM(tabpanels, "tabpanels")
GK_ATOM(tag, "tag")
GK_ATOM(target, "target")
GK_ATOM(targets, "targets")
GK_ATOM(tbody, "tbody")
GK_ATOM(td, "td")
GK_ATOM(_template, "template")
GK_ATOM(text_decoration, "text-decoration")
GK_ATOM(terminate, "terminate")
GK_ATOM(test, "test")
GK_ATOM(text, "text")
GK_ATOM(textarea, "textarea")
GK_ATOM(textbox, "textbox")
GK_ATOM(textnode, "textnode")
GK_ATOM(textNodeDirectionalityMap, "textNodeDirectionalityMap")
GK_ATOM(tfoot, "tfoot")
GK_ATOM(th, "th")
GK_ATOM(thead, "thead")
GK_ATOM(thumb, "thumb")
GK_ATOM(time, "time")
GK_ATOM(title, "title")
GK_ATOM(titlebar, "titlebar")
GK_ATOM(titletip, "titletip")
GK_ATOM(toggled, "toggled")
GK_ATOM(token, "token")
GK_ATOM(tokenize, "tokenize")
GK_ATOM(toolbar, "toolbar")
GK_ATOM(toolbarbutton, "toolbarbutton")
GK_ATOM(toolbaritem, "toolbaritem")
GK_ATOM(toolbox, "toolbox")
GK_ATOM(tooltip, "tooltip")
GK_ATOM(tooltiptext, "tooltiptext")
GK_ATOM(top, "top")
GK_ATOM(topleft, "topleft")
GK_ATOM(topmargin, "topmargin")
GK_ATOM(toppadding, "toppadding")
GK_ATOM(topright, "topright")
GK_ATOM(tr, "tr")
GK_ATOM(track, "track")
GK_ATOM(trailing, "trailing")
GK_ATOM(transform, "transform")
GK_ATOM(transformiix, "transformiix")
GK_ATOM(translate, "translate")
GK_ATOM(transparent, "transparent")
GK_ATOM(tree, "tree")
GK_ATOM(treecell, "treecell")
GK_ATOM(treechildren, "treechildren")
GK_ATOM(treecol, "treecol")
GK_ATOM(treecolpicker, "treecolpicker")
GK_ATOM(treecols, "treecols")
GK_ATOM(treeitem, "treeitem")
GK_ATOM(treerow, "treerow")
GK_ATOM(treeseparator, "treeseparator")
GK_ATOM(triple, "triple")
GK_ATOM(_true, "true")
GK_ATOM(tt, "tt")
GK_ATOM(tty, "tty")
GK_ATOM(tv, "tv")
GK_ATOM(type, "type")
GK_ATOM(typemustmatch, "typemustmatch")
GK_ATOM(u, "u")
GK_ATOM(ul, "ul")
GK_ATOM(underflow, "underflow")
GK_ATOM(undetermined, "undetermined")
GK_ATOM(undoscope, "undoscope")
GK_ATOM(unload, "unload")
GK_ATOM(unparsedEntityUri, "unparsed-entity-uri")
GK_ATOM(upperFirst, "upper-first")
GK_ATOM(uri, "uri")
GK_ATOM(use, "use")
GK_ATOM(useAttributeSets, "use-attribute-sets")
GK_ATOM(usemap, "usemap")
GK_ATOM(user_scalable, "user-scalable")
GK_ATOM(userInput, "userInput")
GK_ATOM(validate, "validate")
GK_ATOM(valign, "valign")
GK_ATOM(value, "value")
GK_ATOM(values, "values")
GK_ATOM(valueOf, "value-of")
GK_ATOM(valuetype, "valuetype")
GK_ATOM(var, "var")
GK_ATOM(variable, "variable")
GK_ATOM(vbox, "vbox")
GK_ATOM(vcard_name, "vcard_name")
GK_ATOM(vendor, "vendor")
GK_ATOM(vendorUrl, "vendor-url")
GK_ATOM(version, "version")
GK_ATOM(vert, "vert")
GK_ATOM(vertical, "vertical")
GK_ATOM(audio, "audio")
GK_ATOM(video, "video")
GK_ATOM(videocontrols, "videocontrols")
GK_ATOM(viewport, "viewport")
GK_ATOM(viewport_height, "viewport-height")
GK_ATOM(viewport_initial_scale, "viewport-initial-scale")
GK_ATOM(viewport_maximum_scale, "viewport-maximum-scale")
GK_ATOM(viewport_minimum_scale, "viewport-minimum-scale")
GK_ATOM(viewport_user_scalable, "viewport-user-scalable")
GK_ATOM(viewport_width, "viewport-width")
GK_ATOM(visibility, "visibility")
GK_ATOM(vlink, "vlink")
GK_ATOM(vspace, "vspace")
GK_ATOM(wbr, "wbr")
GK_ATOM(when, "when")
GK_ATOM(where, "where")
GK_ATOM(widget, "widget")
GK_ATOM(width, "width")
GK_ATOM(window, "window")
GK_ATOM(headerWindowTarget, "window-target")
GK_ATOM(windowtype, "windowtype")
GK_ATOM(withParam, "with-param")
GK_ATOM(wizard, "wizard")
GK_ATOM(wrap, "wrap")
GK_ATOM(headerDNSPrefetchControl,"x-dns-prefetch-control")
GK_ATOM(headerOldCSP, "x-content-security-policy")
GK_ATOM(headerOldCSPReportOnly, "x-content-security-policy-report-only")
GK_ATOM(headerCSP, "content-security-policy")
GK_ATOM(headerCSPReportOnly, "content-security-policy-report-only")
GK_ATOM(headerXFO, "x-frame-options")
GK_ATOM(x_western, "x-western")
GK_ATOM(xml, "xml")
GK_ATOM(xml_stylesheet, "xml-stylesheet")
GK_ATOM(xmlns, "xmlns")
GK_ATOM(xmp, "xmp")
GK_ATOM(xulcontentsgenerated, "xulcontentsgenerated")
GK_ATOM(yes, "yes")
GK_ATOM(z_index, "z-index")
GK_ATOM(zeroDigit, "zero-digit")


GK_ATOM(percentage, "%")
GK_ATOM(A, "A")
GK_ATOM(alignment_baseline, "alignment-baseline")
GK_ATOM(allowReorder, "allowReorder")
GK_ATOM(altGlyph, "altGlyph")
GK_ATOM(altGlyphDef, "altGlyphDef")
GK_ATOM(altGlyphItem, "altGlyphItem")
GK_ATOM(amplitude, "amplitude")
GK_ATOM(animate, "animate")
GK_ATOM(animateColor, "animateColor")
GK_ATOM(animateMotion, "animateMotion")
GK_ATOM(animateTransform, "animateTransform")
GK_ATOM(arithmetic, "arithmetic")
GK_ATOM(atop, "atop")
GK_ATOM(azimuth, "azimuth")
GK_ATOM(B, "B")
GK_ATOM(baseFrequency, "baseFrequency")
GK_ATOM(baseline_shift, "baseline-shift")
GK_ATOM(bias, "bias")
GK_ATOM(clip_path, "clip-path")
GK_ATOM(clip_rule, "clip-rule")
GK_ATOM(clipPath, "clipPath")
GK_ATOM(clipPathUnits, "clipPathUnits")
GK_ATOM(cm, "cm")
GK_ATOM(colorInterpolation, "color-interpolation")
GK_ATOM(colorInterpolationFilters, "color-interpolation-filters")
GK_ATOM(colorProfile, "color-profile")
GK_ATOM(cursor, "cursor")
GK_ATOM(cx, "cx")
GK_ATOM(cy, "cy")
GK_ATOM(d, "d")
GK_ATOM(darken, "darken")
GK_ATOM(defs, "defs")
GK_ATOM(definition_src, "definition-src")
GK_ATOM(deg, "deg")
GK_ATOM(desc, "desc")
GK_ATOM(diffuseConstant, "diffuseConstant")
GK_ATOM(dilate, "dilate")
GK_ATOM(direction, "direction")
GK_ATOM(disable, "disable")
GK_ATOM(discrete, "discrete")
GK_ATOM(divisor, "divisor")
GK_ATOM(dominant_baseline, "dominant-baseline")
GK_ATOM(duplicate, "duplicate")
GK_ATOM(dx, "dx")
GK_ATOM(dy, "dy")
GK_ATOM(edgeMode, "edgeMode")
GK_ATOM(ellipse, "ellipse")
GK_ATOM(elevation, "elevation")
GK_ATOM(erode, "erode")
GK_ATOM(ex, "ex")
GK_ATOM(exact, "exact")
GK_ATOM(exponent, "exponent")
GK_ATOM(feBlend, "feBlend")
GK_ATOM(feColorMatrix, "feColorMatrix")
GK_ATOM(feComponentTransfer, "feComponentTransfer")
GK_ATOM(feComposite, "feComposite")
GK_ATOM(feConvolveMatrix, "feConvolveMatrix")
GK_ATOM(feDiffuseLighting, "feDiffuseLighting")
GK_ATOM(feDisplacementMap, "feDisplacementMap")
GK_ATOM(feDistantLight,"feDistantLight")
GK_ATOM(feFlood, "feFlood")
GK_ATOM(feFuncA, "feFuncA")
GK_ATOM(feFuncB, "feFuncB")
GK_ATOM(feFuncG, "feFuncG")
GK_ATOM(feFuncR, "feFuncR")
GK_ATOM(feGaussianBlur, "feGaussianBlur")
GK_ATOM(feImage, "feImage")
GK_ATOM(feMerge, "feMerge")
GK_ATOM(feMergeNode, "feMergeNode")
GK_ATOM(feMorphology, "feMorphology")
GK_ATOM(feOffset, "feOffset")
GK_ATOM(fePointLight, "fePointLight")
GK_ATOM(feSpecularLighting, "feSpecularLighting")
GK_ATOM(feSpotLight, "feSpotLight")
GK_ATOM(feTile, "feTile")
GK_ATOM(feTurbulence, "feTurbulence")
GK_ATOM(fill, "fill")
GK_ATOM(fill_opacity, "fill-opacity")
GK_ATOM(fill_rule, "fill-rule")
GK_ATOM(filter, "filter")
GK_ATOM(filterRes, "filterRes")
GK_ATOM(filterUnits, "filterUnits")
GK_ATOM(flood_color, "flood-color")
GK_ATOM(flood_opacity, "flood-opacity")
GK_ATOM(font_face, "font-face")
GK_ATOM(font_face_format, "font-face-format")
GK_ATOM(font_face_name, "font-face-name")
GK_ATOM(font_face_src, "font-face-src")
GK_ATOM(font_face_uri, "font-face-uri")
GK_ATOM(font_family, "font-family")
GK_ATOM(font_size, "font-size")
GK_ATOM(font_size_adjust, "font-size-adjust")
GK_ATOM(font_stretch, "font-stretch")
GK_ATOM(font_style, "font-style")
GK_ATOM(font_variant, "font-variant")
GK_ATOM(foreignObject, "foreignObject")
GK_ATOM(fractalNoise, "fractalNoise")
GK_ATOM(fx, "fx")
GK_ATOM(fy, "fy")
GK_ATOM(G, "G")
GK_ATOM(g, "g")
GK_ATOM(gamma, "gamma")
// 'generic' conflicts with msvc11 winrt compiler extensions
GK_ATOM(generic_, "generic")
GK_ATOM(glyph, "glyph")
GK_ATOM(glyphRef, "glyphRef")
GK_ATOM(glyph_orientation_horizontal, "glyph-orientation-horizontal")
GK_ATOM(glyph_orientation_vertical, "glyph-orientation-vertical")
GK_ATOM(grad, "grad")
GK_ATOM(gradientTransform, "gradientTransform")
GK_ATOM(gradientUnits, "gradientUnits")
GK_ATOM(hkern, "hkern")
GK_ATOM(hueRotate, "hueRotate")
GK_ATOM(identity, "identity")
GK_ATOM(image_rendering, "image-rendering")
GK_ATOM(in, "in")
GK_ATOM(in2, "in2")
GK_ATOM(intercept, "intercept")
GK_ATOM(k1, "k1")
GK_ATOM(k2, "k2")
GK_ATOM(k3, "k3")
GK_ATOM(k4, "k4")
GK_ATOM(kerning, "kerning")
GK_ATOM(kernelMatrix, "kernelMatrix")
GK_ATOM(kernelUnitLength, "kernelUnitLength")
GK_ATOM(lengthAdjust, "lengthAdjust")
GK_ATOM(letter_spacing, "letter-spacing")
GK_ATOM(lighten, "lighten")
GK_ATOM(lighting_color, "lighting-color")
GK_ATOM(limitingConeAngle, "limitingConeAngle")
GK_ATOM(linear, "linear")
GK_ATOM(linearGradient, "linearGradient")
GK_ATOM(linearRGB, "linearRGB")
GK_ATOM(luminanceToAlpha, "luminanceToAlpha")
GK_ATOM(magnify, "magnify")
GK_ATOM(marker, "marker")
GK_ATOM(marker_end, "marker-end")
GK_ATOM(marker_mid, "marker-mid")
GK_ATOM(marker_start, "marker-start")
GK_ATOM(markerHeight, "markerHeight")
GK_ATOM(markerUnits, "markerUnits")
GK_ATOM(markerWidth, "markerWidth")
GK_ATOM(mask, "mask")
GK_ATOM(maskContentUnits, "maskContentUnits")
GK_ATOM(mask_type, "mask-type")
GK_ATOM(maskUnits, "maskUnits")
GK_ATOM(matrix, "matrix")
GK_ATOM(metadata, "metadata")
GK_ATOM(missingGlyph, "missing-glyph")
GK_ATOM(mm, "mm")
GK_ATOM(mpath, "mpath")
GK_ATOM(noStitch, "noStitch")
GK_ATOM(numOctaves, "numOctaves")
GK_ATOM(multiply, "multiply")
GK_ATOM(objectBoundingBox, "objectBoundingBox")
GK_ATOM(offset, "offset")
GK_ATOM(onSVGAbort, "onSVGAbort")
GK_ATOM(onSVGError, "onSVGError")
GK_ATOM(onSVGLoad, "onSVGLoad")
GK_ATOM(onSVGResize, "onSVGResize")
GK_ATOM(onSVGScroll, "onSVGScroll")
GK_ATOM(onSVGUnload, "onSVGUnload")
GK_ATOM(onSVGZoom, "onSVGZoom")
GK_ATOM(onzoom, "onzoom")
GK_ATOM(opacity, "opacity")
GK_ATOM(_operator, "operator")
GK_ATOM(out, "out")
GK_ATOM(over, "over")
GK_ATOM(overridePreserveAspectRatio, "overridePreserveAspectRatio")
GK_ATOM(pad, "pad")
GK_ATOM(path, "path")
GK_ATOM(pathLength, "pathLength")
GK_ATOM(patternContentUnits, "patternContentUnits")
GK_ATOM(patternTransform, "patternTransform")
GK_ATOM(patternUnits, "patternUnits")
GK_ATOM(pc, "pc")
GK_ATOM(pointer_events, "pointer-events")
GK_ATOM(points, "points")
GK_ATOM(pointsAtX, "pointsAtX")
GK_ATOM(pointsAtY, "pointsAtY")
GK_ATOM(pointsAtZ, "pointsAtZ")
GK_ATOM(polyline, "polyline")
GK_ATOM(preserveAlpha, "preserveAlpha")
GK_ATOM(preserveAspectRatio, "preserveAspectRatio")
GK_ATOM(primitiveUnits, "primitiveUnits")
GK_ATOM(pt, "pt")
GK_ATOM(px, "px")
GK_ATOM(R, "R")
GK_ATOM(r, "r")
GK_ATOM(rad, "rad")
GK_ATOM(radialGradient, "radialGradient")
GK_ATOM(radius, "radius")
GK_ATOM(reflect, "reflect")
GK_ATOM(refX, "refX")
GK_ATOM(refY, "refY")
GK_ATOM(requiredExtensions, "requiredExtensions")
GK_ATOM(requiredFeatures, "requiredFeatures")
GK_ATOM(rotate, "rotate")
GK_ATOM(rx, "rx")
GK_ATOM(ry, "ry")
GK_ATOM(saturate, "saturate")
GK_ATOM(set, "set")
GK_ATOM(seed, "seed")
GK_ATOM(shadow, "shadow")
GK_ATOM(shape_rendering, "shape-rendering")
GK_ATOM(skewX, "skewX")
GK_ATOM(skewY, "skewY")
GK_ATOM(slope, "slope")
GK_ATOM(spacing, "spacing")
GK_ATOM(spacingAndGlyphs, "spacingAndGlyphs")
GK_ATOM(specularConstant, "specularConstant")
GK_ATOM(specularExponent, "specularExponent")
GK_ATOM(spreadMethod, "spreadMethod")
GK_ATOM(sRGB, "sRGB")
GK_ATOM(startOffset, "startOffset")
GK_ATOM(stdDeviation, "stdDeviation")
GK_ATOM(stitch, "stitch")
GK_ATOM(stitchTiles, "stitchTiles")
GK_ATOM(stop_color, "stop-color")
GK_ATOM(stop_opacity, "stop-opacity")
GK_ATOM(stroke, "stroke")
GK_ATOM(stroke_dasharray, "stroke-dasharray")
GK_ATOM(stroke_dashoffset, "stroke-dashoffset")
GK_ATOM(stroke_linecap, "stroke-linecap")
GK_ATOM(stroke_linejoin, "stroke-linejoin")
GK_ATOM(stroke_miterlimit, "stroke-miterlimit")
GK_ATOM(stroke_opacity, "stroke-opacity")
GK_ATOM(stroke_width, "stroke-width")
GK_ATOM(strokeWidth, "strokeWidth")
GK_ATOM(surfaceScale, "surfaceScale")
GK_ATOM(svg, "svg")
GK_ATOM(svgSwitch, "switch")
GK_ATOM(symbol, "symbol")
GK_ATOM(systemLanguage, "systemLanguage")
GK_ATOM(tableValues, "tableValues")
GK_ATOM(targetX, "targetX")
GK_ATOM(targetY, "targetY")
GK_ATOM(text_anchor, "text-anchor")
GK_ATOM(text_rendering, "text-rendering")
GK_ATOM(textLength, "textLength")
GK_ATOM(textPath, "textPath")
GK_ATOM(tref, "tref")
GK_ATOM(tspan, "tspan")
GK_ATOM(turbulence, "turbulence")
GK_ATOM(unicode_bidi, "unicode-bidi")
GK_ATOM(userSpaceOnUse, "userSpaceOnUse")
GK_ATOM(view, "view")
GK_ATOM(viewBox, "viewBox")
GK_ATOM(viewTarget, "viewTarget")
GK_ATOM(vkern, "vkern")
GK_ATOM(word_spacing, "word-spacing")
GK_ATOM(x, "x")
GK_ATOM(x1, "x1")
GK_ATOM(x2, "x2")
GK_ATOM(xChannelSelector, "xChannelSelector")
GK_ATOM(xor_, "xor")
GK_ATOM(y, "y")
GK_ATOM(y1, "y1")
GK_ATOM(y2, "y2")
GK_ATOM(yChannelSelector, "yChannelSelector")
GK_ATOM(z, "z")
GK_ATOM(zoomAndPan, "zoomAndPan")
GK_ATOM(vector_effect, "vector-effect")

GK_ATOM(accumulate, "accumulate")
GK_ATOM(additive, "additive")
GK_ATOM(attributeName, "attributeName")
GK_ATOM(attributeType, "attributeType")
GK_ATOM(auto_reverse, "auto-reverse")
GK_ATOM(begin, "begin")
GK_ATOM(beginEvent, "beginEvent")
GK_ATOM(by, "by")
GK_ATOM(calcMode, "calcMode")
GK_ATOM(css, "CSS")
GK_ATOM(dur, "dur")
GK_ATOM(keyPoints, "keyPoints")
GK_ATOM(keySplines, "keySplines")
GK_ATOM(keyTimes, "keyTimes")
GK_ATOM(mozAnimateMotionDummyAttr, "_mozAnimateMotionDummyAttr")
GK_ATOM(onbegin, "onbegin")
GK_ATOM(onbeginEvent, "onbeginEvent")
GK_ATOM(onend, "onend")
GK_ATOM(onendEvent, "onendEvent")
GK_ATOM(onrepeat, "onrepeat")
GK_ATOM(onrepeatEvent, "onrepeatEvent")
GK_ATOM(repeatCount, "repeatCount")
GK_ATOM(repeatDur, "repeatDur")
GK_ATOM(repeatEvent, "repeatEvent")
GK_ATOM(restart, "restart")
GK_ATOM(to, "to")
GK_ATOM(XML, "XML")

GK_ATOM(abs_, "abs")
GK_ATOM(accent_, "accent")
GK_ATOM(accentunder_, "accentunder")
GK_ATOM(actiontype_, "actiontype")
GK_ATOM(alignmentscope_, "alignmentscope")
GK_ATOM(altimg_, "altimg")
GK_ATOM(altimg_height_, "altimg-height")
GK_ATOM(altimg_valign_, "altimg-valign")
GK_ATOM(altimg_width_, "altimg-width")
GK_ATOM(annotation_, "annotation")
GK_ATOM(annotation_xml_, "annotation-xml")
GK_ATOM(apply_, "apply")
GK_ATOM(approx_, "approx")
GK_ATOM(arccos_, "arccos")
GK_ATOM(arccosh_, "arccosh")
GK_ATOM(arccot_, "arccot")
GK_ATOM(arccoth_, "arccoth")
GK_ATOM(arccsc_, "arccsc")
GK_ATOM(arccsch_, "arccsch")
GK_ATOM(arcsec_, "arcsec")
GK_ATOM(arcsech_, "arcsech")
GK_ATOM(arcsin_, "arcsin")
GK_ATOM(arcsinh_, "arcsinh")
GK_ATOM(arctan_, "arctan")
GK_ATOM(arctanh_, "arctanh")
GK_ATOM(arg_, "arg")
GK_ATOM(bevelled_, "bevelled")
GK_ATOM(bind_, "bind")
GK_ATOM(bvar_, "bvar")
GK_ATOM(card_, "card")
GK_ATOM(cartesianproduct_, "cartesianproduct")
GK_ATOM(cbytes_, "cbytes")
GK_ATOM(cd_, "cd")
GK_ATOM(cdgroup_, "cdgroup")
GK_ATOM(cerror_, "cerror")
GK_ATOM(charalign_, "charalign")
GK_ATOM(ci_, "ci")
GK_ATOM(closure_, "closure")
GK_ATOM(cn_, "cn")
GK_ATOM(codomain_, "codomain")
GK_ATOM(columnalign_, "columnalign")
GK_ATOM(columnalignment_, "columnalignment")
GK_ATOM(columnlines_, "columnlines")
GK_ATOM(columnspacing_, "columnspacing")
GK_ATOM(columnspan_, "columnspan")
GK_ATOM(columnwidth_, "columnwidth")
GK_ATOM(complexes_, "complexes")
GK_ATOM(compose_, "compose")
GK_ATOM(condition_, "condition")
GK_ATOM(conjugate_, "conjugate")
GK_ATOM(cos_, "cos")
GK_ATOM(cosh_, "cosh")
GK_ATOM(cot_, "cot")
GK_ATOM(coth_, "coth")
GK_ATOM(crossout_, "crossout")
GK_ATOM(csc_, "csc")
GK_ATOM(csch_, "csch")
GK_ATOM(cs_, "cs")
GK_ATOM(csymbol_, "csymbol")
GK_ATOM(curl_, "curl")
GK_ATOM(decimalpoint_, "decimalpoint")
GK_ATOM(definitionURL_, "definitionURL")
GK_ATOM(degree_, "degree")
GK_ATOM(denomalign_, "denomalign")
GK_ATOM(depth_, "depth")
GK_ATOM(determinant_, "determinant")
GK_ATOM(diff_, "diff")
GK_ATOM(displaystyle_, "displaystyle")
GK_ATOM(divergence_, "divergence")
GK_ATOM(divide_, "divide")
GK_ATOM(domain_, "domain")
GK_ATOM(domainofapplication_, "domainofapplication")
GK_ATOM(edge_, "edge")
GK_ATOM(el_, "el")
GK_ATOM(emptyset_, "emptyset")
GK_ATOM(eq_, "eq")
GK_ATOM(equalcolumns_, "equalcolumns")
GK_ATOM(equalrows_, "equalrows")
GK_ATOM(equivalent_, "equivalent")
GK_ATOM(eulergamma_, "eulergamma")
GK_ATOM(exists_, "exists")
GK_ATOM(exp_, "exp")
GK_ATOM(exponentiale_, "exponentiale")
GK_ATOM(factorial_, "factorial")
GK_ATOM(factorof_, "factorof")
GK_ATOM(fence_, "fence")
GK_ATOM(fn_, "fn")
GK_ATOM(fontfamily_, "fontfamily")
GK_ATOM(fontsize_, "fontsize")
GK_ATOM(fontstyle_, "fontstyle")
GK_ATOM(fontweight_, "fontweight")
GK_ATOM(forall_, "forall")
GK_ATOM(framespacing_, "framespacing")
GK_ATOM(gcd_, "gcd")
GK_ATOM(geq_, "geq")
GK_ATOM(groupalign_, "groupalign")
GK_ATOM(gt_, "gt")
GK_ATOM(ident_, "ident")
GK_ATOM(imaginaryi_, "imaginaryi")
GK_ATOM(imaginary_, "imaginary")
GK_ATOM(implies_, "implies")
GK_ATOM(indentalignfirst_, "indentalignfirst")
GK_ATOM(indentalign_, "indentalign")
GK_ATOM(indentalignlast_, "indentalignlast")
GK_ATOM(indentshiftfirst_, "indentshiftfirst")
GK_ATOM(indentshift_, "indentshift")
GK_ATOM(indenttarget_, "indenttarget")
GK_ATOM(integers_, "integers")
GK_ATOM(intersect_, "intersect")
GK_ATOM(interval_, "interval")
GK_ATOM(int_, "int")
GK_ATOM(inverse_, "inverse")
GK_ATOM(lambda_, "lambda")
GK_ATOM(laplacian_, "laplacian")
GK_ATOM(largeop_, "largeop")
GK_ATOM(lcm_, "lcm")
GK_ATOM(leq_, "leq")
GK_ATOM(limit_, "limit")
GK_ATOM(linebreak_, "linebreak")
GK_ATOM(linebreakmultchar_, "linebreakmultchar")
GK_ATOM(linebreakstyle_, "linebreakstyle")
GK_ATOM(linethickness_, "linethickness")
GK_ATOM(list_, "list")
GK_ATOM(ln_, "ln")
GK_ATOM(location_, "location")
GK_ATOM(logbase_, "logbase")
GK_ATOM(log_, "log")
GK_ATOM(longdivstyle_, "longdivstyle")
GK_ATOM(lowlimit_, "lowlimit")
GK_ATOM(lquote_, "lquote")
GK_ATOM(lspace_, "lspace")
GK_ATOM(lt_, "lt")
GK_ATOM(maction_, "maction")
GK_ATOM(maligngroup_, "maligngroup")
GK_ATOM(malignmark_, "malignmark")
GK_ATOM(mathbackground_, "mathbackground")
GK_ATOM(mathcolor_, "mathcolor")
GK_ATOM(mathsize_, "mathsize")
GK_ATOM(mathvariant_, "mathvariant")
GK_ATOM(matrixrow_, "matrixrow")
GK_ATOM(maxsize_, "maxsize")
GK_ATOM(mean_, "mean")
GK_ATOM(median_, "median")
GK_ATOM(menclose_, "menclose")
GK_ATOM(merror_, "merror")
GK_ATOM(mfenced_, "mfenced")
GK_ATOM(mfrac_, "mfrac")
GK_ATOM(mglyph_, "mglyph")
GK_ATOM(mi_, "mi")
GK_ATOM(minlabelspacing_, "minlabelspacing")
GK_ATOM(minsize_, "minsize")
GK_ATOM(minus_, "minus")
GK_ATOM(mlabeledtr_, "mlabeledtr")
GK_ATOM(mlongdiv_, "mlongdiv")
GK_ATOM(mmultiscripts_, "mmultiscripts")
GK_ATOM(mn_, "mn")
GK_ATOM(momentabout_, "momentabout")
GK_ATOM(moment_, "moment")
GK_ATOM(mo_, "mo")
GK_ATOM(movablelimits_, "movablelimits")
GK_ATOM(mover_, "mover")
GK_ATOM(mpadded_, "mpadded")
GK_ATOM(mphantom_, "mphantom")
GK_ATOM(mprescripts_, "mprescripts")
GK_ATOM(mroot_, "mroot")
GK_ATOM(mrow_, "mrow")
GK_ATOM(mscarries_, "mscarries")
GK_ATOM(mscarry_, "mscarry")
GK_ATOM(msgroup_, "msgroup")
GK_ATOM(msline_, "msline")
GK_ATOM(ms_, "ms")
GK_ATOM(mspace_, "mspace")
GK_ATOM(msqrt_, "msqrt")
GK_ATOM(msrow_, "msrow")
GK_ATOM(mstack_, "mstack")
GK_ATOM(mstyle_, "mstyle")
GK_ATOM(msub_, "msub")
GK_ATOM(msubsup_, "msubsup")
GK_ATOM(msup_, "msup")
GK_ATOM(mtable_, "mtable")
GK_ATOM(mtd_, "mtd")
GK_ATOM(mtext_, "mtext")
GK_ATOM(mtr_, "mtr")
GK_ATOM(munder_, "munder")
GK_ATOM(munderover_, "munderover")
GK_ATOM(naturalnumbers_, "naturalnumbers")
GK_ATOM(neq_, "neq")
GK_ATOM(notanumber_, "notanumber")
GK_ATOM(notation_, "notation")
GK_ATOM(note_, "note")
GK_ATOM(notin_, "notin")
GK_ATOM(notprsubset_, "notprsubset")
GK_ATOM(notsubset_, "notsubset")
GK_ATOM(numalign_, "numalign")
GK_ATOM(other_, "other")
GK_ATOM(outerproduct_, "outerproduct")
GK_ATOM(partialdiff_, "partialdiff")
GK_ATOM(piece_, "piece")
GK_ATOM(piecewise_, "piecewise")
GK_ATOM(pi_, "pi")
GK_ATOM(plus_, "plus")
GK_ATOM(power_, "power")
GK_ATOM(primes_, "primes")
GK_ATOM(product_, "product")
GK_ATOM(prsubset_, "prsubset")
GK_ATOM(quotient_, "quotient")
GK_ATOM(rationals_, "rationals")
GK_ATOM(real_, "real")
GK_ATOM(reals_, "reals")
GK_ATOM(reln_, "reln")
GK_ATOM(root_, "root")
GK_ATOM(rowalign_, "rowalign")
GK_ATOM(rowlines_, "rowlines")
GK_ATOM(rowspacing_, "rowspacing")
GK_ATOM(rquote_, "rquote")
GK_ATOM(rspace_, "rspace")
GK_ATOM(scalarproduct_, "scalarproduct")
GK_ATOM(schemaLocation_, "schemaLocation")
GK_ATOM(scriptlevel_, "scriptlevel")
GK_ATOM(scriptminsize_, "scriptminsize")
GK_ATOM(scriptsizemultiplier_, "scriptsizemultiplier")
GK_ATOM(scriptsize_, "scriptsize")
GK_ATOM(sdev_, "sdev")
GK_ATOM(sech_, "sech")
GK_ATOM(sec_, "sec")
GK_ATOM(selection_, "selection")
GK_ATOM(selector_, "selector")
GK_ATOM(semantics_, "semantics")
GK_ATOM(separator_, "separator")
GK_ATOM(separators_, "separators")
GK_ATOM(sep_, "sep")
GK_ATOM(setdiff_, "setdiff")
GK_ATOM(set_, "set")
GK_ATOM(share_, "share")
GK_ATOM(shift_, "shift")
GK_ATOM(side_, "side")
GK_ATOM(sinh_, "sinh")
GK_ATOM(sin_, "sin")
GK_ATOM(stackalign_, "stackalign")
GK_ATOM(stretchy_, "stretchy")
GK_ATOM(subscriptshift_, "subscriptshift")
GK_ATOM(subset_, "subset")
GK_ATOM(superscriptshift_, "superscriptshift")
GK_ATOM(symmetric_, "symmetric")
GK_ATOM(tanh_, "tanh")
GK_ATOM(tan_, "tan")
GK_ATOM(tendsto_, "tendsto")
GK_ATOM(times_, "times")
GK_ATOM(transpose_, "transpose")
GK_ATOM(union_, "union")
GK_ATOM(uplimit_, "uplimit")
GK_ATOM(variance_, "variance")
GK_ATOM(vectorproduct_, "vectorproduct")
GK_ATOM(vector_, "vector")
GK_ATOM(voffset_, "voffset")
GK_ATOM(xref_, "xref")
GK_ATOM(math, "math") // the only one without an underscore
GK_ATOM(avg, "avg")
GK_ATOM(booleanFromString, "boolean-from-string")
GK_ATOM(countNonEmpty, "count-non-empty")
GK_ATOM(daysFromDate, "days-from-date")
GK_ATOM(init, "init")
GK_ATOM(instance, "instance")
GK_ATOM(months, "months")
GK_ATOM(now, "now")
GK_ATOM(seconds, "seconds")
GK_ATOM(secondsFromDateTime, "seconds-from-dateTime")

// Simple gestures support
GK_ATOM(onMozSwipeGestureStart, "onMozSwipeGestureStart")
GK_ATOM(onMozSwipeGestureUpdate, "onMozSwipeGestureUpdate")
GK_ATOM(onMozSwipeGestureEnd, "onMozSwipeGestureEnd")
GK_ATOM(onMozSwipeGesture, "onMozSwipeGesture")
GK_ATOM(onMozMagnifyGestureStart, "onMozMagnifyGestureStart")
GK_ATOM(onMozMagnifyGestureUpdate, "onMozMagnifyGestureUpdate")
GK_ATOM(onMozMagnifyGesture, "onMozMagnifyGesture")
GK_ATOM(onMozRotateGestureStart, "onMozRotateGestureStart")
GK_ATOM(onMozRotateGestureUpdate, "onMozRotateGestureUpdate")
GK_ATOM(onMozRotateGesture, "onMozRotateGesture")
GK_ATOM(onMozTapGesture, "onMozTapGesture")
GK_ATOM(onMozPressTapGesture, "onMozPressTapGesture")
GK_ATOM(onMozEdgeUIStarted, "onMozEdgeUIStarted")
GK_ATOM(onMozEdgeUICanceled, "onMozEdgeUICanceled")
GK_ATOM(onMozEdgeUICompleted, "onMozEdgeUICompleted")

// Pointer events
GK_ATOM(onpointerdown, "onpointerdown")
GK_ATOM(onpointermove, "onpointermove")
GK_ATOM(onpointerup, "onpointerup")
GK_ATOM(onpointercancel, "onpointercancel")
GK_ATOM(onpointerover, "onpointerover")
GK_ATOM(onpointerout, "onpointerout")
GK_ATOM(onpointerenter, "onpointerenter")
GK_ATOM(onpointerleave, "onpointerleave")
GK_ATOM(ongotpointercapture, "ongotpointercapture")
GK_ATOM(onlostpointercapture, "onlostpointercapture")

// orientation support
GK_ATOM(ondevicemotion, "ondevicemotion")
GK_ATOM(ondeviceorientation, "ondeviceorientation")
GK_ATOM(ondeviceproximity, "ondeviceproximity")
GK_ATOM(onmozorientationchange, "onmozorientationchange")
GK_ATOM(onuserproximity, "onuserproximity")

// light sensor support
GK_ATOM(ondevicelight, "ondevicelight")

//---------------------------------------------------------------------------
// Special atoms
//---------------------------------------------------------------------------

// Node types
GK_ATOM(cdataTagName, "#cdata-section")
GK_ATOM(commentTagName, "#comment")
GK_ATOM(documentNodeName, "#document")
GK_ATOM(documentFragmentNodeName, "#document-fragment")
GK_ATOM(documentTypeNodeName, "#document-type")
GK_ATOM(processingInstructionTagName, "#processing-instruction")
GK_ATOM(textTagName, "#text")

// Frame types
GK_ATOM(bcTableCellFrame, "BCTableCellFrame") // table cell in border collapsing model
GK_ATOM(blockFrame, "BlockFrame")
GK_ATOM(boxFrame, "BoxFrame")
GK_ATOM(brFrame, "BRFrame")
GK_ATOM(bulletFrame, "BulletFrame")
GK_ATOM(colorControlFrame, "colorControlFrame")
GK_ATOM(columnSetFrame, "ColumnSetFrame")
GK_ATOM(comboboxControlFrame, "ComboboxControlFrame")
GK_ATOM(comboboxDisplayFrame, "ComboboxDisplayFrame")
GK_ATOM(deckFrame, "DeckFrame")
GK_ATOM(fieldSetFrame, "FieldSetFrame")
GK_ATOM(flexContainerFrame, "FlexContainerFrame")
GK_ATOM(formControlFrame, "FormControlFrame") // radio or checkbox
GK_ATOM(frameSetFrame, "FrameSetFrame")
GK_ATOM(gfxButtonControlFrame, "gfxButtonControlFrame")
GK_ATOM(HTMLButtonControlFrame, "HTMLButtonControlFrame")
GK_ATOM(HTMLCanvasFrame, "HTMLCanvasFrame")
GK_ATOM(subDocumentFrame, "subDocumentFrame")
GK_ATOM(imageBoxFrame, "ImageBoxFrame")
GK_ATOM(imageFrame, "ImageFrame")
GK_ATOM(imageControlFrame, "ImageControlFrame")
GK_ATOM(inlineFrame, "InlineFrame")
GK_ATOM(leafBoxFrame, "LeafBoxFrame")
GK_ATOM(legendFrame, "LegendFrame")
GK_ATOM(letterFrame, "LetterFrame")
GK_ATOM(lineFrame, "LineFrame")
GK_ATOM(listControlFrame,"ListControlFrame")
GK_ATOM(menuFrame,"MenuFrame")
GK_ATOM(menuPopupFrame,"MenuPopupFrame")
GK_ATOM(numberControlFrame, "NumberControlFrame")
GK_ATOM(objectFrame, "ObjectFrame")
GK_ATOM(pageFrame, "PageFrame")
GK_ATOM(pageBreakFrame, "PageBreakFrame")
GK_ATOM(pageContentFrame, "PageContentFrame")
GK_ATOM(placeholderFrame, "PlaceholderFrame")
GK_ATOM(popupSetFrame, "PopupSetFrame")
GK_ATOM(canvasFrame, "CanvasFrame")
GK_ATOM(rangeFrame, "RangeFrame")
GK_ATOM(rootFrame, "RootFrame")
GK_ATOM(scrollFrame, "ScrollFrame")
GK_ATOM(scrollbarFrame, "ScrollbarFrame")
GK_ATOM(sequenceFrame, "SequenceFrame")
GK_ATOM(sliderFrame, "sliderFrame")
GK_ATOM(tableCaptionFrame, "TableCaptionFrame")
GK_ATOM(tableCellFrame, "TableCellFrame")
GK_ATOM(tableColFrame, "TableColFrame")
GK_ATOM(tableColGroupFrame, "TableColGroupFrame")
GK_ATOM(tableFrame, "TableFrame")
GK_ATOM(tableOuterFrame, "TableOuterFrame")
GK_ATOM(tableRowGroupFrame, "TableRowGroupFrame")
GK_ATOM(tableRowFrame, "TableRowFrame")
GK_ATOM(textInputFrame,"TextInputFrame")
GK_ATOM(textFrame, "TextFrame")
GK_ATOM(viewportFrame, "ViewportFrame")
#ifdef MOZ_XUL
GK_ATOM(XULLabelFrame, "XULLabelFrame")
#endif
GK_ATOM(svgAFrame, "SVGAFrame")
GK_ATOM(svgClipPathFrame, "SVGClipPathFrame")
GK_ATOM(svgDefsFrame, "SVGDefsFrame")
GK_ATOM(svgFEContainerFrame, "SVGFEContainerFrame")
GK_ATOM(svgFEImageFrame, "SVGFEImageFrame")
GK_ATOM(svgFELeafFrame, "SVGFELeafFrame")
GK_ATOM(svgFEUnstyledLeafFrame, "SVGFEUnstyledLeafFrame")
GK_ATOM(svgFilterFrame, "SVGFilterFrame")
GK_ATOM(svgForeignObjectFrame, "SVGForeignObjectFrame")
GK_ATOM(svgGenericContainerFrame, "SVGGenericContainerFrame")
GK_ATOM(svgGFrame, "SVGGFrame")
GK_ATOM(svgGradientFrame, "SVGGradientFrame")
GK_ATOM(svgImageFrame, "SVGImageFrame")
GK_ATOM(svgInnerSVGFrame, "SVGInnerSVGFrame")
GK_ATOM(svgLinearGradientFrame, "SVGLinearGradientFrame")
GK_ATOM(svgMarkerFrame, "SVGMarkerFrame")
GK_ATOM(svgMarkerAnonChildFrame, "SVGMarkerAnonChildFrame")
GK_ATOM(svgMaskFrame, "SVGMaskFrame")
GK_ATOM(svgOuterSVGFrame, "SVGOuterSVGFrame")
GK_ATOM(svgOuterSVGAnonChildFrame, "SVGOuterSVGAnonChildFrame")
GK_ATOM(svgPathGeometryFrame, "SVGPathGeometryFrame")
GK_ATOM(svgPatternFrame, "SVGPatternFrame")
GK_ATOM(svgRadialGradientFrame, "SVGRadialGradientFrame")
GK_ATOM(svgStopFrame, "SVGStopFrame")
GK_ATOM(svgSwitchFrame, "SVGSwitchFrame")
GK_ATOM(svgTextFrame, "SVGTextFrame")
GK_ATOM(svgUseFrame, "SVGUseFrame")
GK_ATOM(svgViewFrame, "SVGViewFrame")
GK_ATOM(HTMLVideoFrame, "VideoFrame")
GK_ATOM(onloadend, "onloadend")
GK_ATOM(onloadstart, "onloadstart")
GK_ATOM(onprogress, "onprogress")
GK_ATOM(onsuspend, "onsuspend")
GK_ATOM(onemptied, "onemptied")
GK_ATOM(onstalled, "onstalled")
GK_ATOM(onplay, "onplay")
GK_ATOM(onpause, "onpause")
GK_ATOM(onloadedmetadata, "onloadedmetadata")
GK_ATOM(onloadeddata, "onloadeddata")
GK_ATOM(onwaiting, "onwaiting")
GK_ATOM(onplaying, "onplaying")
GK_ATOM(oncanplay, "oncanplay")
GK_ATOM(oncanplaythrough, "oncanplaythrough")
GK_ATOM(onseeking, "onseeking")
GK_ATOM(onseeked, "onseeked")
GK_ATOM(ontimeout, "ontimeout")
GK_ATOM(ontimeupdate, "ontimeupdate")
GK_ATOM(onended, "onended")
GK_ATOM(onratechange, "onratechange")
GK_ATOM(ondurationchange, "ondurationchange")
GK_ATOM(onvolumechange, "onvolumechange")
GK_ATOM(onMozAudioAvailable, "onMozAudioAvailable")
GK_ATOM(onaddtrack, "onaddtrack")
GK_ATOM(oncuechange, "oncuechange")
GK_ATOM(onenter, "onenter")
GK_ATOM(onexit, "onexit")
GK_ATOM(onremovetrack, "onremovetrack")
GK_ATOM(loadstart, "loadstart")
GK_ATOM(suspend, "suspend")
GK_ATOM(emptied, "emptied")
GK_ATOM(stalled, "stalled")
GK_ATOM(play, "play")
GK_ATOM(pause, "pause")
GK_ATOM(loadedmetadata, "loadedmetadata")
GK_ATOM(loadeddata, "loadeddata")
GK_ATOM(waiting, "waiting")
GK_ATOM(playing, "playing")
GK_ATOM(seeking, "seeking")
GK_ATOM(seeked, "seeked")
GK_ATOM(timeupdate, "timeupdate")
GK_ATOM(ended, "ended")
GK_ATOM(canplay, "canplay")
GK_ATOM(canplaythrough, "canplaythrough")
GK_ATOM(ratechange, "ratechange")
GK_ATOM(durationchange, "durationchange")
GK_ATOM(volumechange, "volumechange")
GK_ATOM(ondataavailable, "ondataavailable")
GK_ATOM(onwarning, "onwarning")
GK_ATOM(onstop, "onstop")
#ifdef MOZ_GAMEPAD
GK_ATOM(ongamepadbuttondown, "ongamepadbuttondown")
GK_ATOM(ongamepadbuttonup, "ongamepadbuttonup")
GK_ATOM(ongamepadaxismove, "ongamepadaxismove")
GK_ATOM(ongamepadconnected, "ongamepadconnected")
GK_ATOM(ongamepaddisconnected, "ongamepaddisconnected")
#endif

// Content property names
GK_ATOM(animationsProperty, "AnimationsProperty")        // FrameAnimations*
GK_ATOM(animationsOfBeforeProperty, "AnimationsOfBeforeProperty") // FrameAnimations*
GK_ATOM(animationsOfAfterProperty, "AnimationsOfAfterProperty") // FrameAnimations*
GK_ATOM(transitionsProperty, "TransitionsProperty")        // FrameTransitions*
GK_ATOM(transitionsOfBeforeProperty, "TransitionsOfBeforeProperty") // FrameTransitions*
GK_ATOM(transitionsOfAfterProperty, "TransitionsOfAfterProperty") // FrameTransitions*
GK_ATOM(genConInitializerProperty, "QuoteNodeProperty")
GK_ATOM(labelMouseDownPtProperty, "LabelMouseDownPtProperty")
GK_ATOM(baseURIProperty, "baseURIProperty")
GK_ATOM(lockedStyleStates, "lockedStyleStates")

// Languages for lang-specific transforms
GK_ATOM(Japanese, "ja")
GK_ATOM(Chinese, "zh-CN")
GK_ATOM(Taiwanese, "zh-TW")
GK_ATOM(HongKongChinese, "zh-HK")
GK_ATOM(Unicode, "x-unicode")

// language codes specifically referenced in the gfx code
GK_ATOM(ko, "ko")
GK_ATOM(zh_cn, "zh-cn")
GK_ATOM(zh_hk, "zh-hk")
GK_ATOM(zh_tw, "zh-tw")

// additional codes used in nsUnicodeRange.cpp
GK_ATOM(x_cyrillic, "x-cyrillic")
GK_ATOM(he, "he")
GK_ATOM(ar, "ar")
GK_ATOM(x_baltic, "x-baltic")
GK_ATOM(x_devanagari, "x-devanagari")
GK_ATOM(x_tamil, "x-tamil")
GK_ATOM(x_armn, "x-armn")
GK_ATOM(x_beng, "x-beng")
GK_ATOM(x_cans, "x-cans")
GK_ATOM(x_ethi, "x-ethi")
GK_ATOM(x_geor, "x-geor")
GK_ATOM(x_gujr, "x-gujr")
GK_ATOM(x_guru, "x-guru")
GK_ATOM(x_khmr, "x-khmr")
GK_ATOM(x_knda, "x-knda")
GK_ATOM(x_mlym, "x-mlym")
GK_ATOM(x_orya, "x-orya")
GK_ATOM(x_sinh, "x-sinh")
GK_ATOM(x_telu, "x-telu")
GK_ATOM(x_tibt, "x-tibt")

// used in gfxGDIFontList.h
GK_ATOM(ko_xxx, "ko-xxx")
GK_ATOM(x_central_euro, "x-central-euro")
GK_ATOM(x_symbol, "x-symbol")

// additional languages that have special case transformations
GK_ATOM(az, "az")
GK_ATOM(ba, "ba")
GK_ATOM(crh, "crh")
GK_ATOM(nl, "nl")
GK_ATOM(el, "el")

// Names for editor transactions
GK_ATOM(TypingTxnName, "Typing")
GK_ATOM(IMETxnName, "IME")
GK_ATOM(DeleteTxnName, "Deleting")

// IPC stuff
GK_ATOM(Remote, "remote")
GK_ATOM(RemoteId, "_remote_id")
GK_ATOM(DisplayPort, "_displayport")
GK_ATOM(CriticalDisplayPort, "_critical_displayport")

// Names for system metrics
GK_ATOM(color_picker_available, "color-picker-available")
GK_ATOM(scrollbar_start_backward, "scrollbar-start-backward")
GK_ATOM(scrollbar_start_forward, "scrollbar-start-forward")
GK_ATOM(scrollbar_end_backward, "scrollbar-end-backward")
GK_ATOM(scrollbar_end_forward, "scrollbar-end-forward")
GK_ATOM(scrollbar_thumb_proportional, "scrollbar-thumb-proportional")
GK_ATOM(images_in_menus, "images-in-menus")
GK_ATOM(images_in_buttons, "images-in-buttons")
GK_ATOM(overlay_scrollbars, "overlay-scrollbars")
GK_ATOM(windows_default_theme, "windows-default-theme")
GK_ATOM(mac_graphite_theme, "mac-graphite-theme")
GK_ATOM(mac_lion_theme, "mac-lion-theme")
GK_ATOM(windows_compositor, "windows-compositor")
GK_ATOM(windows_glass, "windows-glass")
GK_ATOM(touch_enabled, "touch-enabled")
GK_ATOM(menubar_drag, "menubar-drag")
GK_ATOM(swipe_animation_enabled, "swipe-animation-enabled")
GK_ATOM(physical_home_button, "physical-home-button")

// windows theme selector metrics
GK_ATOM(windows_classic, "windows-classic")
GK_ATOM(windows_theme_aero, "windows-theme-aero")
GK_ATOM(windows_theme_aero_lite, "windows-theme-aero-lite")
GK_ATOM(windows_theme_luna_blue, "windows-theme-luna-blue")
GK_ATOM(windows_theme_luna_olive, "windows-theme-luna-olive")
GK_ATOM(windows_theme_luna_silver, "windows-theme-luna-silver")
GK_ATOM(windows_theme_royale, "windows-theme-royale")
GK_ATOM(windows_theme_zune, "windows-theme-zune")
GK_ATOM(windows_theme_generic, "windows-theme-generic")

// windows version info selector metrics, helpful in removing ambiguity
// in theme selectors.
GK_ATOM(windows_version_xp, "windows-version-xp")
GK_ATOM(windows_version_vista, "windows-version-vista")
GK_ATOM(windows_version_win7, "windows-version-win7")
GK_ATOM(windows_version_win8, "windows-version-win8")

// And the same again, as media query keywords.
GK_ATOM(_moz_color_picker_available, "-moz-color-picker-available")
GK_ATOM(_moz_scrollbar_start_backward, "-moz-scrollbar-start-backward")
GK_ATOM(_moz_scrollbar_start_forward, "-moz-scrollbar-start-forward")
GK_ATOM(_moz_scrollbar_end_backward, "-moz-scrollbar-end-backward")
GK_ATOM(_moz_scrollbar_end_forward, "-moz-scrollbar-end-forward")
GK_ATOM(_moz_scrollbar_thumb_proportional, "-moz-scrollbar-thumb-proportional")
GK_ATOM(_moz_images_in_menus, "-moz-images-in-menus")
GK_ATOM(_moz_images_in_buttons, "-moz-images-in-buttons")
GK_ATOM(_moz_overlay_scrollbars, "-moz-overlay-scrollbars")
GK_ATOM(_moz_windows_default_theme, "-moz-windows-default-theme")
GK_ATOM(_moz_mac_graphite_theme, "-moz-mac-graphite-theme")
GK_ATOM(_moz_mac_lion_theme, "-moz-mac-lion-theme")
GK_ATOM(_moz_windows_compositor, "-moz-windows-compositor")
GK_ATOM(_moz_windows_classic, "-moz-windows-classic")
GK_ATOM(_moz_windows_glass, "-moz-windows-glass")
GK_ATOM(_moz_windows_theme, "-moz-windows-theme")
GK_ATOM(_moz_os_version, "-moz-os-version")
GK_ATOM(_moz_touch_enabled, "-moz-touch-enabled")
GK_ATOM(_moz_menubar_drag, "-moz-menubar-drag")
GK_ATOM(_moz_device_pixel_ratio, "-moz-device-pixel-ratio")
GK_ATOM(_moz_device_orientation, "-moz-device-orientation")
GK_ATOM(_moz_is_resource_document, "-moz-is-resource-document")
GK_ATOM(_moz_swipe_animation_enabled, "-moz-swipe-animation-enabled")
GK_ATOM(_moz_physical_home_button, "-moz-physical-home-button")

// application commands
GK_ATOM(Back, "Back")
GK_ATOM(Forward, "Forward")
GK_ATOM(Reload, "Reload")
GK_ATOM(Stop, "Stop")
GK_ATOM(Search, "Search")
GK_ATOM(Bookmarks, "Bookmarks")
GK_ATOM(Home, "Home")
GK_ATOM(Clear, "Clear")
GK_ATOM(VolumeUp, "VolumeUp")
GK_ATOM(VolumeDown, "VolumeDown")
GK_ATOM(Menu, "Menu")
GK_ATOM(New, "New")
GK_ATOM(Open, "Open")
GK_ATOM(Close, "Close")
GK_ATOM(Save, "Save")
GK_ATOM(Find, "Find")
GK_ATOM(Help, "Help")
GK_ATOM(Print, "Print")
GK_ATOM(SendMail, "SendMail")
GK_ATOM(ForwardMail, "ForwardMail")
GK_ATOM(ReplyToMail, "ReplyToMail")

// Smooth scroll events origins
GK_ATOM(mouseWheel, "mouseWheel")  // For discrete wheel events (e.g. not OSX magic mouse)
GK_ATOM(pixels,     "pixels")
GK_ATOM(lines,      "lines")
GK_ATOM(pages,      "pages")
GK_ATOM(scrollbars, "scrollbars")
GK_ATOM(other,      "other")

#ifdef ACCESSIBILITY
GK_ATOM(alert, "alert")
GK_ATOM(alertdialog, "alertdialog")
GK_ATOM(application, "application")
GK_ATOM(anonid, "anonid")
GK_ATOM(aria_activedescendant, "aria-activedescendant")
GK_ATOM(aria_atomic, "aria-atomic")
GK_ATOM(aria_autocomplete, "aria-autocomplete")
GK_ATOM(aria_busy, "aria-busy")
GK_ATOM(aria_checked, "aria-checked")
GK_ATOM(aria_controls, "aria-controls")
GK_ATOM(aria_describedby, "aria-describedby")
GK_ATOM(aria_disabled, "aria-disabled")
GK_ATOM(aria_dropeffect, "aria-dropeffect")
GK_ATOM(aria_expanded, "aria-expanded")
GK_ATOM(aria_flowto, "aria-flowto")
GK_ATOM(aria_grabbed, "aria-grabbed")
GK_ATOM(aria_haspopup, "aria-haspopup")
GK_ATOM(aria_hidden, "aria-hidden")
GK_ATOM(aria_invalid, "aria-invalid")
GK_ATOM(aria_label, "aria-label")
GK_ATOM(aria_labelledby, "aria-labelledby")
GK_ATOM(aria_level, "aria-level")
GK_ATOM(aria_live, "aria-live")
GK_ATOM(aria_multiline, "aria-multiline")
GK_ATOM(aria_multiselectable, "aria-multiselectable")
GK_ATOM(aria_orientation, "aria-orientation")
GK_ATOM(aria_owns, "aria-owns")
GK_ATOM(aria_posinset, "aria-posinset")
GK_ATOM(aria_pressed, "aria-pressed")
GK_ATOM(aria_readonly, "aria-readonly")
GK_ATOM(aria_relevant, "aria-relevant")
GK_ATOM(aria_required, "aria-required")
GK_ATOM(aria_selected, "aria-selected")
GK_ATOM(aria_setsize, "aria-setsize")
GK_ATOM(aria_sort, "aria-sort")
GK_ATOM(aria_valuenow, "aria-valuenow")
GK_ATOM(aria_valuemin, "aria-valuemin")
GK_ATOM(aria_valuemax, "aria-valuemax")
GK_ATOM(aria_valuetext, "aria-valuetext")
GK_ATOM(AreaFrame, "AreaFrame")
GK_ATOM(auto_generated, "auto-generated")
GK_ATOM(backgroundColor, "background-color")
GK_ATOM(checkable, "checkable")
GK_ATOM(choices, "choices")
GK_ATOM(columnheader, "columnheader")
GK_ATOM(containerAtomic, "container-atomic")
GK_ATOM(containerBusy, "container-busy")
GK_ATOM(containerLive, "container-live")
GK_ATOM(containerLiveRole, "container-live-role")
GK_ATOM(containerRelevant, "container-relevant")
GK_ATOM(cycles, "cycles")
GK_ATOM(datatable, "datatable")
GK_ATOM(directory, "directory")
GK_ATOM(eventFromInput, "event-from-input")
GK_ATOM(grammar, "grammar")
GK_ATOM(gridcell, "gridcell")
GK_ATOM(heading, "heading")
GK_ATOM(InlineBlockFrame, "InlineBlockFrame")
GK_ATOM(inlinevalue, "inline")
GK_ATOM(invalid, "invalid")
GK_ATOM(item, "item")
GK_ATOM(itemset, "itemset")
GK_ATOM(lineNumber, "line-number")
GK_ATOM(linkedPanel, "linkedpanel")
GK_ATOM(live, "live")
GK_ATOM(marginBottom, "margin-bottom")
GK_ATOM(marginLeft, "margin-left")
GK_ATOM(marginRight, "margin-right")
GK_ATOM(marginTop, "margin-top")
GK_ATOM(menuitemcheckbox, "menuitemcheckbox")
GK_ATOM(menuitemradio, "menuitemradio")
GK_ATOM(mixed, "mixed")
GK_ATOM(multiline, "multiline")
GK_ATOM(password, "password")
GK_ATOM(posinset, "posinset")
GK_ATOM(presentation, "presentation")
GK_ATOM(progressbar, "progressbar")
GK_ATOM(region, "region")
GK_ATOM(rowgroup, "rowgroup")
GK_ATOM(rowheader, "rowheader")
GK_ATOM(select1, "select1")
GK_ATOM(setsize, "setsize")
GK_ATOM(spelling, "spelling")
GK_ATOM(spinbutton, "spinbutton")
GK_ATOM(status, "status")
GK_ATOM(tableCellIndex, "table-cell-index")
GK_ATOM(tablist, "tablist")
GK_ATOM(textAlign, "text-align")
GK_ATOM(textIndent, "text-indent")
GK_ATOM(textInputType, "text-input-type")
GK_ATOM(textLineThroughColor, "text-line-through-color")
GK_ATOM(textLineThroughStyle, "text-line-through-style")
GK_ATOM(textPosition, "text-position")
GK_ATOM(textUnderlineColor, "text-underline-color")
GK_ATOM(textUnderlineStyle, "text-underline-style")
GK_ATOM(timer, "timer")
GK_ATOM(toolbarname, "toolbarname")
GK_ATOM(toolbarseparator, "toolbarseparator")
GK_ATOM(toolbarspacer, "toolbarspacer")
GK_ATOM(toolbarspring, "toolbarspring")
GK_ATOM(treegrid, "treegrid")
GK_ATOM(_undefined, "undefined")
GK_ATOM(xmlroles, "xml-roles")
#endif

#ifdef MOZ_WEBSPEECH
GK_ATOM(onaudiostart, "onaudiostart")
GK_ATOM(onaudioend, "onaudioend")
GK_ATOM(onsoundstart, "onsoundstart")
GK_ATOM(onsoundend, "onsoundend")
GK_ATOM(onspeechstart, "onspeechstart")
GK_ATOM(onspeechend, "onspeechend")
GK_ATOM(onresult, "onresult")
GK_ATOM(onnomatch, "onnomatch")
GK_ATOM(onstart, "onstart")
GK_ATOM(onresume, "onresume")
GK_ATOM(onmark, "onmark")
GK_ATOM(onboundary, "onboundary")
#endif
