/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_ErrorEvent_h__
#define mozilla_dom_ErrorEvent_h__

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/ErrorEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;

namespace mozilla {
namespace dom {

class ErrorEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(ErrorEvent, Event)
  virtual ~ErrorEvent();
protected:
  ErrorEvent(mozilla::dom::EventTarget* aOwner);

  nsString mMessage;
  nsString mFilename;
  uint32_t mLineno;
  uint32_t mColno;
  JS::Heap<JS::Value> mError;

public:
  virtual ErrorEvent* AsErrorEvent();

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<ErrorEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ErrorEventInit& aEventInitDict);

  static already_AddRefed<ErrorEvent> Constructor(const GlobalObject& aGlobal, JSContext* aCx, const nsAString& aType, const ErrorEventInit& aEventInitDict, ErrorResult& aRv);

  void GetMessage(nsString& aRetVal) const;

  void GetFilename(nsString& aRetVal) const;

  uint32_t Lineno() const;

  uint32_t Colno() const;

  JS::Value Error(JSContext* cx) const;

};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ErrorEvent_h__
