/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_StorageEvent_h
#define mozilla_dom_StorageEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/StorageEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class StorageEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(StorageEvent, Event)
  virtual ~StorageEvent();
protected:
  StorageEvent(mozilla::dom::EventTarget* aOwner);

  nsString mKey;
  nsString mOldValue;
  nsString mNewValue;
  nsString mUrl;
  nsRefPtr<nsIDOMStorage> mStorageArea;

public:
  virtual StorageEvent* AsStorageEvent();

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<StorageEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const StorageEventInit& aEventInitDict);


  static already_AddRefed<StorageEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const StorageEventInit& aEventInitDict, ErrorResult& aRv);

  void GetKey(nsString& aRetVal) const;

  void GetOldValue(nsString& aRetVal) const;

  void GetNewValue(nsString& aRetVal) const;

  void GetUrl(nsString& aRetVal) const;

  nsIDOMStorage* GetStorageArea() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_StorageEvent_h
