/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_DataStoreImplBinding_h
#define mozilla_dom_DataStoreImplBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class DataStore;
class DataStoreCursor;
class DataStoreCursorImpl;
struct DataStoreCursorImplAtoms;
class DataStoreImpl;
struct DataStoreImplAtoms;
class EventTarget;
struct NativePropertyHooks;
class OwningStringOrUnsignedLong;
class Promise;
class ProtoAndIfaceCache;
class StringOrUnsignedLong;

namespace workers {

class WorkerDataStore;
class WorkerDataStoreCursor;

} // namespace workers

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

namespace DataStoreCursorImplBinding {

  typedef mozilla::dom::DataStoreCursorImpl NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::DataStoreCursorImpl* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreCursorImplBinding



namespace DataStoreImplBinding {

  typedef mozilla::dom::DataStoreImpl NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::DataStoreImpl* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreImplBinding



class DataStoreCursorImplJSImpl : public CallbackInterface
{
public:
  explicit inline DataStoreCursorImplJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DataStoreCursorImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<DataStore> GetStore(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DataStoreCursorImplAtoms* atomsCache);
};


class DataStoreCursorImpl MOZ_FINAL : public nsSupportsWeakReference,
                                      public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(DataStoreCursorImpl)

private:
  nsRefPtr<DataStoreCursorImplJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DataStoreCursorImpl(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DataStore> GetStore(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class DataStoreImplJSImpl : public CallbackInterface
{
public:
  explicit inline DataStoreImplJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void SetEventTarget(EventTarget& eventTarget, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Get(const nsTArray<OwningStringOrUnsignedLong>& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Put(JS::Handle<JS::Value> obj, const StringOrUnsignedLong& id, const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Add(JS::Handle<JS::Value> obj, const Optional<StringOrUnsignedLong>& id, const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Remove(const StringOrUnsignedLong& id, const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Clear(const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetLength(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DataStoreCursor> Sync(const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DataStoreImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetName(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetOwner(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetReadOnly(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRevisionId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DataStoreImplAtoms* atomsCache);
};


class DataStoreImpl MOZ_FINAL : public nsSupportsWeakReference,
                                public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(DataStoreImpl)

private:
  nsRefPtr<DataStoreImplJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DataStoreImpl(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  void SetEventTarget(EventTarget& eventTarget, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetName(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetOwner(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetReadOnly(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Get(const Sequence<OwningStringOrUnsignedLong>& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Put(JS::Handle<JS::Value> obj, const StringOrUnsignedLong& id, const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Add(JS::Handle<JS::Value> obj, const Optional<StringOrUnsignedLong>& id, const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Remove(const StringOrUnsignedLong& id, const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> Clear(const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRevisionId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<Promise> GetLength(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DataStoreCursor> Sync(const nsAString& revisionId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DataStoreImplBinding_h
