/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_InstallTriggerBinding_h
#define mozilla_dom_InstallTriggerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/MozMap.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class InstallTriggerCallback;
struct InstallTriggerDataAtoms;
class InstallTriggerImpl;
struct InstallTriggerImplAtoms;
struct NativePropertyHooks;
class OwningStringOrInstallTriggerData;
class ProtoAndIfaceCache;
class StringOrInstallTriggerData;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct InstallTriggerData : public DictionaryBase
{
  Optional<nsString> mHash;
  Optional<nsString> mIconURL;
  Optional<nsString> mURL;

  InstallTriggerData();

  explicit inline InstallTriggerData(const InstallTriggerData& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline InstallTriggerData(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerDataAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const InstallTriggerData& aOther);
};

namespace binding_detail {
struct FastInstallTriggerData : public InstallTriggerData
{
  inline FastInstallTriggerData()
    : InstallTriggerData(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class InstallTriggerCallback : public CallbackFunction
{
public:
  explicit inline InstallTriggerCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline InstallTriggerCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, const nsAString& url, int16_t status, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, url, status, aRv);
  }

  inline void
  Call(const nsAString& url, int16_t status, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, url, status, aRv);
  }

  inline bool
  operator==(const InstallTriggerCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const nsAString& url, int16_t status, ErrorResult& aRv);
};


namespace InstallTriggerImplBinding {

  typedef mozilla::dom::InstallTriggerImpl NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::InstallTriggerImpl* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace InstallTriggerImplBinding



class InstallTriggerImplJSImpl : public CallbackInterface
{
public:
  explicit inline InstallTriggerImplJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  bool Enabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool Install(const MozMap<OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const InstallTriggerImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerImplAtoms* atomsCache);
};


class InstallTriggerImpl MOZ_FINAL : public nsSupportsWeakReference,
                                     public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(InstallTriggerImpl)

private:
  nsRefPtr<InstallTriggerImplJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  InstallTriggerImpl(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

private:
  ~InstallTriggerImpl();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  bool Enabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool Install(const MozMap<OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_InstallTriggerBinding_h
