/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_SpeechRecognitionEvent_h
#define mozilla_dom_SpeechRecognitionEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/SpeechRecognitionEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class SpeechRecognitionEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(SpeechRecognitionEvent, Event)
  virtual ~SpeechRecognitionEvent();
protected:
  SpeechRecognitionEvent(mozilla::dom::EventTarget* aOwner);

  uint32_t mResultIndex;
  nsRefPtr<nsISupports> mResults;
  nsString mInterpretation;
  nsRefPtr<nsIDocument> mEmma;

public:
  virtual SpeechRecognitionEvent* AsSpeechRecognitionEvent();

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<SpeechRecognitionEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SpeechRecognitionEventInit& aEventInitDict);

  static already_AddRefed<SpeechRecognitionEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SpeechRecognitionEventInit& aEventInitDict, ErrorResult& aRv);

  uint32_t ResultIndex() const;

  nsISupports* GetResults() const;

  void GetInterpretation(nsString& aRetVal) const;

  nsIDocument* GetEmma() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SpeechRecognitionEvent_h
