/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_WindowBinding_h
#define mozilla_dom_WindowBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"

class nsGlobalWindow;
struct nsGlobalWindowAtoms;

namespace mozilla {
namespace dom {

class ChromeWindow;
struct ChromeWindowAtoms;
class FrameRequestCallback;
struct NativePropertyHooks;
class OverfillCallback;
class ProtoAndIfaceCache;
struct ScrollOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

MOZ_BEGIN_ENUM_CLASS(ScrollBehavior, uint32_t)
  Auto,
  Instant,
  Smooth,
  EndGuard_
MOZ_END_ENUM_CLASS(ScrollBehavior)

namespace ScrollBehaviorValues {
extern const EnumEntry strings[4];
} // namespace ScrollBehaviorValues


struct ScrollOptions : public DictionaryBase
{
  ScrollBehavior mBehavior;

  ScrollOptions();

  explicit inline ScrollOptions(const ScrollOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ScrollOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ScrollOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ScrollOptions& aOther);
};

namespace binding_detail {
struct FastScrollOptions : public ScrollOptions
{
  inline FastScrollOptions()
    : ScrollOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class OverfillCallback : public CallbackFunction
{
public:
  explicit inline OverfillCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline OverfillCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, uint32_t overfill, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, overfill, aRv);
  }

  inline void
  Call(uint32_t overfill, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, overfill, aRv);
  }

  inline bool
  operator==(const OverfillCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, uint32_t overfill, ErrorResult& aRv);
};


class FrameRequestCallback : public CallbackFunction
{
public:
  explicit inline FrameRequestCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline FrameRequestCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, double time, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, time, aRv);
  }

  inline void
  Call(double time, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, time, aRv);
  }

  inline bool
  operator==(const FrameRequestCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, double time, ErrorResult& aRv);
};


namespace ChromeWindowBinding {

  typedef mozilla::dom::ChromeWindow NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace ChromeWindowBinding



namespace WindowBinding {

  typedef nsGlobalWindow NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, nsGlobalWindow* aObject, nsWrapperCache* aCache, JS::CompartmentOptions& aOptions, JSPrincipals* aPrincipal, bool aInitStandardClasses);

  bool
  ClearCachedDocumentValue(JSContext* aCx, nsGlobalWindow* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  inline bool IsPermitted(JSFlatString* prop, jschar propFirstChar, bool set)
  {
    switch (propFirstChar) {
      case 'b': {
        if (!set && JS_FlatStringEqualsAscii(prop, "blur")) {
          return true;
        }
        break;
      }
      case 'c': {
        if (!set && JS_FlatStringEqualsAscii(prop, "close")) {
          return true;
        }
        if (!set && JS_FlatStringEqualsAscii(prop, "closed")) {
          return true;
        }
        break;
      }
      case 'f': {
        if (!set && JS_FlatStringEqualsAscii(prop, "focus")) {
          return true;
        }
        if (!set && JS_FlatStringEqualsAscii(prop, "frames")) {
          return true;
        }
        break;
      }
      case 'l': {
        if (!set && JS_FlatStringEqualsAscii(prop, "length")) {
          return true;
        }
        if (JS_FlatStringEqualsAscii(prop, "location")) {
          return true;
        }
        break;
      }
      case 'o': {
        if (!set && JS_FlatStringEqualsAscii(prop, "opener")) {
          return true;
        }
        break;
      }
      case 'p': {
        if (!set && JS_FlatStringEqualsAscii(prop, "parent")) {
          return true;
        }
        if (!set && JS_FlatStringEqualsAscii(prop, "postMessage")) {
          return true;
        }
        break;
      }
      case 's': {
        if (!set && JS_FlatStringEqualsAscii(prop, "self")) {
          return true;
        }
        break;
      }
      case 't': {
        if (!set && JS_FlatStringEqualsAscii(prop, "top")) {
          return true;
        }
        break;
      }
      case 'w': {
        if (!set && JS_FlatStringEqualsAscii(prop, "window")) {
          return true;
        }
        break;
      }
    }

    return false;
  }

} // namespace WindowBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WindowBinding_h
