/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RTCPeerConnectionBinding_h
#define mozilla_dom_RTCPeerConnectionBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

class JSObject;
class nsIDOMDataChannel;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class EventHandlerNonNull;
class MediaStreamTrack;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct RTCConfiguration;
struct RTCDataChannelInit;
struct RTCDataChannelInitAtoms;
class RTCIdentityAssertion;
struct RTCOfferOptions;
struct RTCOfferOptionsAtoms;
class RTCPeerConnectionErrorCallback;
class RTCSessionDescriptionCallback;
class RTCStatsCallback;
class RTCStatsReport;
class VoidFunction;
class mozRTCIceCandidate;
class mozRTCPeerConnection;
struct mozRTCPeerConnectionAtoms;
class mozRTCSessionDescription;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {

MOZ_BEGIN_ENUM_CLASS(RTCSignalingState, uint32_t)
  Stable,
  Have_local_offer,
  Have_remote_offer,
  Have_local_pranswer,
  Have_remote_pranswer,
  Closed,
  EndGuard_
MOZ_END_ENUM_CLASS(RTCSignalingState)

namespace RTCSignalingStateValues {
extern const EnumEntry strings[7];
} // namespace RTCSignalingStateValues


MOZ_BEGIN_ENUM_CLASS(RTCIceGatheringState, uint32_t)
  New,
  Gathering,
  Complete,
  EndGuard_
MOZ_END_ENUM_CLASS(RTCIceGatheringState)

namespace RTCIceGatheringStateValues {
extern const EnumEntry strings[4];
} // namespace RTCIceGatheringStateValues


MOZ_BEGIN_ENUM_CLASS(RTCIceConnectionState, uint32_t)
  New,
  Checking,
  Connected,
  Completed,
  Failed,
  Disconnected,
  Closed,
  EndGuard_
MOZ_END_ENUM_CLASS(RTCIceConnectionState)

namespace RTCIceConnectionStateValues {
extern const EnumEntry strings[8];
} // namespace RTCIceConnectionStateValues


struct RTCDataChannelInit : public DictionaryBase
{
  Nullable<uint16_t> mId;
  Optional<uint16_t> mMaxRetransmitNum;
  Nullable<uint16_t> mMaxRetransmitTime;
  Nullable<uint16_t> mMaxRetransmits;
  bool mNegotiated;
  bool mOrdered;
  Optional<bool> mOutOfOrderAllowed;
  Optional<bool> mPreset;
  nsString mProtocol;
  Optional<uint16_t> mStream;

  RTCDataChannelInit();

  explicit inline RTCDataChannelInit(const RTCDataChannelInit& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline RTCDataChannelInit(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCDataChannelInit& aOther);
};

namespace binding_detail {
struct FastRTCDataChannelInit : public RTCDataChannelInit
{
  inline FastRTCDataChannelInit()
    : RTCDataChannelInit(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCOfferOptions : public DictionaryBase
{
  Optional<bool> mMozBundleOnly;
  Optional<bool> mMozDontOfferDataChannel;
  Optional<int32_t> mOfferToReceiveAudio;
  Optional<int32_t> mOfferToReceiveVideo;

  RTCOfferOptions();

  explicit inline RTCOfferOptions(const RTCOfferOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline RTCOfferOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, RTCOfferOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCOfferOptions& aOther);
};

namespace binding_detail {
struct FastRTCOfferOptions : public RTCOfferOptions
{
  inline FastRTCOfferOptions()
    : RTCOfferOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RTCSessionDescriptionCallback : public CallbackFunction
{
public:
  explicit inline RTCSessionDescriptionCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, sdp, aRv);
  }

  inline void
  Call(mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, sdp, aRv);
  }

  inline bool
  operator==(const RTCSessionDescriptionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, mozRTCSessionDescription& sdp, ErrorResult& aRv);
};


class RTCPeerConnectionErrorCallback : public CallbackFunction
{
public:
  explicit inline RTCPeerConnectionErrorCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, const nsAString& errorInformation, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, errorInformation, aRv);
  }

  inline void
  Call(const nsAString& errorInformation, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, errorInformation, aRv);
  }

  inline bool
  operator==(const RTCPeerConnectionErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const nsAString& errorInformation, ErrorResult& aRv);
};


class VoidFunction : public CallbackFunction
{
public:
  explicit inline VoidFunction(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline VoidFunction(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, aRv);
  }

  inline bool
  operator==(const VoidFunction& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


class RTCStatsCallback : public CallbackFunction
{
public:
  explicit inline RTCStatsCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS_ObjectIsCallable(nullptr, mCallback));
  }

  explicit inline RTCStatsCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, RTCStatsReport& report, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, report, aRv);
  }

  inline void
  Call(RTCStatsReport& report, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, report, aRv);
  }

  inline bool
  operator==(const RTCStatsCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, RTCStatsReport& report, ErrorResult& aRv);
};


namespace mozRTCPeerConnectionBinding {

  typedef mozilla::dom::mozRTCPeerConnection NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::mozRTCPeerConnection* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace mozRTCPeerConnectionBinding



class mozRTCPeerConnectionJSImpl : public CallbackInterface
{
public:
  explicit inline mozRTCPeerConnectionJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void SetIdentityProvider(const nsAString& provider, const Optional<nsAString>& protocol, const Optional<nsAString>& username, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetIdentityAssertion(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetLocalDescription(mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction>>& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback>>& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetRemoteDescription(mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction>>& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback>>& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void UpdateIce(const RTCConfiguration& configuration, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddIceCandidate(mozRTCIceCandidate& candidate, const Optional<OwningNonNull<VoidFunction>>& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback>>& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStats(MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const mozRTCPeerConnectionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<RTCIdentityAssertion> GetPeerIdentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnidentityresult(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnpeeridentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnidpassertionerror(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnidpvalidationerror(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnidentityresult(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnpeeridentity(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnidpassertionerror(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnidpvalidationerror(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, mozRTCPeerConnectionAtoms* atomsCache);
};


class mozRTCPeerConnection MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(mozRTCPeerConnection, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<mozRTCPeerConnectionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  mozRTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

private:
  ~mozRTCPeerConnection();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<mozRTCPeerConnection> Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv);

  void SetIdentityProvider(const nsAString& provider, const Optional<nsAString>& protocol, const Optional<nsAString>& username, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetIdentityAssertion(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetLocalDescription(mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction>>& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback>>& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetRemoteDescription(mozRTCSessionDescription& description, const Optional<OwningNonNull<VoidFunction>>& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback>>& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void UpdateIce(const RTCConfiguration& configuration, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddIceCandidate(mozRTCIceCandidate& candidate, const Optional<OwningNonNull<VoidFunction>>& successCallback, const Optional<OwningNonNull<RTCPeerConnectionErrorCallback>>& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<RTCIdentityAssertion> GetPeerIdentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStats(MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnidentityresult(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnidentityresult(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnpeeridentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnpeeridentity(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnidpassertionerror(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnidpassertionerror(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnidpvalidationerror(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnidpvalidationerror(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCPeerConnectionBinding_h
