#ifndef mozilla_dom_FeatureList_h
#define mozilla_dom_FeatureList_h

#include "nsString.h"

namespace mozilla {
namespace dom {
bool IsFeatureDetectible(const nsAString& aFeature) {
  static const char* const FeatureList[] = {
    "DOMApplicationsManager",
    "DOMApplicationsManager.applyDownload",
    "DOMApplicationsManager.getAll",
    "DOMApplicationsManager.getNotInstalled",
    "DOMApplicationsManager.oninstall",
    "DOMApplicationsManager.onuninstall",
    "DOMApplicationsManager.uninstall",
    "DOMApplicationsRegistry.mgmt",
    "DOMDownload",
    "DOMDownload.contentType",
    "DOMDownload.currentBytes",
    "DOMDownload.error",
    "DOMDownload.id",
    "DOMDownload.onstatechange",
    "DOMDownload.path",
    "DOMDownload.pause",
    "DOMDownload.resume",
    "DOMDownload.startTime",
    "DOMDownload.state",
    "DOMDownload.storageName",
    "DOMDownload.storagePath",
    "DOMDownload.totalBytes",
    "DOMDownload.url",
    "DownloadEvent",
    "DownloadEvent.download",
    "DownloadEvent.isTrusted",
    "Navigator.addIdleObserver",
    "Navigator.getFeature",
    "Navigator.hasFeature",
    "Navigator.mozAlarms",
    "Navigator.mozPermissionSettings",
    "Navigator.mozPhoneNumberService",
    "Navigator.mozPower",
    "Navigator.push",
    "Navigator.removeIdleObserver",
    "NetworkStatsData",
    "NetworkStatsData.receivedBytes",
    "NetworkStatsData.sentBytes",
    "NetworkStatsData.timestamp",
    "PowerStatsData",
    "PowerStatsData.consumedPower",
    "PowerStatsData.timestamp",
    "ResourceStats",
    "ResourceStats.component",
    "ResourceStats.end",
    "ResourceStats.getData",
    "ResourceStats.manifestURL",
    "ResourceStats.serviceType",
    "ResourceStats.start",
    "ResourceStats.type",
    "ResourceStatsAlarm",
    "ResourceStatsAlarm.alarmId",
    "ResourceStatsAlarm.component",
    "ResourceStatsAlarm.data",
    "ResourceStatsAlarm.manifestURL",
    "ResourceStatsAlarm.serviceType",
    "ResourceStatsAlarm.threshold",
    "ResourceStatsAlarm.type",
    "ResourceStatsManager",
    "ResourceStatsManager.addAlarm",
    "ResourceStatsManager.clearAllStats",
    "ResourceStatsManager.clearStats",
    "ResourceStatsManager.getAlarms",
    "ResourceStatsManager.getAvailableComponents",
    "ResourceStatsManager.getStats",
    "ResourceStatsManager.maxStorageAge",
    "ResourceStatsManager.removeAlarm",
    "ResourceStatsManager.removeAllAlarms",
    "ResourceStatsManager.resourceTypes",
    "ResourceStatsManager.sampleRate",
    nullptr
  };
  const char* const* feature = FeatureList;
  while (*feature) {
    if (aFeature.EqualsASCII(*feature)) {
      return true;
    }
    ++feature;
  }

  return false;
}
} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_FeatureList_h
