/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_ConsoleBinding_h
#define mozilla_dom_ConsoleBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

class Console;
struct ConsoleAtoms;
struct ConsoleCounterAtoms;
struct ConsoleCounterErrorAtoms;
struct ConsoleEventAtoms;
struct ConsoleProfileEventAtoms;
struct ConsoleStackEntryAtoms;
struct ConsoleTimerEndAtoms;
struct ConsoleTimerErrorAtoms;
struct ConsoleTimerStartAtoms;
struct NativePropertyHooks;
class OwningUnsignedLongOrString;
class ProtoAndIfaceCache;
class UnsignedLongOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct ConsoleCounter : public DictionaryBase
{
  uint32_t mCount;
  nsString mLabel;

  ConsoleCounter();

  explicit inline ConsoleCounter(const ConsoleCounter& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ConsoleCounter(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ConsoleCounterAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleCounter& aOther);
};

namespace binding_detail {
struct FastConsoleCounter : public ConsoleCounter
{
  inline FastConsoleCounter()
    : ConsoleCounter(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleCounterError : public DictionaryBase
{
  nsString mError;

  ConsoleCounterError();

  explicit inline ConsoleCounterError(const ConsoleCounterError& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ConsoleCounterError(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ConsoleCounterErrorAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleCounterError& aOther);
};

namespace binding_detail {
struct FastConsoleCounterError : public ConsoleCounterError
{
  inline FastConsoleCounterError()
    : ConsoleCounterError(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleEvent : public DictionaryBase
{
  Optional<OwningUnsignedLongOrString> mID;
  Optional<Sequence<JS::Value>> mArguments;
  JS::Value mCounter;
  nsString mFilename;
  nsString mFunctionName;
  nsString mGroupName;
  Optional<OwningUnsignedLongOrString> mInnerID;
  nsString mLevel;
  uint32_t mLineNumber;
  bool mPrivate;
  Optional<Sequence<JS::Value>> mStyles;
  double mTimeStamp;
  JS::Value mTimer;

  ConsoleEvent();

protected:
  explicit inline ConsoleEvent(int )
    : mCounter(JS::UndefinedValue()),
      mTimer(JS::UndefinedValue())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  ConsoleEvent(const ConsoleEvent&) MOZ_DELETE;
  void operator=(const ConsoleEvent) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, ConsoleEventAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastConsoleEvent : public ConsoleEvent
{
  inline FastConsoleEvent()
    : ConsoleEvent(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleProfileEvent : public DictionaryBase
{
  nsString mAction;
  Optional<Sequence<JS::Value>> mArguments;

  ConsoleProfileEvent();

protected:
  explicit inline ConsoleProfileEvent(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  ConsoleProfileEvent(const ConsoleProfileEvent&) MOZ_DELETE;
  void operator=(const ConsoleProfileEvent) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, ConsoleProfileEventAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastConsoleProfileEvent : public ConsoleProfileEvent
{
  inline FastConsoleProfileEvent()
    : ConsoleProfileEvent(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleStackEntry : public DictionaryBase
{
  nsString mFilename;
  nsString mFunctionName;
  uint32_t mLanguage;
  uint32_t mLineNumber;

  ConsoleStackEntry();

  explicit inline ConsoleStackEntry(const ConsoleStackEntry& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ConsoleStackEntry(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ConsoleStackEntryAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleStackEntry& aOther);
};

namespace binding_detail {
struct FastConsoleStackEntry : public ConsoleStackEntry
{
  inline FastConsoleStackEntry()
    : ConsoleStackEntry(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerEnd : public DictionaryBase
{
  double mDuration;
  nsString mName;

  ConsoleTimerEnd();

  explicit inline ConsoleTimerEnd(const ConsoleTimerEnd& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ConsoleTimerEnd(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerEndAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleTimerEnd& aOther);
};

namespace binding_detail {
struct FastConsoleTimerEnd : public ConsoleTimerEnd
{
  inline FastConsoleTimerEnd()
    : ConsoleTimerEnd(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerError : public DictionaryBase
{
  nsString mError;

  ConsoleTimerError();

  explicit inline ConsoleTimerError(const ConsoleTimerError& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ConsoleTimerError(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerErrorAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleTimerError& aOther);
};

namespace binding_detail {
struct FastConsoleTimerError : public ConsoleTimerError
{
  inline FastConsoleTimerError()
    : ConsoleTimerError(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerStart : public DictionaryBase
{
  nsString mName;
  double mStarted;

  ConsoleTimerStart();

  explicit inline ConsoleTimerStart(const ConsoleTimerStart& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ConsoleTimerStart(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerStartAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleTimerStart& aOther);
};

namespace binding_detail {
struct FastConsoleTimerStart : public ConsoleTimerStart
{
  inline FastConsoleTimerStart()
    : ConsoleTimerStart(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ConsoleBinding {

  typedef mozilla::dom::Console NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::Console* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace ConsoleBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ConsoleBinding_h
