/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_DataStoreBinding_h
#define mozilla_dom_DataStoreBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

class DataStore;
struct DataStoreAtoms;
class DataStoreCursor;
struct DataStoreCursorAtoms;
struct DataStoreRevisionDataAtoms;
struct DataStoreTaskAtoms;
struct NativePropertyHooks;
class OwningStringOrUnsignedLong;
class ProtoAndIfaceCache;
class StringOrUnsignedLong;

namespace workers {

class WorkerDataStore;
struct WorkerDataStoreAtoms;
class WorkerDataStoreCursor;
struct WorkerDataStoreCursorAtoms;

} // namespace workers

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

MOZ_BEGIN_ENUM_CLASS(DataStoreOperation, uint32_t)
  Add,
  Update,
  Remove,
  Clear,
  Done,
  EndGuard_
MOZ_END_ENUM_CLASS(DataStoreOperation)

namespace DataStoreOperationValues {
extern const EnumEntry strings[6];
} // namespace DataStoreOperationValues


struct DataStoreRevisionData : public DictionaryBase
{
  uint32_t mObjectId;
  nsString mOperation;
  nsString mRevisionId;

  DataStoreRevisionData();

  explicit inline DataStoreRevisionData(const DataStoreRevisionData& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline DataStoreRevisionData(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, DataStoreRevisionDataAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const DataStoreRevisionData& aOther);
};

namespace binding_detail {
struct FastDataStoreRevisionData : public DataStoreRevisionData
{
  inline FastDataStoreRevisionData()
    : DataStoreRevisionData(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct DataStoreTask : public DictionaryBase
{
  JS::Value mData;
  Optional<Nullable<OwningStringOrUnsignedLong >> mId;
  Optional<DataStoreOperation> mOperation;
  Optional<nsString> mRevisionId;

  DataStoreTask();

protected:
  explicit inline DataStoreTask(int )
    : mData(JS::UndefinedValue())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  DataStoreTask(const DataStoreTask&) MOZ_DELETE;
  void operator=(const DataStoreTask) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, DataStoreTaskAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastDataStoreTask : public DataStoreTask
{
  inline FastDataStoreTask()
    : DataStoreTask(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace DataStoreBinding {

  typedef mozilla::dom::DataStore NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::DataStore* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreBinding



namespace DataStoreCursorBinding {

  typedef mozilla::dom::DataStoreCursor NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::DataStoreCursor* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreCursorBinding



namespace DataStoreCursorBinding_workers {

  typedef mozilla::dom::workers::WorkerDataStoreCursor NativeType;

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::workers::WorkerDataStoreCursor* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreCursorBinding_workers



namespace DataStoreBinding_workers {

  typedef mozilla::dom::workers::WorkerDataStore NativeType;

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::workers::WorkerDataStore* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace DataStoreBinding_workers



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DataStoreBinding_h
