/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_MediaStreamTrackEvent_h
#define mozilla_dom_MediaStreamTrackEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/MediaStreamTrackEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class MediaStreamTrackEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(MediaStreamTrackEvent, Event)
protected:
  virtual ~MediaStreamTrackEvent();
  MediaStreamTrackEvent(mozilla::dom::EventTarget* aOwner);

  nsRefPtr<RTCRtpReceiver> mReceiver;
  nsRefPtr<MediaStreamTrack> mTrack;
  nsRefPtr<DOMMediaStream> mStream;

public:
  virtual MediaStreamTrackEvent* AsMediaStreamTrackEvent();

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<MediaStreamTrackEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const MediaStreamTrackEventInit& aEventInitDict);

  static already_AddRefed<MediaStreamTrackEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const MediaStreamTrackEventInit& aEventInitDict, ErrorResult& aRv);

  RTCRtpReceiver* GetReceiver() const;

  MediaStreamTrack* GetTrack() const;

  DOMMediaStream* GetStream() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MediaStreamTrackEvent_h
