#ifndef mozilla_dom_FeatureList_h
#define mozilla_dom_FeatureList_h

#include "nsString.h"

namespace mozilla {
namespace dom {
bool IsFeatureDetectible(const nsAString& aFeature) {
  static const char* const FeatureList[] = {
    "DOMApplicationsManager",
    "DOMApplicationsManager.applyDownload",
    "DOMApplicationsManager.getAll",
    "DOMApplicationsManager.getNotInstalled",
    "DOMApplicationsManager.oninstall",
    "DOMApplicationsManager.onuninstall",
    "DOMApplicationsManager.uninstall",
    "DOMApplicationsRegistry.mgmt",
    "DOMDownload",
    "DOMDownload.contentType",
    "DOMDownload.currentBytes",
    "DOMDownload.error",
    "DOMDownload.id",
    "DOMDownload.onstatechange",
    "DOMDownload.path",
    "DOMDownload.pause",
    "DOMDownload.resume",
    "DOMDownload.startTime",
    "DOMDownload.state",
    "DOMDownload.storageName",
    "DOMDownload.storagePath",
    "DOMDownload.totalBytes",
    "DOMDownload.url",
    "DownloadEvent",
    "DownloadEvent.download",
    "DownloadEvent.isTrusted",
    "MozMobileConnection.cancelMMI",
    "MozMobileConnection.changeCallBarringPassword",
    "MozMobileConnection.data",
    "MozMobileConnection.exitEmergencyCbMode",
    "MozMobileConnection.getCallBarringOption",
    "MozMobileConnection.getCallForwardingOption",
    "MozMobileConnection.getCallWaitingOption",
    "MozMobileConnection.getCallingLineIdRestriction",
    "MozMobileConnection.getNetworks",
    "MozMobileConnection.getPreferredNetworkType",
    "MozMobileConnection.getRoamingPreference",
    "MozMobileConnection.getVoicePrivacyMode",
    "MozMobileConnection.iccId",
    "MozMobileConnection.lastKnownHomeNetwork",
    "MozMobileConnection.lastKnownNetwork",
    "MozMobileConnection.networkSelectionMode",
    "MozMobileConnection.radioState",
    "MozMobileConnection.selectNetwork",
    "MozMobileConnection.selectNetworkAutomatically",
    "MozMobileConnection.sendMMI",
    "MozMobileConnection.setCallBarringOption",
    "MozMobileConnection.setCallForwardingOption",
    "MozMobileConnection.setCallWaitingOption",
    "MozMobileConnection.setCallingLineIdRestriction",
    "MozMobileConnection.setPreferredNetworkType",
    "MozMobileConnection.setRadioEnabled",
    "MozMobileConnection.setRoamingPreference",
    "MozMobileConnection.setVoicePrivacyMode",
    "MozMobileConnection.supportedNetworkTypes",
    "MozMobileConnection.voice",
    "MozSettingsTransactionEvent",
    "MozSettingsTransactionEvent.error",
    "MozSettingsTransactionEvent.isTrusted",
    "Navigator.addIdleObserver",
    "Navigator.engineeringMode",
    "Navigator.getFeature",
    "Navigator.hasFeature",
    "Navigator.mozAlarms",
    "Navigator.mozPermissionSettings",
    "Navigator.mozPhoneNumberService",
    "Navigator.mozPower",
    "Navigator.push",
    "Navigator.removeIdleObserver",
    "NetworkStatsData",
    "NetworkStatsData.receivedBytes",
    "NetworkStatsData.sentBytes",
    "NetworkStatsData.timestamp",
    "PowerStatsData",
    "PowerStatsData.consumedPower",
    "PowerStatsData.timestamp",
    "ResourceStats",
    "ResourceStats.component",
    "ResourceStats.end",
    "ResourceStats.getData",
    "ResourceStats.manifestURL",
    "ResourceStats.serviceType",
    "ResourceStats.start",
    "ResourceStats.type",
    "ResourceStatsAlarm",
    "ResourceStatsAlarm.alarmId",
    "ResourceStatsAlarm.component",
    "ResourceStatsAlarm.data",
    "ResourceStatsAlarm.manifestURL",
    "ResourceStatsAlarm.serviceType",
    "ResourceStatsAlarm.threshold",
    "ResourceStatsAlarm.type",
    "ResourceStatsManager",
    "ResourceStatsManager.addAlarm",
    "ResourceStatsManager.clearAllStats",
    "ResourceStatsManager.clearStats",
    "ResourceStatsManager.getAlarms",
    "ResourceStatsManager.getAvailableComponents",
    "ResourceStatsManager.getStats",
    "ResourceStatsManager.maxStorageAge",
    "ResourceStatsManager.removeAlarm",
    "ResourceStatsManager.removeAllAlarms",
    "ResourceStatsManager.resourceTypes",
    "ResourceStatsManager.sampleRate",
    "UDPMessageEvent",
    "UDPMessageEvent.data",
    "UDPMessageEvent.isTrusted",
    "UDPMessageEvent.remoteAddress",
    "UDPMessageEvent.remotePort",
    "UDPSocket",
    "UDPSocket.addressReuse",
    "UDPSocket.close",
    "UDPSocket.closed",
    "UDPSocket.joinMulticastGroup",
    "UDPSocket.leaveMulticastGroup",
    "UDPSocket.localAddress",
    "UDPSocket.localPort",
    "UDPSocket.loopback",
    "UDPSocket.onmessage",
    "UDPSocket.opened",
    "UDPSocket.readyState",
    "UDPSocket.remoteAddress",
    "UDPSocket.remotePort",
    "UDPSocket.send",
    nullptr
  };
  const char* const* feature = FeatureList;
  while (*feature) {
    if (aFeature.EqualsASCII(*feature)) {
      return true;
    }
    ++feature;
  }

  return false;
}
} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_FeatureList_h
