/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_USSDReceivedEvent_h
#define mozilla_dom_USSDReceivedEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/USSDReceivedEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class USSDReceivedEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(USSDReceivedEvent, Event)
protected:
  virtual ~USSDReceivedEvent();
  explicit USSDReceivedEvent(mozilla::dom::EventTarget* aOwner);

  uint32_t mServiceId;
  nsString mMessage;
  nsRefPtr<USSDSession> mSession;
  bool mSessionEnded;

public:
  virtual USSDReceivedEvent* AsUSSDReceivedEvent();

  virtual JSObject* WrapObjectInternal(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<USSDReceivedEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const USSDReceivedEventInit& aEventInitDict);

  static already_AddRefed<USSDReceivedEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const USSDReceivedEventInit& aEventInitDict, ErrorResult& aRv);

  uint32_t ServiceId() const;

  void GetMessage(nsString& aRetVal) const;

  USSDSession* GetSession() const;

  bool SessionEnded() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_USSDReceivedEvent_h
