/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_WindowBinding_h
#define mozilla_dom_WindowBinding_h

#include "WindowBinding.h"
#include "jsapi.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

class nsGlobalWindow;
struct nsGlobalWindowAtoms;
class nsIDOMWindow;

namespace mozilla {
namespace dom {

class ChromeWindow;
struct ChromeWindowAtoms;
class External;
class FrameRequestCallback;
struct NativePropertyHooks;
class OverfillCallback;
class OwningExternalOrWindowProxy;
class ProtoAndIfaceCache;
struct ScrollOptionsAtoms;
struct ScrollToOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

MOZ_BEGIN_ENUM_CLASS(ScrollBehavior, uint32_t)
  Auto,
  Instant,
  Smooth,
  EndGuard_
MOZ_END_ENUM_CLASS(ScrollBehavior)

namespace ScrollBehaviorValues {
extern const EnumEntry strings[4];
} // namespace ScrollBehaviorValues


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningExternalOrWindowProxy& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningExternalOrWindowProxy& aUnion);


class ExternalOrWindowProxy
{
  friend class ExternalOrWindowProxyArgument;
  enum Type
  {
    eUninitialized,
    eExternal,
    eWindowProxy
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::External> > mExternal;
    UnionMember<nsIDOMWindow* > mWindowProxy;

  };

  Type mType;
  Value mValue;

  ExternalOrWindowProxy(const ExternalOrWindowProxy&) MOZ_DELETE;
  void operator=(const ExternalOrWindowProxy) MOZ_DELETE;
public:
  explicit inline ExternalOrWindowProxy()
    : mType(eUninitialized)
  {
  }

  inline ~ExternalOrWindowProxy()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::External>&
  RawSetAsExternal()
  {
    if (mType == eExternal) {
      return mValue.mExternal.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eExternal;
    return mValue.mExternal.SetValue();
  }

  inline NonNull<mozilla::dom::External>&
  SetAsExternal()
  {
    if (mType == eExternal) {
      return mValue.mExternal.Value();
    }
    Uninit();
    mType = eExternal;
    return mValue.mExternal.SetValue();
  }

  inline bool
  IsExternal() const
  {
    return mType == eExternal;
  }

  inline NonNull<mozilla::dom::External>&
  GetAsExternal()
  {
    MOZ_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  inline mozilla::dom::External&
  GetAsExternal() const
  {
    MOZ_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  inline nsIDOMWindow*&
  RawSetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline nsIDOMWindow*&
  SetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    Uninit();
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline nsIDOMWindow*&
  GetAsWindowProxy()
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline nsIDOMWindow*
  GetAsWindowProxy() const
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyExternal()
  {
    MOZ_ASSERT(IsExternal(), "Wrong type!");
    mValue.mExternal.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyWindowProxy()
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    mValue.mWindowProxy.Destroy();
    mType = eUninitialized;
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eExternal: {
        DestroyExternal();
        break;
      }
      case eWindowProxy: {
        DestroyWindowProxy();
        break;
      }
    }
  }
};


class OwningExternalOrWindowProxy : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningExternalOrWindowProxy& aUnion);
  enum Type
  {
    eUninitialized,
    eExternal,
    eWindowProxy
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::External> > mExternal;
    UnionMember<nsRefPtr<nsIDOMWindow> > mWindowProxy;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningExternalOrWindowProxy()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningExternalOrWindowProxy(const OwningExternalOrWindowProxy& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningExternalOrWindowProxy()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::External>&
  RawSetAsExternal();

  OwningNonNull<mozilla::dom::External>&
  SetAsExternal();

  bool
  TrySetToExternal(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsExternal() const
  {
    return mType == eExternal;
  }

  inline OwningNonNull<mozilla::dom::External>&
  GetAsExternal()
  {
    MOZ_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  inline OwningNonNull<mozilla::dom::External> const &
  GetAsExternal() const
  {
    MOZ_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  nsRefPtr<nsIDOMWindow>&
  RawSetAsWindowProxy();

  nsRefPtr<nsIDOMWindow>&
  SetAsWindowProxy();

  bool
  TrySetToWindowProxy(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline nsRefPtr<nsIDOMWindow>&
  GetAsWindowProxy()
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline nsRefPtr<nsIDOMWindow> const &
  GetAsWindowProxy() const
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningExternalOrWindowProxy& aOther);

private:
  void
  DestroyExternal();

  void
  DestroyWindowProxy();

  void
  Uninit();
};


struct ScrollOptions : public DictionaryBase
{
  ScrollBehavior mBehavior;

  ScrollOptions();

  explicit inline ScrollOptions(const ScrollOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ScrollOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ScrollOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ScrollOptions& aOther);
};

namespace binding_detail {
struct FastScrollOptions : public ScrollOptions
{
  inline FastScrollOptions()
    : ScrollOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ScrollToOptions : public ScrollOptions
{
  Optional<double> mLeft;
  Optional<double> mTop;

  ScrollToOptions();

  explicit inline ScrollToOptions(const ScrollToOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ScrollToOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ScrollToOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ScrollToOptions& aOther);
};

namespace binding_detail {
struct FastScrollToOptions : public ScrollToOptions
{
  inline FastScrollToOptions()
    : ScrollToOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class OverfillCallback : public CallbackFunction
{
public:
  explicit inline OverfillCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline OverfillCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, uint32_t overfill, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, overfill, aRv);
  }

  inline void
  Call(uint32_t overfill, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, overfill, aRv);
  }

  inline bool
  operator==(const OverfillCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, uint32_t overfill, ErrorResult& aRv);
};


class FrameRequestCallback : public CallbackFunction
{
public:
  explicit inline FrameRequestCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline FrameRequestCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, double time, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, time, aRv);
  }

  inline void
  Call(double time, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, time, aRv);
  }

  inline bool
  operator==(const FrameRequestCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, double time, ErrorResult& aRv);
};


namespace ChromeWindowBinding {

  typedef mozilla::dom::ChromeWindow NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace ChromeWindowBinding



namespace WindowBinding {

  typedef nsGlobalWindow NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, nsGlobalWindow* aObject, nsWrapperCache* aCache, JS::CompartmentOptions& aOptions, JSPrincipals* aPrincipal, bool aInitStandardClasses);

  bool
  ClearCachedDocumentValue(JSContext* aCx, nsGlobalWindow* aObject);

  bool
  ClearCachedPerformanceValue(JSContext* aCx, nsGlobalWindow* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  inline bool IsPermitted(JSFlatString* prop, char16_t propFirstChar, bool set)
  {
    switch (propFirstChar) {
      case 'b': {
        if (!set && JS_FlatStringEqualsAscii(prop, "blur")) {
          return true;
        }
        break;
      }
      case 'c': {
        if (!set && JS_FlatStringEqualsAscii(prop, "close")) {
          return true;
        }
        if (!set && JS_FlatStringEqualsAscii(prop, "closed")) {
          return true;
        }
        break;
      }
      case 'f': {
        if (!set && JS_FlatStringEqualsAscii(prop, "focus")) {
          return true;
        }
        if (!set && JS_FlatStringEqualsAscii(prop, "frames")) {
          return true;
        }
        break;
      }
      case 'l': {
        if (!set && JS_FlatStringEqualsAscii(prop, "length")) {
          return true;
        }
        if (JS_FlatStringEqualsAscii(prop, "location")) {
          return true;
        }
        break;
      }
      case 'o': {
        if (!set && JS_FlatStringEqualsAscii(prop, "opener")) {
          return true;
        }
        break;
      }
      case 'p': {
        if (!set && JS_FlatStringEqualsAscii(prop, "parent")) {
          return true;
        }
        if (!set && JS_FlatStringEqualsAscii(prop, "postMessage")) {
          return true;
        }
        break;
      }
      case 's': {
        if (!set && JS_FlatStringEqualsAscii(prop, "self")) {
          return true;
        }
        break;
      }
      case 't': {
        if (!set && JS_FlatStringEqualsAscii(prop, "top")) {
          return true;
        }
        break;
      }
      case 'w': {
        if (!set && JS_FlatStringEqualsAscii(prop, "window")) {
          return true;
        }
        break;
      }
    }

    return false;
  }

} // namespace WindowBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WindowBinding_h
