/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_MozTetheringManagerBinding_h
#define mozilla_dom_MozTetheringManagerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class MozTetheringManager;
struct MozTetheringManagerAtoms;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;
struct TetheringConfiguration;
struct TetheringConfigurationAtoms;
struct WifiTetheringConfig;
struct WifiTetheringConfigAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

MOZ_BEGIN_ENUM_CLASS(TetheringType, uint32_t)
  Bluetooth,
  Usb,
  Wifi,
  EndGuard_
MOZ_END_ENUM_CLASS(TetheringType)

namespace TetheringTypeValues {
extern const EnumEntry strings[4];
} // namespace TetheringTypeValues


MOZ_BEGIN_ENUM_CLASS(SecurityType, uint32_t)
  Open,
  Wpa_psk,
  Wpa2_psk,
  EndGuard_
MOZ_END_ENUM_CLASS(SecurityType)

namespace SecurityTypeValues {
extern const EnumEntry strings[4];
} // namespace SecurityTypeValues


struct WifiTetheringConfig : public DictionaryBase
{
  Optional<nsString> mKey;
  Optional<SecurityType> mSecurity;
  Optional<nsString> mSsid;

  WifiTetheringConfig();

  explicit inline WifiTetheringConfig(const WifiTetheringConfig& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline WifiTetheringConfig(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, WifiTetheringConfigAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const WifiTetheringConfig& aOther);
};

namespace binding_detail {
struct FastWifiTetheringConfig : public WifiTetheringConfig
{
  inline FastWifiTetheringConfig()
    : WifiTetheringConfig(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct TetheringConfiguration : public DictionaryBase
{
  Optional<nsString> mDns1;
  Optional<nsString> mDns2;
  Optional<nsString> mEndIp;
  Optional<nsString> mIp;
  Optional<nsString> mPrefix;
  Optional<nsString> mStartIp;
  WifiTetheringConfig mWifiConfig;

  TetheringConfiguration();

  explicit inline TetheringConfiguration(const TetheringConfiguration& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline TetheringConfiguration(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, TetheringConfigurationAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const TetheringConfiguration& aOther);
};

namespace binding_detail {
struct FastTetheringConfiguration : public TetheringConfiguration
{
  inline FastTetheringConfiguration()
    : TetheringConfiguration(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MozTetheringManagerBinding {

  typedef mozilla::dom::MozTetheringManager NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::MozTetheringManager* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozTetheringManagerBinding



class MozTetheringManagerJSImpl : public CallbackInterface
{
public:
  explicit inline MozTetheringManagerJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> SetTetheringEnabled(bool enabled, TetheringType type, const TetheringConfiguration& config, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozTetheringManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, MozTetheringManagerAtoms* atomsCache);
};


class MozTetheringManager MOZ_FINAL : public nsSupportsWeakReference,
                                      public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozTetheringManager)

private:
  nsRefPtr<MozTetheringManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozTetheringManager(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

private:
  ~MozTetheringManager();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetTetheringEnabled(bool enabled, TetheringType type, const TetheringConfiguration& config, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MozTetheringManagerBinding_h
