/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_CallEvent_h
#define mozilla_dom_CallEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla {
namespace dom {

class CallEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(CallEvent, Event)
protected:
  virtual ~CallEvent();
  explicit CallEvent(mozilla::dom::EventTarget* aOwner);

  nsRefPtr<TelephonyCall> mCall;

public:
  virtual CallEvent* AsCallEvent();

  virtual JSObject* WrapObjectInternal(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<CallEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const CallEventInit& aEventInitDict);

  static already_AddRefed<CallEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const CallEventInit& aEventInitDict, ErrorResult& aRv);

  TelephonyCall* GetCall() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_CallEvent_h
