/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_HashChangeEvent_h
#define mozilla_dom_HashChangeEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/HashChangeEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class HashChangeEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(HashChangeEvent, Event)
protected:
  virtual ~HashChangeEvent();
  explicit HashChangeEvent(mozilla::dom::EventTarget* aOwner);

  nsString mOldURL;
  nsString mNewURL;

public:
  virtual HashChangeEvent* AsHashChangeEvent();

  virtual JSObject* WrapObjectInternal(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<HashChangeEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const HashChangeEventInit& aEventInitDict);

  static already_AddRefed<HashChangeEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const HashChangeEventInit& aEventInitDict, ErrorResult& aRv);

  void GetOldURL(nsString& aRetVal) const;

  void GetNewURL(nsString& aRetVal) const;

  void InitHashChangeEvent(const nsAString& aTypeArg, bool aCanBubbleArg, bool aCancelableArg, const nsAString& aOldURLArg, const nsAString& aNewURLArg, ErrorResult& aRv);
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_HashChangeEvent_h
