/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_DeviceOrientationEvent_h
#define mozilla_dom_DeviceOrientationEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DeviceOrientationEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla {
namespace dom {

class DeviceOrientationEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(DeviceOrientationEvent, Event)
protected:
  virtual ~DeviceOrientationEvent();
  explicit DeviceOrientationEvent(mozilla::dom::EventTarget* aOwner);

  Nullable<double> mAlpha;
  Nullable<double> mBeta;
  Nullable<double> mGamma;
  bool mAbsolute;

public:
  virtual DeviceOrientationEvent* AsDeviceOrientationEvent();

  virtual JSObject* WrapObjectInternal(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<DeviceOrientationEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const DeviceOrientationEventInit& aEventInitDict);

  static already_AddRefed<DeviceOrientationEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const DeviceOrientationEventInit& aEventInitDict, ErrorResult& aRv);

  Nullable<double> GetAlpha() const;

  Nullable<double> GetBeta() const;

  Nullable<double> GetGamma() const;

  bool Absolute() const;

  void InitDeviceOrientationEvent(const nsAString& aType, bool aCanBubble, bool aCancelable, const Nullable<double>& aAlpha, const Nullable<double>& aBeta, const Nullable<double>& aGamma, bool aAbsolute, ErrorResult& aRv);
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DeviceOrientationEvent_h
