/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_MozMobileMessageManagerBinding_h
#define mozilla_dom_MozMobileMessageManagerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/File.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

class nsIDOMMozMmsMessage;
class nsIDOMMozSmsMessage;

namespace mozilla {
namespace dom {

class File;
struct MmsAttachment;
struct MmsAttachmentAtoms;
struct MmsParametersAtoms;
struct MmsSendParametersAtoms;
struct MobileMessageFilterAtoms;
class MobileMessageManager;
struct MobileMessageManagerAtoms;
struct NativePropertyHooks;
class OwningLongOrMozSmsMessageOrMozMmsMessage;
class ProtoAndIfaceCache;
struct SmsSegmentInfoAtoms;
struct SmsSendParametersAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

MOZ_BEGIN_ENUM_CLASS(MobileMessageFilterDelivery, uint32_t)
  Sent,
  Received,
  EndGuard_
MOZ_END_ENUM_CLASS(MobileMessageFilterDelivery)

namespace MobileMessageFilterDeliveryValues {
extern const EnumEntry strings[3];
} // namespace MobileMessageFilterDeliveryValues


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningLongOrMozSmsMessageOrMozMmsMessage& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningLongOrMozSmsMessageOrMozMmsMessage& aUnion);


class LongOrMozSmsMessageOrMozMmsMessage
{
  friend class LongOrMozSmsMessageOrMozMmsMessageArgument;
  enum Type
  {
    eUninitialized,
    eLong,
    eMozSmsMessage,
    eMozMmsMessage
  };

  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<nsIDOMMozSmsMessage* > mMozSmsMessage;
    UnionMember<nsIDOMMozMmsMessage* > mMozMmsMessage;

  };

  Type mType;
  Value mValue;

  LongOrMozSmsMessageOrMozMmsMessage(const LongOrMozSmsMessageOrMozMmsMessage&) MOZ_DELETE;
  void operator=(const LongOrMozSmsMessageOrMozMmsMessage) MOZ_DELETE;
public:
  explicit inline LongOrMozSmsMessageOrMozMmsMessage()
    : mType(eUninitialized)
  {
  }

  inline ~LongOrMozSmsMessageOrMozMmsMessage()
  {
    Uninit();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline nsIDOMMozSmsMessage*&
  RawSetAsMozSmsMessage()
  {
    if (mType == eMozSmsMessage) {
      return mValue.mMozSmsMessage.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMozSmsMessage;
    return mValue.mMozSmsMessage.SetValue();
  }

  inline nsIDOMMozSmsMessage*&
  SetAsMozSmsMessage()
  {
    if (mType == eMozSmsMessage) {
      return mValue.mMozSmsMessage.Value();
    }
    Uninit();
    mType = eMozSmsMessage;
    return mValue.mMozSmsMessage.SetValue();
  }

  inline bool
  IsMozSmsMessage() const
  {
    return mType == eMozSmsMessage;
  }

  inline nsIDOMMozSmsMessage*&
  GetAsMozSmsMessage()
  {
    MOZ_ASSERT(IsMozSmsMessage(), "Wrong type!");
    return mValue.mMozSmsMessage.Value();
  }

  inline nsIDOMMozSmsMessage*
  GetAsMozSmsMessage() const
  {
    MOZ_ASSERT(IsMozSmsMessage(), "Wrong type!");
    return mValue.mMozSmsMessage.Value();
  }

  inline nsIDOMMozMmsMessage*&
  RawSetAsMozMmsMessage()
  {
    if (mType == eMozMmsMessage) {
      return mValue.mMozMmsMessage.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMozMmsMessage;
    return mValue.mMozMmsMessage.SetValue();
  }

  inline nsIDOMMozMmsMessage*&
  SetAsMozMmsMessage()
  {
    if (mType == eMozMmsMessage) {
      return mValue.mMozMmsMessage.Value();
    }
    Uninit();
    mType = eMozMmsMessage;
    return mValue.mMozMmsMessage.SetValue();
  }

  inline bool
  IsMozMmsMessage() const
  {
    return mType == eMozMmsMessage;
  }

  inline nsIDOMMozMmsMessage*&
  GetAsMozMmsMessage()
  {
    MOZ_ASSERT(IsMozMmsMessage(), "Wrong type!");
    return mValue.mMozMmsMessage.Value();
  }

  inline nsIDOMMozMmsMessage*
  GetAsMozMmsMessage() const
  {
    MOZ_ASSERT(IsMozMmsMessage(), "Wrong type!");
    return mValue.mMozMmsMessage.Value();
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyMozSmsMessage()
  {
    MOZ_ASSERT(IsMozSmsMessage(), "Wrong type!");
    mValue.mMozSmsMessage.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyMozMmsMessage()
  {
    MOZ_ASSERT(IsMozMmsMessage(), "Wrong type!");
    mValue.mMozMmsMessage.Destroy();
    mType = eUninitialized;
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eMozSmsMessage: {
        DestroyMozSmsMessage();
        break;
      }
      case eMozMmsMessage: {
        DestroyMozMmsMessage();
        break;
      }
    }
  }
};


class OwningLongOrMozSmsMessageOrMozMmsMessage : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningLongOrMozSmsMessageOrMozMmsMessage& aUnion);
  enum Type
  {
    eUninitialized,
    eLong,
    eMozSmsMessage,
    eMozMmsMessage
  };

  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<nsRefPtr<nsIDOMMozSmsMessage> > mMozSmsMessage;
    UnionMember<nsRefPtr<nsIDOMMozMmsMessage> > mMozMmsMessage;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningLongOrMozSmsMessageOrMozMmsMessage()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningLongOrMozSmsMessageOrMozMmsMessage(const OwningLongOrMozSmsMessageOrMozMmsMessage& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningLongOrMozSmsMessageOrMozMmsMessage()
  {
    Uninit();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  nsRefPtr<nsIDOMMozSmsMessage>&
  RawSetAsMozSmsMessage();

  nsRefPtr<nsIDOMMozSmsMessage>&
  SetAsMozSmsMessage();

  bool
  TrySetToMozSmsMessage(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMozSmsMessage() const
  {
    return mType == eMozSmsMessage;
  }

  inline nsRefPtr<nsIDOMMozSmsMessage>&
  GetAsMozSmsMessage()
  {
    MOZ_ASSERT(IsMozSmsMessage(), "Wrong type!");
    return mValue.mMozSmsMessage.Value();
  }

  inline nsRefPtr<nsIDOMMozSmsMessage> const &
  GetAsMozSmsMessage() const
  {
    MOZ_ASSERT(IsMozSmsMessage(), "Wrong type!");
    return mValue.mMozSmsMessage.Value();
  }

  nsRefPtr<nsIDOMMozMmsMessage>&
  RawSetAsMozMmsMessage();

  nsRefPtr<nsIDOMMozMmsMessage>&
  SetAsMozMmsMessage();

  bool
  TrySetToMozMmsMessage(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMozMmsMessage() const
  {
    return mType == eMozMmsMessage;
  }

  inline nsRefPtr<nsIDOMMozMmsMessage>&
  GetAsMozMmsMessage()
  {
    MOZ_ASSERT(IsMozMmsMessage(), "Wrong type!");
    return mValue.mMozMmsMessage.Value();
  }

  inline nsRefPtr<nsIDOMMozMmsMessage> const &
  GetAsMozMmsMessage() const
  {
    MOZ_ASSERT(IsMozMmsMessage(), "Wrong type!");
    return mValue.mMozMmsMessage.Value();
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningLongOrMozSmsMessageOrMozMmsMessage& aOther);

private:
  void
  DestroyLong();

  void
  DestroyMozSmsMessage();

  void
  DestroyMozMmsMessage();

  void
  Uninit();
};


struct MmsAttachment : public DictionaryBase
{
  nsRefPtr<mozilla::dom::File> mContent;
  nsString mId;
  nsString mLocation;

  MmsAttachment();

  explicit inline MmsAttachment(const MmsAttachment& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline MmsAttachment(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, MmsAttachmentAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MmsAttachment& aOther);
};

namespace binding_detail {
struct FastMmsAttachment : public MmsAttachment
{
  inline FastMmsAttachment()
    : MmsAttachment(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MmsSendParameters : public DictionaryBase
{
  Optional<uint32_t> mServiceId;

  MmsSendParameters();

  explicit inline MmsSendParameters(const MmsSendParameters& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline MmsSendParameters(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, MmsSendParametersAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MmsSendParameters& aOther);
};

namespace binding_detail {
struct FastMmsSendParameters : public MmsSendParameters
{
  inline FastMmsSendParameters()
    : MmsSendParameters(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MobileMessageFilter : public DictionaryBase
{
  Nullable<MobileMessageFilterDelivery> mDelivery;
  Nullable<uint64_t> mEndDate;
  Nullable<Sequence<nsString>> mNumbers;
  Nullable<bool> mRead;
  Nullable<uint64_t> mStartDate;
  Nullable<uint64_t> mThreadId;

  MobileMessageFilter();

  explicit inline MobileMessageFilter(const MobileMessageFilter& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline MobileMessageFilter(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, MobileMessageFilterAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MobileMessageFilter& aOther);
};

namespace binding_detail {
struct FastMobileMessageFilter : public MobileMessageFilter
{
  inline FastMobileMessageFilter()
    : MobileMessageFilter(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SmsSegmentInfo : public DictionaryBase
{
  int32_t mCharsAvailableInLastSegment;
  int32_t mCharsPerSegment;
  int32_t mSegments;

  SmsSegmentInfo();

  explicit inline SmsSegmentInfo(const SmsSegmentInfo& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline SmsSegmentInfo(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, SmsSegmentInfoAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const SmsSegmentInfo& aOther);
};

namespace binding_detail {
struct FastSmsSegmentInfo : public SmsSegmentInfo
{
  inline FastSmsSegmentInfo()
    : SmsSegmentInfo(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SmsSendParameters : public DictionaryBase
{
  Optional<uint32_t> mServiceId;

  SmsSendParameters();

  explicit inline SmsSendParameters(const SmsSendParameters& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline SmsSendParameters(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, SmsSendParametersAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const SmsSendParameters& aOther);
};

namespace binding_detail {
struct FastSmsSendParameters : public SmsSendParameters
{
  inline FastSmsSendParameters()
    : SmsSendParameters(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MmsParameters : public DictionaryBase
{
  Optional<Sequence<MmsAttachment>> mAttachments;
  Optional<Sequence<nsString>> mReceivers;
  nsString mSmil;
  nsString mSubject;

  MmsParameters();

  explicit inline MmsParameters(const MmsParameters& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline MmsParameters(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, MmsParametersAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MmsParameters& aOther);
};

namespace binding_detail {
struct FastMmsParameters : public MmsParameters
{
  inline FastMmsParameters()
    : MmsParameters(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MozMobileMessageManagerBinding {

  typedef mozilla::dom::MobileMessageManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::MobileMessageManager* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozMobileMessageManagerBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MozMobileMessageManagerBinding_h
