/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RequestSyncSchedulerBinding_h
#define mozilla_dom_RequestSyncSchedulerBinding_h

#include "RequestSyncSchedulerBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;
class RequestSyncScheduler;
struct RequestSyncSchedulerAtoms;
struct RequestTaskFullAtoms;
struct RequestTaskParams;
struct RequestTaskParamsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct RequestTaskParams : public DictionaryBase
{
  JS::Value mData;
  int32_t mMinInterval;
  bool mOneShot;
  nsString mWakeUpPage;
  bool mWifiOnly;

  RequestTaskParams();

protected:
  explicit inline RequestTaskParams(int )
    : mData(JS::UndefinedValue())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RequestTaskParams(const RequestTaskParams&) = delete;
  void operator=(const RequestTaskParams) = delete;

  static bool
  InitIds(JSContext* cx, RequestTaskParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastRequestTaskParams : public RequestTaskParams
{
  inline FastRequestTaskParams()
    : RequestTaskParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RequestTaskFull : public RequestTaskParams
{
  Optional<uint64_t> mLastSync;
  nsString mTask;

  RequestTaskFull();

protected:
  explicit inline RequestTaskFull(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RequestTaskFull(const RequestTaskFull&) = delete;
  void operator=(const RequestTaskFull) = delete;

  static bool
  InitIds(JSContext* cx, RequestTaskFullAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastRequestTaskFull : public RequestTaskFull
{
  inline FastRequestTaskFull()
    : RequestTaskFull(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace RequestSyncSchedulerBinding {

  typedef mozilla::dom::RequestSyncScheduler NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::RequestSyncScheduler* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace RequestSyncSchedulerBinding



class RequestSyncSchedulerJSImpl : public CallbackInterface
{
public:
  explicit inline RequestSyncSchedulerJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Register(const nsAString& task, const RequestTaskParams& params, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Unregister(const nsAString& task, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Registrations(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Registration(const nsAString& task, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const RequestSyncSchedulerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, RequestSyncSchedulerAtoms* atomsCache);
};


class RequestSyncScheduler MOZ_FINAL : public nsSupportsWeakReference,
                                       public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(RequestSyncScheduler)

private:
  nsRefPtr<RequestSyncSchedulerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  RequestSyncScheduler(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~RequestSyncScheduler();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Register(const nsAString& task, const RequestTaskParams& params, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Unregister(const nsAString& task, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Registrations(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Registration(const nsAString& task, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RequestSyncSchedulerBinding_h
