/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_DownloadsBinding_h
#define mozilla_dom_DownloadsBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Date.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class DOMDownload;
struct DOMDownloadAtoms;
class DOMDownloadManager;
struct DOMDownloadManagerAtoms;
class DOMError;
class EventHandlerNonNull;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class DownloadState : uint32_t {
  Downloading,
  Stopped,
  Succeeded,
  Finalized,
  EndGuard_
};

namespace DownloadStateValues {
extern const EnumEntry strings[5];
} // namespace DownloadStateValues


namespace DOMDownloadBinding {

  typedef mozilla::dom::DOMDownload NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMDownload* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace DOMDownloadBinding



namespace DOMDownloadManagerBinding {

  typedef mozilla::dom::DOMDownloadManager NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMDownloadManager* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace DOMDownloadManagerBinding



class DOMDownloadJSImpl : public CallbackInterface
{
public:
  explicit inline DOMDownloadJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Pause(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Resume(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DOMDownloadJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  int64_t GetTotalBytes(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int64_t GetCurrentBytes(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetUrl(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetPath(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStorageName(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStoragePath(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  DownloadState GetState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetContentType(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Date GetStartTime(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMError> GetError(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DOMDownloadAtoms* atomsCache);
};


class DOMDownload MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(DOMDownload, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<DOMDownloadJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DOMDownload(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~DOMDownload();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  int64_t GetTotalBytes(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  int64_t GetCurrentBytes(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetUrl(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetPath(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetStorageName(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetStoragePath(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  DownloadState GetState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetContentType(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  Date GetStartTime(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMError> GetError(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Pause(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Resume(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class DOMDownloadManagerJSImpl : public CallbackInterface
{
public:
  explicit inline DOMDownloadManagerJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> GetDownloads(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Remove(DOMDownload& download, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> ClearAllDone(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DOMDownloadManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<EventHandlerNonNull> GetOndownloadstart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndownloadstart(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DOMDownloadManagerAtoms* atomsCache);
};


class DOMDownloadManager MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(DOMDownloadManager, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<DOMDownloadManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DOMDownloadManager(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~DOMDownloadManager();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetDownloads(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Remove(DOMDownload& download, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> ClearAllDone(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadstart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndownloadstart(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DownloadsBinding_h
