/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_IdentityBinding_h
#define mozilla_dom_IdentityBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

struct IdentityGetOptions;
struct IdentityGetOptionsAtoms;
class IdentityManager;
struct IdentityManagerAtoms;
class IdentityOnCancelCallback;
class IdentityOnErrorCallback;
class IdentityOnLoginCallback;
class IdentityOnLogoutCallback;
class IdentityOnReadyCallback;
struct IdentityRequestOptions;
struct IdentityRequestOptionsAtoms;
struct IdentityWatchOptions;
struct IdentityWatchOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct IdentityGetOptions : public DictionaryBase
{
  Optional<nsString> mPrivacyPolicy;
  Optional<nsString> mPrivacyURL;
  Optional<nsString> mSiteLogo;
  Optional<nsString> mSiteName;
  Optional<nsString> mTermsOfService;
  Optional<nsString> mTosURL;

  IdentityGetOptions();

  explicit inline IdentityGetOptions(const IdentityGetOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline IdentityGetOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, IdentityGetOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const IdentityGetOptions& aOther);
};

namespace binding_detail {
struct FastIdentityGetOptions : public IdentityGetOptions
{
  inline FastIdentityGetOptions()
    : IdentityGetOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct IdentityRequestOptions : public DictionaryBase
{
  Optional<nsString> mBackgroundColor;
  Optional<OwningNonNull<IdentityOnCancelCallback>> mOncancel;
  Optional<nsString> mOrigin;
  Optional<nsString> mPrivacyPolicy;
  Optional<int32_t> mRefreshAuthentication;
  Optional<nsString> mReturnTo;
  Optional<nsString> mSiteLogo;
  Optional<nsString> mSiteName;
  Optional<nsString> mTermsOfService;

  IdentityRequestOptions();

protected:
  explicit inline IdentityRequestOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  IdentityRequestOptions(const IdentityRequestOptions&) = delete;
  void operator=(const IdentityRequestOptions) = delete;

  static bool
  InitIds(JSContext* cx, IdentityRequestOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastIdentityRequestOptions : public IdentityRequestOptions
{
  inline FastIdentityRequestOptions()
    : IdentityRequestOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct IdentityWatchOptions : public DictionaryBase
{
  Optional<nsString> mAudience;
  Optional<nsString> mLoggedInUser;
  Optional<OwningNonNull<IdentityOnErrorCallback>> mOnerror;
  Optional<OwningNonNull<IdentityOnLoginCallback>> mOnlogin;
  Optional<OwningNonNull<IdentityOnLogoutCallback>> mOnlogout;
  Optional<OwningNonNull<IdentityOnReadyCallback>> mOnready;
  Optional<nsString> mWantIssuer;

  IdentityWatchOptions();

protected:
  explicit inline IdentityWatchOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  IdentityWatchOptions(const IdentityWatchOptions&) = delete;
  void operator=(const IdentityWatchOptions) = delete;

  static bool
  InitIds(JSContext* cx, IdentityWatchOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastIdentityWatchOptions : public IdentityWatchOptions
{
  inline FastIdentityWatchOptions()
    : IdentityWatchOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class IdentityOnReadyCallback : public CallbackFunction
{
public:
  explicit inline IdentityOnReadyCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdentityOnReadyCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, aRv);
  }

  inline bool
  operator==(const IdentityOnReadyCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


class IdentityOnLoginCallback : public CallbackFunction
{
public:
  explicit inline IdentityOnLoginCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdentityOnLoginCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, const nsAString& identityAssertion, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, identityAssertion, aRv);
  }

  inline void
  Call(const nsAString& identityAssertion, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, identityAssertion, aRv);
  }

  inline bool
  operator==(const IdentityOnLoginCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const nsAString& identityAssertion, ErrorResult& aRv);
};


class IdentityOnLogoutCallback : public CallbackFunction
{
public:
  explicit inline IdentityOnLogoutCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdentityOnLogoutCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, aRv);
  }

  inline bool
  operator==(const IdentityOnLogoutCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


class IdentityOnCancelCallback : public CallbackFunction
{
public:
  explicit inline IdentityOnCancelCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdentityOnCancelCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, const nsAString& error, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, error, aRv);
  }

  inline void
  Call(const nsAString& error, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, error, aRv);
  }

  inline bool
  operator==(const IdentityOnCancelCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const nsAString& error, ErrorResult& aRv);
};


class IdentityOnErrorCallback : public CallbackFunction
{
public:
  explicit inline IdentityOnErrorCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdentityOnErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, const nsAString& error, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, error, aRv);
  }

  inline void
  Call(const nsAString& error, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(this, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, error, aRv);
  }

  inline bool
  operator==(const IdentityOnErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const nsAString& error, ErrorResult& aRv);
};


namespace IdentityManagerBinding {

  typedef mozilla::dom::IdentityManager NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::IdentityManager* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace IdentityManagerBinding



class IdentityManagerJSImpl : public CallbackInterface
{
public:
  explicit inline IdentityManagerJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void Watch(const IdentityWatchOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Request(const IdentityRequestOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Logout(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Get(IdentityOnLoginCallback& callback, const IdentityGetOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetVerifiedEmail(IdentityOnLoginCallback& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const IdentityManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, IdentityManagerAtoms* atomsCache);
};


class IdentityManager MOZ_FINAL : public nsSupportsWeakReference,
                                  public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(IdentityManager)

private:
  nsRefPtr<IdentityManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  IdentityManager(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~IdentityManager();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  void Watch(const IdentityWatchOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Request(const IdentityRequestOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Logout(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Get(IdentityOnLoginCallback& callback, const IdentityGetOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetVerifiedEmail(IdentityOnLoginCallback& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_IdentityBinding_h
