/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_InputMethodBinding_h
#define mozilla_dom_InputMethodBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

struct CompositionClauseParameters;
struct CompositionClauseParametersAtoms;
class EventHandlerNonNull;
class MozInputContext;
struct MozInputContextAtoms;
class MozInputMethod;
struct MozInputMethodAtoms;
class MozInputMethodManager;
struct MozInputMethodManagerAtoms;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CompositionClauseSelectionType : uint32_t {
  Raw_input,
  Selected_raw_text,
  Converted_text,
  Selected_converted_text,
  EndGuard_
};

namespace CompositionClauseSelectionTypeValues {
extern const EnumEntry strings[5];
} // namespace CompositionClauseSelectionTypeValues


struct CompositionClauseParameters : public DictionaryBase
{
  Optional<int32_t> mLength;
  nsString mSelectionType;

  CompositionClauseParameters();

  explicit inline CompositionClauseParameters(const CompositionClauseParameters& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline CompositionClauseParameters(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, CompositionClauseParametersAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const CompositionClauseParameters& aOther);
};

namespace binding_detail {
struct FastCompositionClauseParameters : public CompositionClauseParameters
{
  inline FastCompositionClauseParameters()
    : CompositionClauseParameters(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MozInputContextBinding {

  typedef mozilla::dom::MozInputContext NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputContext* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputContextBinding



namespace MozInputMethodBinding {

  typedef mozilla::dom::MozInputMethod NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputMethod* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputMethodBinding



namespace MozInputMethodManagerBinding {

  typedef mozilla::dom::MozInputMethodManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputMethodManager* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputMethodManagerBinding



class MozInputContextJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputContextJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> GetText(const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetSelectionRange(int32_t start, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> ReplaceSurroundingText(const nsAString& text, const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> DeleteSurroundingText(int32_t offset, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SendKey(int32_t keyCode, int32_t charCode, int32_t modifiers, const Optional<bool>& repeat, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetComposition(const nsAString& text, const Optional<int32_t>& cursor, const Optional<Sequence<CompositionClauseParameters>>& clauses, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> EndComposition(const Optional<nsAString>& text, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputContextJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetType(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInputType(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInputMode(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLang(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionStart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionEnd(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetTextBeforeCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetTextAfterCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnselectionchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsurroundingtextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnselectionchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnsurroundingtextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputContextAtoms* atomsCache);
};


class MozInputContext MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputContext, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<MozInputContextJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputContext(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputContext();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  void GetType(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInputType(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInputMode(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetLang(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetText(const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionStart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  int32_t GetSelectionEnd(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetTextBeforeCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetTextAfterCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetSelectionRange(int32_t start, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnselectionchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnselectionchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> ReplaceSurroundingText(const nsAString& text, const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> DeleteSurroundingText(int32_t offset, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsurroundingtextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnsurroundingtextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SendKey(int32_t keyCode, int32_t charCode, int32_t modifiers, const Optional<bool>& repeat, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetComposition(const nsAString& text, const Optional<int32_t>& cursor, const Optional<Sequence<CompositionClauseParameters>>& clauses, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> EndComposition(const Optional<nsAString>& text, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputMethodJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputMethodJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void SetActive(bool isActive, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> AddInput(const nsAString& inputId, JS::Handle<JSObject*> inputManifest, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> RemoveInput(const nsAString& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetValue(const nsAString& value, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOption(int32_t index, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOptions(const Sequence<int32_t>& indexes, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveFocus(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputMethodJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<MozInputMethodManager> GetMgmt(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOninputcontextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<MozInputContext> GetInputcontext(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOninputcontextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodAtoms* atomsCache);
};


class MozInputMethod MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputMethod, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<MozInputMethodJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputMethod(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputMethod();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<MozInputMethodManager> GetMgmt(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  already_AddRefed<EventHandlerNonNull> GetOninputcontextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOninputcontextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<MozInputContext> GetInputcontext(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetActive(bool isActive, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddInput(const nsAString& inputId, JS::Handle<JSObject*> inputManifest, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> RemoveInput(const nsAString& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetValue(const nsAString& value, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOption(int32_t index, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOptions(const Sequence<int32_t>& indexes, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveFocus(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputMethodManagerJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputMethodManagerJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void ShowAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool SupportsSwitching(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Hide(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputMethodManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodManagerAtoms* atomsCache);
};


class MozInputMethodManager MOZ_FINAL : public nsSupportsWeakReference,
                                        public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozInputMethodManager)

private:
  nsRefPtr<MozInputMethodManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputMethodManager(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputMethodManager();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  void ShowAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool SupportsSwitching(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Hide(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_InputMethodBinding_h
