/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_SubtleCryptoBinding_h
#define mozilla_dom_SubtleCryptoBinding_h

#include "SubtleCryptoBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CryptoKey.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

struct AesCbcParamsAtoms;
struct AesCtrParamsAtoms;
struct AesDerivedKeyParamsAtoms;
struct AesGcmParamsAtoms;
struct AesKeyGenParamsAtoms;
struct AlgorithmAtoms;
class ArrayBufferViewOrArrayBuffer;
class CryptoKey;
struct CryptoKeyAtoms;
struct CryptoKeyPairAtoms;
struct DhImportKeyParamsAtoms;
struct DhKeyDeriveParamsAtoms;
struct DhKeyGenParamsAtoms;
struct EcKeyGenParamsAtoms;
struct EcdhKeyDeriveParamsAtoms;
struct EcdsaParamsAtoms;
struct HmacDerivedKeyParamsAtoms;
struct HmacImportParamsAtoms;
struct HmacKeyGenParamsAtoms;
struct JsonWebKeyAtoms;
struct NativePropertyHooks;
class ObjectOrString;
class OwningArrayBufferViewOrArrayBuffer;
class OwningObjectOrString;
struct Pbkdf2ParamsAtoms;
class ProtoAndIfaceCache;
struct RsaHashedImportParamsAtoms;
struct RsaHashedKeyGenParamsAtoms;
struct RsaOaepParamsAtoms;
struct RsaOtherPrimesInfo;
struct RsaOtherPrimesInfoAtoms;
class SubtleCrypto;
struct SubtleCryptoAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct Algorithm : public DictionaryBase
{
  nsString mName;

  Algorithm();

  explicit inline Algorithm(const Algorithm& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline Algorithm(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, AlgorithmAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const Algorithm& aOther);
};

namespace binding_detail {
struct FastAlgorithm : public Algorithm
{
  inline FastAlgorithm()
    : Algorithm(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CryptoKeyPair : public DictionaryBase
{
  OwningNonNull<mozilla::dom::CryptoKey> mPrivateKey;
  OwningNonNull<mozilla::dom::CryptoKey> mPublicKey;

  CryptoKeyPair();

  explicit inline CryptoKeyPair(const CryptoKeyPair& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline CryptoKeyPair(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, CryptoKeyPairAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const CryptoKeyPair& aOther);
};

namespace binding_detail {
struct FastCryptoKeyPair : public CryptoKeyPair
{
  inline FastCryptoKeyPair()
    : CryptoKeyPair(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ObjectOrString
{
  friend class ObjectOrStringArgument;
  enum Type
  {
    eUninitialized,
    eObject,
    eString
  };

  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<binding_detail::FakeString > mString;

  };

  Type mType;
  Value mValue;

  ObjectOrString(const ObjectOrString&) = delete;
  void operator=(const ObjectOrString) = delete;
public:
  explicit inline ObjectOrString()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrString()
  {
    Uninit();
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }
};


class OwningObjectOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningObjectOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eObject,
    eString
  };

  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

  OwningObjectOrString(const OwningObjectOrString&) = delete;
  void operator=(const OwningObjectOrString) = delete;
public:
  explicit inline OwningObjectOrString()
    : mType(eUninitialized)
  {
  }

  inline ~OwningObjectOrString()
  {
    Uninit();
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  SetToObject(JSContext* cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      ThrowErrorMessage(cx, MSG_PERMISSION_DENIED_TO_PASS_ARG, "%s");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

private:
  void
  DestroyObject();

  void
  DestroyString();

  void
  Uninit();
};


struct RsaOtherPrimesInfo : public DictionaryBase
{
  nsString mD;
  nsString mR;
  nsString mT;

  RsaOtherPrimesInfo();

  explicit inline RsaOtherPrimesInfo(const RsaOtherPrimesInfo& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline RsaOtherPrimesInfo(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, RsaOtherPrimesInfoAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RsaOtherPrimesInfo& aOther);
};

namespace binding_detail {
struct FastRsaOtherPrimesInfo : public RsaOtherPrimesInfo
{
  inline FastRsaOtherPrimesInfo()
    : RsaOtherPrimesInfo(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AesCbcParams : public Algorithm
{
  OwningArrayBufferViewOrArrayBuffer mIv;

  AesCbcParams();

protected:
  explicit inline AesCbcParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  AesCbcParams(const AesCbcParams&) = delete;
  void operator=(const AesCbcParams) = delete;

  static bool
  InitIds(JSContext* cx, AesCbcParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastAesCbcParams : public AesCbcParams
{
  inline FastAesCbcParams()
    : AesCbcParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AesCtrParams : public Algorithm
{
  OwningArrayBufferViewOrArrayBuffer mCounter;
  uint8_t mLength;

  AesCtrParams();

protected:
  explicit inline AesCtrParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  AesCtrParams(const AesCtrParams&) = delete;
  void operator=(const AesCtrParams) = delete;

  static bool
  InitIds(JSContext* cx, AesCtrParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastAesCtrParams : public AesCtrParams
{
  inline FastAesCtrParams()
    : AesCtrParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AesDerivedKeyParams : public Algorithm
{
  uint32_t mLength;

  AesDerivedKeyParams();

  explicit inline AesDerivedKeyParams(const AesDerivedKeyParams& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline AesDerivedKeyParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, AesDerivedKeyParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const AesDerivedKeyParams& aOther);
};

namespace binding_detail {
struct FastAesDerivedKeyParams : public AesDerivedKeyParams
{
  inline FastAesDerivedKeyParams()
    : AesDerivedKeyParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AesGcmParams : public Algorithm
{
  Optional<OwningArrayBufferViewOrArrayBuffer> mAdditionalData;
  OwningArrayBufferViewOrArrayBuffer mIv;
  Optional<uint8_t> mTagLength;

  AesGcmParams();

protected:
  explicit inline AesGcmParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  AesGcmParams(const AesGcmParams&) = delete;
  void operator=(const AesGcmParams) = delete;

  static bool
  InitIds(JSContext* cx, AesGcmParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastAesGcmParams : public AesGcmParams
{
  inline FastAesGcmParams()
    : AesGcmParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AesKeyGenParams : public Algorithm
{
  uint16_t mLength;

  AesKeyGenParams();

  explicit inline AesKeyGenParams(const AesKeyGenParams& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline AesKeyGenParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, AesKeyGenParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const AesKeyGenParams& aOther);
};

namespace binding_detail {
struct FastAesKeyGenParams : public AesKeyGenParams
{
  inline FastAesKeyGenParams()
    : AesKeyGenParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct DhImportKeyParams : public Algorithm
{
  Uint8Array mGenerator;
  Uint8Array mPrime;

  DhImportKeyParams();

protected:
  explicit inline DhImportKeyParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  DhImportKeyParams(const DhImportKeyParams&) = delete;
  void operator=(const DhImportKeyParams) = delete;

  static bool
  InitIds(JSContext* cx, DhImportKeyParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastDhImportKeyParams : public DhImportKeyParams
{
  inline FastDhImportKeyParams()
    : DhImportKeyParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct DhKeyDeriveParams : public Algorithm
{
  OwningNonNull<mozilla::dom::CryptoKey> mPublic;

  DhKeyDeriveParams();

  explicit inline DhKeyDeriveParams(const DhKeyDeriveParams& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline DhKeyDeriveParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, DhKeyDeriveParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const DhKeyDeriveParams& aOther);
};

namespace binding_detail {
struct FastDhKeyDeriveParams : public DhKeyDeriveParams
{
  inline FastDhKeyDeriveParams()
    : DhKeyDeriveParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct DhKeyGenParams : public Algorithm
{
  Uint8Array mGenerator;
  Uint8Array mPrime;

  DhKeyGenParams();

protected:
  explicit inline DhKeyGenParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  DhKeyGenParams(const DhKeyGenParams&) = delete;
  void operator=(const DhKeyGenParams) = delete;

  static bool
  InitIds(JSContext* cx, DhKeyGenParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastDhKeyGenParams : public DhKeyGenParams
{
  inline FastDhKeyGenParams()
    : DhKeyGenParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct EcKeyGenParams : public Algorithm
{
  nsString mNamedCurve;

  EcKeyGenParams();

  explicit inline EcKeyGenParams(const EcKeyGenParams& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline EcKeyGenParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, EcKeyGenParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const EcKeyGenParams& aOther);
};

namespace binding_detail {
struct FastEcKeyGenParams : public EcKeyGenParams
{
  inline FastEcKeyGenParams()
    : EcKeyGenParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct EcdhKeyDeriveParams : public Algorithm
{
  OwningNonNull<mozilla::dom::CryptoKey> mPublic;

  EcdhKeyDeriveParams();

  explicit inline EcdhKeyDeriveParams(const EcdhKeyDeriveParams& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline EcdhKeyDeriveParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, EcdhKeyDeriveParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const EcdhKeyDeriveParams& aOther);
};

namespace binding_detail {
struct FastEcdhKeyDeriveParams : public EcdhKeyDeriveParams
{
  inline FastEcdhKeyDeriveParams()
    : EcdhKeyDeriveParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct EcdsaParams : public Algorithm
{
  OwningObjectOrString mHash;

  EcdsaParams();

protected:
  explicit inline EcdsaParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  EcdsaParams(const EcdsaParams&) = delete;
  void operator=(const EcdsaParams) = delete;

  static bool
  InitIds(JSContext* cx, EcdsaParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastEcdsaParams : public EcdsaParams
{
  inline FastEcdsaParams()
    : EcdsaParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HmacImportParams : public Algorithm
{
  OwningObjectOrString mHash;

  HmacImportParams();

protected:
  explicit inline HmacImportParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  HmacImportParams(const HmacImportParams&) = delete;
  void operator=(const HmacImportParams) = delete;

  static bool
  InitIds(JSContext* cx, HmacImportParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastHmacImportParams : public HmacImportParams
{
  inline FastHmacImportParams()
    : HmacImportParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HmacKeyGenParams : public Algorithm
{
  OwningObjectOrString mHash;
  Optional<uint32_t> mLength;

  HmacKeyGenParams();

protected:
  explicit inline HmacKeyGenParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  HmacKeyGenParams(const HmacKeyGenParams&) = delete;
  void operator=(const HmacKeyGenParams) = delete;

  static bool
  InitIds(JSContext* cx, HmacKeyGenParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastHmacKeyGenParams : public HmacKeyGenParams
{
  inline FastHmacKeyGenParams()
    : HmacKeyGenParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct JsonWebKey : public DictionaryBase
{
  Optional<nsString> mAlg;
  Optional<nsString> mCrv;
  Optional<nsString> mD;
  Optional<nsString> mDp;
  Optional<nsString> mDq;
  Optional<nsString> mE;
  Optional<bool> mExt;
  Optional<nsString> mK;
  Optional<Sequence<nsString>> mKey_ops;
  nsString mKty;
  Optional<nsString> mN;
  Optional<Sequence<RsaOtherPrimesInfo>> mOth;
  Optional<nsString> mP;
  Optional<nsString> mQ;
  Optional<nsString> mQi;
  Optional<nsString> mUse;
  Optional<nsString> mX;
  Optional<nsString> mY;

  JsonWebKey();

  explicit inline JsonWebKey(const JsonWebKey& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline JsonWebKey(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, JsonWebKeyAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const JsonWebKey& aOther);
};

namespace binding_detail {
struct FastJsonWebKey : public JsonWebKey
{
  inline FastJsonWebKey()
    : JsonWebKey(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct Pbkdf2Params : public Algorithm
{
  OwningObjectOrString mHash;
  uint32_t mIterations;
  OwningArrayBufferViewOrArrayBuffer mSalt;

  Pbkdf2Params();

protected:
  explicit inline Pbkdf2Params(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  Pbkdf2Params(const Pbkdf2Params&) = delete;
  void operator=(const Pbkdf2Params) = delete;

  static bool
  InitIds(JSContext* cx, Pbkdf2ParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPbkdf2Params : public Pbkdf2Params
{
  inline FastPbkdf2Params()
    : Pbkdf2Params(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RsaHashedImportParams : public DictionaryBase
{
  OwningObjectOrString mHash;

  RsaHashedImportParams();

protected:
  explicit inline RsaHashedImportParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RsaHashedImportParams(const RsaHashedImportParams&) = delete;
  void operator=(const RsaHashedImportParams) = delete;

  static bool
  InitIds(JSContext* cx, RsaHashedImportParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastRsaHashedImportParams : public RsaHashedImportParams
{
  inline FastRsaHashedImportParams()
    : RsaHashedImportParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RsaHashedKeyGenParams : public Algorithm
{
  OwningObjectOrString mHash;
  uint32_t mModulusLength;
  Uint8Array mPublicExponent;

  RsaHashedKeyGenParams();

protected:
  explicit inline RsaHashedKeyGenParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RsaHashedKeyGenParams(const RsaHashedKeyGenParams&) = delete;
  void operator=(const RsaHashedKeyGenParams) = delete;

  static bool
  InitIds(JSContext* cx, RsaHashedKeyGenParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastRsaHashedKeyGenParams : public RsaHashedKeyGenParams
{
  inline FastRsaHashedKeyGenParams()
    : RsaHashedKeyGenParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RsaOaepParams : public Algorithm
{
  Optional<OwningArrayBufferViewOrArrayBuffer> mLabel;

  RsaOaepParams();

protected:
  explicit inline RsaOaepParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RsaOaepParams(const RsaOaepParams&) = delete;
  void operator=(const RsaOaepParams) = delete;

  static bool
  InitIds(JSContext* cx, RsaOaepParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastRsaOaepParams : public RsaOaepParams
{
  inline FastRsaOaepParams()
    : RsaOaepParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HmacDerivedKeyParams : public HmacImportParams
{
  Optional<uint32_t> mLength;

  HmacDerivedKeyParams();

protected:
  explicit inline HmacDerivedKeyParams(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  HmacDerivedKeyParams(const HmacDerivedKeyParams&) = delete;
  void operator=(const HmacDerivedKeyParams) = delete;

  static bool
  InitIds(JSContext* cx, HmacDerivedKeyParamsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastHmacDerivedKeyParams : public HmacDerivedKeyParams
{
  inline FastHmacDerivedKeyParams()
    : HmacDerivedKeyParams(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace CryptoKeyBinding {

  typedef mozilla::dom::CryptoKey NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::CryptoKey* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace CryptoKeyBinding



namespace SubtleCryptoBinding {

  typedef mozilla::dom::SubtleCrypto NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, mozilla::dom::SubtleCrypto* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    return Wrap(aCx, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace SubtleCryptoBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SubtleCryptoBinding_h
