/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_AppsBinding_h
#define mozilla_dom_AppsBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class DOMApplication;
struct DOMApplicationAtoms;
class DOMApplicationsManager;
struct DOMApplicationsManagerAtoms;
class DOMApplicationsRegistry;
struct DOMApplicationsRegistryAtoms;
class DOMError;
class DOMRequest;
class EventHandlerNonNull;
class File;
struct InstallParameters;
struct InstallParametersAtoms;
struct LanguageDescAtoms;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class LocaleResourceType : uint32_t {
  Binary,
  Json,
  Text,
  EndGuard_
};

namespace LocaleResourceTypeValues {
extern const EnumEntry strings[4];
} // namespace LocaleResourceTypeValues


struct InstallParameters : public DictionaryBase
{
  Sequence<nsString> mCategories;
  Sequence<nsString> mReceipts;

  InstallParameters();

  explicit inline InstallParameters(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline InstallParameters(const InstallParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const InstallParameters& aOther);

private:
  static bool
  InitIds(JSContext* cx, InstallParametersAtoms* atomsCache);
};

namespace binding_detail {
struct FastInstallParameters : public InstallParameters
{
  inline FastInstallParameters()
    : InstallParameters(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct LanguageDesc : public DictionaryBase
{
  Optional<nsString> mName;
  Optional<nsString> mTarget;
  Optional<nsString> mVersion;

  LanguageDesc();

  explicit inline LanguageDesc(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline LanguageDesc(const LanguageDesc& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const LanguageDesc& aOther);

private:
  static bool
  InitIds(JSContext* cx, LanguageDescAtoms* atomsCache);
};

namespace binding_detail {
struct FastLanguageDesc : public LanguageDesc
{
  inline FastLanguageDesc()
    : LanguageDesc(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace DOMApplicationBinding {

  typedef mozilla::dom::DOMApplication NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMApplication* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedReceiptsValue(mozilla::dom::DOMApplication* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace DOMApplicationBinding



namespace DOMApplicationsManagerBinding {

  typedef mozilla::dom::DOMApplicationsManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMApplicationsManager* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace DOMApplicationsManagerBinding



namespace DOMApplicationsRegistryBinding {

  typedef mozilla::dom::DOMApplicationsRegistry NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMApplicationsRegistry* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace DOMApplicationsRegistryBinding



class DOMApplicationJSImpl : public CallbackInterface
{
public:
  explicit inline DOMApplicationJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void Download(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CancelDownload(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> Launch(const Optional<nsAString>& url, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> ClearBrowserData(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> CheckForUpdate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Connect(const nsAString& keyword, JS::Handle<JS::Value> rules, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetConnections(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> AddReceipt(const Optional<nsAString>& receipt, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> RemoveReceipt(const Optional<nsAString>& receipt, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> ReplaceReceipt(const Optional<nsAString>& oldReceipt, const Optional<nsAString>& newReceipt, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Export(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DOMApplicationJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetManifest(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetUpdateManifest(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetManifestURL(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetOrigin(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInstallOrigin(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  uint64_t GetInstallTime(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetRemovable(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetEnabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetReceipts(nsTArray<nsString>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  double GetProgress(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInstallState(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  uint64_t GetLastUpdateCheck(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  uint64_t GetUpdateTime(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetDownloadAvailable(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetDownloading(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetReadyToApplyDownload(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetDownloadSize(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMError> GetDownloadError(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnprogress(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadsuccess(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloaderror(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadavailable(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadapplied(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnprogress(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndownloadsuccess(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndownloaderror(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndownloadavailable(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndownloadapplied(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DOMApplicationAtoms* atomsCache);
};


class DOMApplication MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(DOMApplication, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<DOMApplicationJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DOMApplication(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~DOMApplication();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  void GetManifest(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetUpdateManifest(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetManifestURL(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetOrigin(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInstallOrigin(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  uint64_t GetInstallTime(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetRemovable(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetEnabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetReceipts(nsTArray<nsString>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  double GetProgress(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInstallState(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  uint64_t GetLastUpdateCheck(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  uint64_t GetUpdateTime(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetDownloadAvailable(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetDownloading(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetReadyToApplyDownload(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  int32_t GetDownloadSize(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMError> GetDownloadError(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  already_AddRefed<EventHandlerNonNull> GetOnprogress(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnprogress(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadsuccess(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndownloadsuccess(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloaderror(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndownloaderror(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadavailable(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndownloadavailable(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndownloadapplied(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndownloadapplied(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Download(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void CancelDownload(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> Launch(const Optional<nsAString>& url, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> ClearBrowserData(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> CheckForUpdate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Connect(const nsAString& keyword, JS::Handle<JS::Value> rules, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetConnections(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> AddReceipt(const Optional<nsAString>& receipt, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> RemoveReceipt(const Optional<nsAString>& receipt, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> ReplaceReceipt(const Optional<nsAString>& oldReceipt, const Optional<nsAString>& newReceipt, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Export(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class DOMApplicationsManagerJSImpl : public CallbackInterface
{
public:
  explicit inline DOMApplicationsManagerJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<DOMRequest> GetAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetNotInstalled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void ApplyDownload(DOMApplication& app, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> Uninstall(DOMApplication& app, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Import(File& blob, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> ExtractManifest(File& blob, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetEnabled(DOMApplication& app, bool state, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetIcon(DOMApplication& app, const nsAString& iconID, const Optional<nsAString>& entryPoint, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DOMApplicationsManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<EventHandlerNonNull> GetOninstall(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnuninstall(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnenabledstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOninstall(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnuninstall(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnenabledstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DOMApplicationsManagerAtoms* atomsCache);
};


class DOMApplicationsManager MOZ_FINAL : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(DOMApplicationsManager, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<DOMApplicationsManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DOMApplicationsManager(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~DOMApplicationsManager();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetNotInstalled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void ApplyDownload(DOMApplication& app, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> Uninstall(DOMApplication& app, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Import(File& blob, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> ExtractManifest(File& blob, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetEnabled(DOMApplication& app, bool state, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetIcon(DOMApplication& app, const nsAString& iconID, const Optional<nsAString>& entryPoint, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOninstall(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOninstall(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnuninstall(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnuninstall(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnenabledstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnenabledstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class DOMApplicationsRegistryJSImpl : public CallbackInterface
{
public:
  explicit inline DOMApplicationsRegistryJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<DOMRequest> Install(const nsAString& url, const InstallParameters& params, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> InstallPackage(const nsAString& url, const InstallParameters& params, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetSelf(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetInstalled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> CheckInstalled(const nsAString& manifestUrl, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetAdditionalLanguages(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetLocalizationResource(const nsAString& language, const nsAString& version, const nsAString& path, LocaleResourceType dataType, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const DOMApplicationsRegistryJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<DOMApplicationsManager> GetMgmt(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, DOMApplicationsRegistryAtoms* atomsCache);
};


class DOMApplicationsRegistry MOZ_FINAL : public nsSupportsWeakReference,
                                          public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(DOMApplicationsRegistry)

private:
  nsRefPtr<DOMApplicationsRegistryJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  DOMApplicationsRegistry(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~DOMApplicationsRegistry();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMApplicationsManager> GetMgmt(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> Install(const nsAString& url, const InstallParameters& params, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> InstallPackage(const nsAString& url, const InstallParameters& params, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetSelf(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetInstalled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> CheckInstalled(const nsAString& manifestUrl, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetAdditionalLanguages(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetLocalizationResource(const nsAString& language, const nsAString& version, const nsAString& path, LocaleResourceType dataType, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_AppsBinding_h
