/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_ConsoleBinding_h
#define mozilla_dom_ConsoleBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Console;
struct ConsoleAtoms;
struct ConsoleCounterAtoms;
struct ConsoleCounterErrorAtoms;
struct ConsoleEventAtoms;
struct ConsoleProfileEventAtoms;
struct ConsoleStackEntryAtoms;
struct ConsoleTimerEndAtoms;
struct ConsoleTimerErrorAtoms;
struct ConsoleTimerStartAtoms;
struct NativePropertyHooks;
class OwningUnsignedLongOrString;
class ProtoAndIfaceCache;
class UnsignedLongOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct ConsoleCounter : public DictionaryBase
{
  uint32_t mCount;
  nsString mLabel;

  ConsoleCounter();

  explicit inline ConsoleCounter(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConsoleCounter(const ConsoleCounter& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleCounter& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConsoleCounterAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleCounter : public ConsoleCounter
{
  inline FastConsoleCounter()
    : ConsoleCounter(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleCounterError : public DictionaryBase
{
  nsString mError;

  ConsoleCounterError();

  explicit inline ConsoleCounterError(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConsoleCounterError(const ConsoleCounterError& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleCounterError& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConsoleCounterErrorAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleCounterError : public ConsoleCounterError
{
  inline FastConsoleCounterError()
    : ConsoleCounterError(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleProfileEvent : public DictionaryBase
{
  nsString mAction;
  Optional<Sequence<JS::Value>> mArguments;

  ConsoleProfileEvent();

  explicit inline ConsoleProfileEvent(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  ConsoleProfileEvent(const ConsoleProfileEvent&) = delete;
  void operator=(const ConsoleProfileEvent) = delete;

  static bool
  InitIds(JSContext* cx, ConsoleProfileEventAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastConsoleProfileEvent : public ConsoleProfileEvent
{
  inline FastConsoleProfileEvent()
    : ConsoleProfileEvent(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleStackEntry : public DictionaryBase
{
  uint32_t mColumnNumber;
  nsString mFilename;
  nsString mFunctionName;
  uint32_t mLanguage;
  uint32_t mLineNumber;

  ConsoleStackEntry();

  explicit inline ConsoleStackEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConsoleStackEntry(const ConsoleStackEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleStackEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConsoleStackEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleStackEntry : public ConsoleStackEntry
{
  inline FastConsoleStackEntry()
    : ConsoleStackEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerEnd : public DictionaryBase
{
  double mDuration;
  nsString mName;

  ConsoleTimerEnd();

  explicit inline ConsoleTimerEnd(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConsoleTimerEnd(const ConsoleTimerEnd& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleTimerEnd& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerEndAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleTimerEnd : public ConsoleTimerEnd
{
  inline FastConsoleTimerEnd()
    : ConsoleTimerEnd(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerError : public DictionaryBase
{
  nsString mError;

  ConsoleTimerError();

  explicit inline ConsoleTimerError(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConsoleTimerError(const ConsoleTimerError& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleTimerError& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerErrorAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleTimerError : public ConsoleTimerError
{
  inline FastConsoleTimerError()
    : ConsoleTimerError(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerStart : public DictionaryBase
{
  nsString mName;
  double mStarted;

  ConsoleTimerStart();

  explicit inline ConsoleTimerStart(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConsoleTimerStart(const ConsoleTimerStart& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConsoleTimerStart& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerStartAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleTimerStart : public ConsoleTimerStart
{
  inline FastConsoleTimerStart()
    : ConsoleTimerStart(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UnsignedLongOrString
{
  friend class UnsignedLongOrStringArgument;
  enum Type
  {
    eUninitialized,
    eUnsignedLong,
    eString
  };

  union Value
  {
    UnionMember<uint32_t > mUnsignedLong;
    UnionMember<binding_detail::FakeString > mString;

  };

  Type mType;
  Value mValue;

  UnsignedLongOrString(const UnsignedLongOrString&) = delete;
  void operator=(const UnsignedLongOrString) = delete;
public:
  explicit inline UnsignedLongOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnsignedLongOrString()
  {
    Uninit();
  }

  inline uint32_t&
  RawSetAsUnsignedLong()
  {
    if (mType == eUnsignedLong) {
      return mValue.mUnsignedLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLong;
    return mValue.mUnsignedLong.SetValue();
  }

  inline uint32_t&
  SetAsUnsignedLong()
  {
    if (mType == eUnsignedLong) {
      return mValue.mUnsignedLong.Value();
    }
    Uninit();
    mType = eUnsignedLong;
    return mValue.mUnsignedLong.SetValue();
  }

  inline bool
  IsUnsignedLong() const
  {
    return mType == eUnsignedLong;
  }

  inline uint32_t&
  GetAsUnsignedLong()
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline uint32_t
  GetAsUnsignedLong() const
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnsignedLong: {
        DestroyUnsignedLong();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyUnsignedLong()
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    mValue.mUnsignedLong.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnsignedLongOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnsignedLongOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eUnsignedLong,
    eString
  };

  union Value
  {
    UnionMember<uint32_t > mUnsignedLong;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnsignedLongOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnsignedLongOrString(const OwningUnsignedLongOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnsignedLongOrString()
  {
    Uninit();
  }

  uint32_t&
  RawSetAsUnsignedLong();

  uint32_t&
  SetAsUnsignedLong();

  bool
  TrySetToUnsignedLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnsignedLong() const
  {
    return mType == eUnsignedLong;
  }

  inline uint32_t&
  GetAsUnsignedLong()
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline uint32_t const &
  GetAsUnsignedLong() const
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningUnsignedLongOrString& aOther);

private:
  void
  DestroyUnsignedLong();

  void
  DestroyString();
};


struct ConsoleEvent : public DictionaryBase
{
  Optional<OwningUnsignedLongOrString> mID;
  Optional<Sequence<JS::Value>> mArguments;
  uint32_t mColumnNumber;
  JS::Value mCounter;
  nsString mFilename;
  nsString mFunctionName;
  nsString mGroupName;
  Optional<OwningUnsignedLongOrString> mInnerID;
  nsString mLevel;
  uint32_t mLineNumber;
  bool mPrivate;
  Optional<Sequence<JS::Value>> mStyles;
  double mTimeStamp;
  JS::Value mTimer;

  ConsoleEvent();

  explicit inline ConsoleEvent(const FastDictionaryInitializer& )
    : mCounter(JS::UndefinedValue()),
      mTimer(JS::UndefinedValue())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  ConsoleEvent(const ConsoleEvent&) = delete;
  void operator=(const ConsoleEvent) = delete;

  static bool
  InitIds(JSContext* cx, ConsoleEventAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastConsoleEvent : public ConsoleEvent
{
  inline FastConsoleEvent()
    : ConsoleEvent(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ConsoleBinding {

  typedef mozilla::dom::Console NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Console* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace ConsoleBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ConsoleBinding_h
