/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_HTMLFormControlsCollectionBinding_h
#define mozilla_dom_HTMLFormControlsCollectionBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Element;
class HTMLFormControlsCollection;
struct HTMLFormControlsCollectionAtoms;
struct NativePropertyHooks;
class OwningRadioNodeListOrElement;
class ProtoAndIfaceCache;
class RadioNodeList;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRadioNodeListOrElement& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningRadioNodeListOrElement& aUnion);


class RadioNodeListOrElement
{
  friend class RadioNodeListOrElementArgument;
  enum Type
  {
    eUninitialized,
    eRadioNodeList,
    eElement
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::RadioNodeList> > mRadioNodeList;
    UnionMember<NonNull<mozilla::dom::Element> > mElement;

  };

  Type mType;
  Value mValue;

  RadioNodeListOrElement(const RadioNodeListOrElement&) = delete;
  void operator=(const RadioNodeListOrElement) = delete;
public:
  explicit inline RadioNodeListOrElement()
    : mType(eUninitialized)
  {
  }

  inline ~RadioNodeListOrElement()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::RadioNodeList>&
  RawSetAsRadioNodeList()
  {
    if (mType == eRadioNodeList) {
      return mValue.mRadioNodeList.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRadioNodeList;
    return mValue.mRadioNodeList.SetValue();
  }

  inline NonNull<mozilla::dom::RadioNodeList>&
  SetAsRadioNodeList()
  {
    if (mType == eRadioNodeList) {
      return mValue.mRadioNodeList.Value();
    }
    Uninit();
    mType = eRadioNodeList;
    return mValue.mRadioNodeList.SetValue();
  }

  inline bool
  IsRadioNodeList() const
  {
    return mType == eRadioNodeList;
  }

  inline NonNull<mozilla::dom::RadioNodeList>&
  GetAsRadioNodeList()
  {
    MOZ_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  inline mozilla::dom::RadioNodeList&
  GetAsRadioNodeList() const
  {
    MOZ_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRadioNodeList: {
        DestroyRadioNodeList();
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyRadioNodeList()
  {
    MOZ_ASSERT(IsRadioNodeList(), "Wrong type!");
    mValue.mRadioNodeList.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }
};


class OwningRadioNodeListOrElement : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningRadioNodeListOrElement& aUnion);
  enum Type
  {
    eUninitialized,
    eRadioNodeList,
    eElement
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::RadioNodeList> > mRadioNodeList;
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningRadioNodeListOrElement()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningRadioNodeListOrElement(const OwningRadioNodeListOrElement& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRadioNodeListOrElement()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::RadioNodeList>&
  RawSetAsRadioNodeList();

  OwningNonNull<mozilla::dom::RadioNodeList>&
  SetAsRadioNodeList();

  bool
  TrySetToRadioNodeList(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsRadioNodeList() const
  {
    return mType == eRadioNodeList;
  }

  inline OwningNonNull<mozilla::dom::RadioNodeList>&
  GetAsRadioNodeList()
  {
    MOZ_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  inline OwningNonNull<mozilla::dom::RadioNodeList> const &
  GetAsRadioNodeList() const
  {
    MOZ_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  bool
  TrySetToElement(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningRadioNodeListOrElement& aOther);

private:
  void
  DestroyRadioNodeList();

  void
  DestroyElement();
};


namespace HTMLFormControlsCollectionBinding {

  typedef mozilla::dom::HTMLFormControlsCollection NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLFormControlsCollection* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace HTMLFormControlsCollectionBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_HTMLFormControlsCollectionBinding_h
