/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_cache_SavedTypes_h
#define mozilla_dom_cache_SavedTypes_h

// NOTE: This cannot be rolled into Types.h because the IPC dependency.
//       breaks webidl unified builds.

#include "mozilla/dom/cache/PCacheTypes.h"
#include "mozilla/dom/cache/Types.h"
#include "nsCOMPtr.h"
#include "nsID.h"
#include "nsIOutputStream.h"

namespace mozilla {
namespace dom {
namespace cache {

struct StreamHolder
{
  nsCOMPtr<nsIOutputStream> mValue;
};

struct SavedRequest
{
  SavedRequest() : mHasBodyId(false) { mValue.body() = void_t(); }
  PCacheRequest mValue;
  bool mHasBodyId;
  nsID mBodyId;
  CacheId mCacheId;
};

struct SavedResponse
{
  SavedResponse() : mHasBodyId(false) { mValue.body() = void_t(); }
  PCacheResponse mValue;
  bool mHasBodyId;
  nsID mBodyId;
  CacheId mCacheId;
};

} // namespace cache
} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_cache_SavedTypes_h
