/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_CameraConfigurationEvent_h
#define mozilla_dom_CameraConfigurationEvent_h

#include "CameraManagerBinding.h"
#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CameraConfigurationEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla {
namespace dom {

class CameraConfigurationEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(CameraConfigurationEvent, Event)
protected:
  virtual ~CameraConfigurationEvent();
  explicit CameraConfigurationEvent(mozilla::dom::EventTarget* aOwner);

  CameraMode mMode;
  nsString mRecorderProfile;
  nsRefPtr<DOMRectReadOnly> mPreviewSize;
  nsRefPtr<DOMRectReadOnly> mPictureSize;

public:
  virtual CameraConfigurationEvent* AsCameraConfigurationEvent() MOZ_OVERRIDE;

  virtual JSObject* WrapObjectInternal(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<CameraConfigurationEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const CameraConfigurationEventInit& aEventInitDict);

  static already_AddRefed<CameraConfigurationEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const CameraConfigurationEventInit& aEventInitDict, ErrorResult& aRv);

  CameraMode Mode() const;

  void GetRecorderProfile(nsString& aRetVal) const;

  DOMRectReadOnly* GetPreviewSize() const;

  DOMRectReadOnly* GetPictureSize() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_CameraConfigurationEvent_h
