/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RequestBinding_h
#define mozilla_dom_RequestBinding_h

#include "FetchBinding.h"
#include "HeadersBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class ArrayBufferOrArrayBufferViewOrBlobOrUSVStringOrURLSearchParams;
class HeadersOrByteStringSequenceSequenceOrByteStringMozMap;
struct NativePropertyHooks;
class OwningArrayBufferOrArrayBufferViewOrBlobOrUSVStringOrURLSearchParams;
class OwningHeadersOrByteStringSequenceSequenceOrByteStringMozMap;
class OwningRequestOrUSVString;
class ProtoAndIfaceCache;
class Request;
struct RequestAtoms;
struct RequestInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class RequestContext : uint32_t {
  Audio,
  Beacon,
  Cspreport,
  Download,
  Embed,
  Eventsource,
  Favicon,
  Fetch,
  Font,
  Form,
  Frame,
  Hyperlink,
  Iframe,
  Image,
  Imageset,
  Import,
  Internal,
  Location,
  Manifest,
  Object,
  Ping,
  Plugin,
  Prefetch,
  Script,
  Serviceworker,
  Sharedworker,
  Subresource,
  Style,
  Track,
  Video,
  Worker,
  Xmlhttprequest,
  Xslt,
  EndGuard_
};

namespace RequestContextValues {
extern const EnumEntry strings[34];
} // namespace RequestContextValues


enum class RequestMode : uint32_t {
  Same_origin,
  No_cors,
  Cors,
  Cors_with_forced_preflight,
  EndGuard_
};

namespace RequestModeValues {
extern const EnumEntry strings[5];
} // namespace RequestModeValues


enum class RequestCredentials : uint32_t {
  Omit,
  Same_origin,
  Include,
  EndGuard_
};

namespace RequestCredentialsValues {
extern const EnumEntry strings[4];
} // namespace RequestCredentialsValues


enum class RequestCache : uint32_t {
  Default,
  No_store,
  Reload,
  No_cache,
  Force_cache,
  Only_if_cached,
  EndGuard_
};

namespace RequestCacheValues {
extern const EnumEntry strings[7];
} // namespace RequestCacheValues


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRequestOrUSVString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningRequestOrUSVString& aUnion);


struct RequestInit : public DictionaryBase
{
  Optional<OwningArrayBufferOrArrayBufferViewOrBlobOrUSVStringOrURLSearchParams> mBody;
  Optional<RequestCache> mCache;
  Optional<RequestCredentials> mCredentials;
  Optional<OwningHeadersOrByteStringSequenceSequenceOrByteStringMozMap> mHeaders;
  Optional<nsCString> mMethod;
  Optional<RequestMode> mMode;

  RequestInit();

  explicit inline RequestInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RequestInit(const RequestInit&) = delete;
  void operator=(const RequestInit) = delete;

  static bool
  InitIds(JSContext* cx, RequestInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastRequestInit : public RequestInit
{
  inline FastRequestInit()
    : RequestInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RequestOrUSVString
{
  friend class RequestOrUSVStringArgument;
  enum Type
  {
    eUninitialized,
    eRequest,
    eUSVString
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::Request> > mRequest;
    UnionMember<binding_detail::FakeString > mUSVString;

  };

  Type mType;
  Value mValue;

  RequestOrUSVString(const RequestOrUSVString&) = delete;
  void operator=(const RequestOrUSVString) = delete;
public:
  explicit inline RequestOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~RequestOrUSVString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Request>&
  RawSetAsRequest()
  {
    if (mType == eRequest) {
      return mValue.mRequest.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRequest;
    return mValue.mRequest.SetValue();
  }

  inline NonNull<mozilla::dom::Request>&
  SetAsRequest()
  {
    if (mType == eRequest) {
      return mValue.mRequest.Value();
    }
    Uninit();
    mType = eRequest;
    return mValue.mRequest.SetValue();
  }

  inline bool
  IsRequest() const
  {
    return mType == eRequest;
  }

  inline NonNull<mozilla::dom::Request>&
  GetAsRequest()
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline mozilla::dom::Request&
  GetAsRequest() const
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString&
  GetAsUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRequest: {
        DestroyRequest();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyRequest()
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    mValue.mRequest.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};


class OwningRequestOrUSVString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningRequestOrUSVString& aUnion);
  enum Type
  {
    eUninitialized,
    eRequest,
    eUSVString
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Request> > mRequest;
    UnionMember<nsString > mUSVString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningRequestOrUSVString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningRequestOrUSVString(const OwningRequestOrUSVString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRequestOrUSVString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Request>&
  RawSetAsRequest();

  OwningNonNull<mozilla::dom::Request>&
  SetAsRequest();

  bool
  TrySetToRequest(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsRequest() const
  {
    return mType == eRequest;
  }

  inline OwningNonNull<mozilla::dom::Request>&
  GetAsRequest()
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline OwningNonNull<mozilla::dom::Request> const &
  GetAsRequest() const
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsUSVString().Assign(aData, aLength);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningRequestOrUSVString& aOther);

private:
  void
  DestroyRequest();

  void
  DestroyUSVString();
};


namespace RequestBinding {

  typedef mozilla::dom::Request NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Request* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace RequestBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RequestBinding_h
