#ifndef mozilla_dom_FeatureList_h
#define mozilla_dom_FeatureList_h

#include "nsString.h"

namespace mozilla {
namespace dom {
bool IsFeatureDetectible(const nsAString& aFeature) {
  static const char* const FeatureList[] = {
    "BeforeAfterKeyboardEvent",
    "BeforeAfterKeyboardEvent.embeddedCancelled",
    "BeforeAfterKeyboardEvent.isTrusted",
    "DOMApplicationsManager",
    "DOMApplicationsManager.applyDownload",
    "DOMApplicationsManager.extractManifest",
    "DOMApplicationsManager.getAll",
    "DOMApplicationsManager.getIcon",
    "DOMApplicationsManager.getNotInstalled",
    "DOMApplicationsManager.import",
    "DOMApplicationsManager.onenabledstatechange",
    "DOMApplicationsManager.oninstall",
    "DOMApplicationsManager.onuninstall",
    "DOMApplicationsManager.setEnabled",
    "DOMApplicationsManager.uninstall",
    "DOMApplicationsRegistry.mgmt",
    "DOMDownload",
    "DOMDownload.contentType",
    "DOMDownload.currentBytes",
    "DOMDownload.error",
    "DOMDownload.id",
    "DOMDownload.onstatechange",
    "DOMDownload.path",
    "DOMDownload.pause",
    "DOMDownload.resume",
    "DOMDownload.startTime",
    "DOMDownload.state",
    "DOMDownload.storageName",
    "DOMDownload.storagePath",
    "DOMDownload.totalBytes",
    "DOMDownload.url",
    "DOMMobileMessageError",
    "DOMMobileMessageError.data",
    "DownloadEvent",
    "DownloadEvent.download",
    "DownloadEvent.isTrusted",
    "HTMLIFrameElement.addNextPaintListener",
    "HTMLIFrameElement.download",
    "HTMLIFrameElement.getActive",
    "HTMLIFrameElement.getCanGoBack",
    "HTMLIFrameElement.getCanGoForward",
    "HTMLIFrameElement.getContentDimensions",
    "HTMLIFrameElement.getScreenshot",
    "HTMLIFrameElement.getVisible",
    "HTMLIFrameElement.goBack",
    "HTMLIFrameElement.goForward",
    "HTMLIFrameElement.purgeHistory",
    "HTMLIFrameElement.reload",
    "HTMLIFrameElement.removeNextPaintListener",
    "HTMLIFrameElement.sendMouseEvent",
    "HTMLIFrameElement.sendTouchEvent",
    "HTMLIFrameElement.setActive",
    "HTMLIFrameElement.setInputMethodActive",
    "HTMLIFrameElement.setNFCFocus",
    "HTMLIFrameElement.setVisible",
    "HTMLIFrameElement.stop",
    "HTMLIFrameElement.zoom",
    "IccChangeEvent",
    "IccChangeEvent.iccId",
    "IccChangeEvent.isTrusted",
    "MMICall",
    "MMICall.result",
    "MozCellBroadcast",
    "MozCellBroadcast.onreceived",
    "MozCellBroadcastEtwsInfo",
    "MozCellBroadcastEtwsInfo.emergencyUserAlert",
    "MozCellBroadcastEtwsInfo.popup",
    "MozCellBroadcastEtwsInfo.warningType",
    "MozCellBroadcastEvent",
    "MozCellBroadcastEvent.isTrusted",
    "MozCellBroadcastEvent.message",
    "MozCellBroadcastMessage",
    "MozCellBroadcastMessage.body",
    "MozCellBroadcastMessage.cdmaServiceCategory",
    "MozCellBroadcastMessage.etws",
    "MozCellBroadcastMessage.gsmGeographicalScope",
    "MozCellBroadcastMessage.language",
    "MozCellBroadcastMessage.messageClass",
    "MozCellBroadcastMessage.messageCode",
    "MozCellBroadcastMessage.messageId",
    "MozCellBroadcastMessage.serviceId",
    "MozCellBroadcastMessage.timestamp",
    "MozMessageDeletedEvent",
    "MozMessageDeletedEvent.deletedMessageIds",
    "MozMessageDeletedEvent.deletedThreadIds",
    "MozMessageDeletedEvent.isTrusted",
    "MozMmsEvent",
    "MozMmsEvent.isTrusted",
    "MozMmsEvent.message",
    "MozMobileConnection.changeCallBarringPassword",
    "MozMobileConnection.data",
    "MozMobileConnection.exitEmergencyCbMode",
    "MozMobileConnection.getCallBarringOption",
    "MozMobileConnection.getCallForwardingOption",
    "MozMobileConnection.getCallWaitingOption",
    "MozMobileConnection.getCallingLineIdRestriction",
    "MozMobileConnection.getNetworks",
    "MozMobileConnection.getPreferredNetworkType",
    "MozMobileConnection.getRoamingPreference",
    "MozMobileConnection.getVoicePrivacyMode",
    "MozMobileConnection.iccId",
    "MozMobileConnection.lastKnownHomeNetwork",
    "MozMobileConnection.lastKnownNetwork",
    "MozMobileConnection.networkSelectionMode",
    "MozMobileConnection.radioState",
    "MozMobileConnection.selectNetwork",
    "MozMobileConnection.selectNetworkAutomatically",
    "MozMobileConnection.setCallBarringOption",
    "MozMobileConnection.setCallForwardingOption",
    "MozMobileConnection.setCallWaitingOption",
    "MozMobileConnection.setCallingLineIdRestriction",
    "MozMobileConnection.setPreferredNetworkType",
    "MozMobileConnection.setRadioEnabled",
    "MozMobileConnection.setRoamingPreference",
    "MozMobileConnection.setVoicePrivacyMode",
    "MozMobileConnection.supportedNetworkTypes",
    "MozMobileConnection.voice",
    "MozMobileMessageManager",
    "MozMobileMessageManager.delete",
    "MozMobileMessageManager.getMessage",
    "MozMobileMessageManager.getMessages",
    "MozMobileMessageManager.getSegmentInfoForText",
    "MozMobileMessageManager.getSmscAddress",
    "MozMobileMessageManager.getThreads",
    "MozMobileMessageManager.markMessageRead",
    "MozMobileMessageManager.ondeleted",
    "MozMobileMessageManager.ondeliveryerror",
    "MozMobileMessageManager.ondeliverysuccess",
    "MozMobileMessageManager.onfailed",
    "MozMobileMessageManager.onreaderror",
    "MozMobileMessageManager.onreadsuccess",
    "MozMobileMessageManager.onreceived",
    "MozMobileMessageManager.onretrieving",
    "MozMobileMessageManager.onsending",
    "MozMobileMessageManager.onsent",
    "MozMobileMessageManager.retrieveMMS",
    "MozMobileMessageManager.send",
    "MozMobileMessageManager.sendMMS",
    "MozSettingsTransactionEvent",
    "MozSettingsTransactionEvent.error",
    "MozSettingsTransactionEvent.isTrusted",
    "MozSmsEvent",
    "MozSmsEvent.isTrusted",
    "MozSmsEvent.message",
    "MozStkCommandEvent",
    "MozStkCommandEvent.command",
    "MozStkCommandEvent.isTrusted",
    "MozVoicemail",
    "MozVoicemail.getDisplayName",
    "MozVoicemail.getNumber",
    "MozVoicemail.getStatus",
    "MozVoicemail.onstatuschanged",
    "MozVoicemailEvent",
    "MozVoicemailEvent.isTrusted",
    "MozVoicemailEvent.status",
    "MozVoicemailStatus",
    "MozVoicemailStatus.hasMessages",
    "MozVoicemailStatus.messageCount",
    "MozVoicemailStatus.returnMessage",
    "MozVoicemailStatus.returnNumber",
    "MozVoicemailStatus.serviceId",
    "Navigator.addIdleObserver",
    "Navigator.engineeringMode",
    "Navigator.getFeature",
    "Navigator.hasFeature",
    "Navigator.mozAlarms",
    "Navigator.mozPermissionSettings",
    "Navigator.mozPhoneNumberService",
    "Navigator.mozPower",
    "Navigator.mozPresentationDeviceInfo",
    "Navigator.push",
    "Navigator.removeIdleObserver",
    "Navigator.seManager",
    "Navigator.syncManager",
    "Navigator.tv",
    "NetworkStatsData",
    "NetworkStatsData.receivedBytes",
    "NetworkStatsData.sentBytes",
    "NetworkStatsData.timestamp",
    "PowerStatsData",
    "PowerStatsData.consumedPower",
    "PowerStatsData.timestamp",
    "RequestSyncApp",
    "RequestSyncApp.isInBrowserElement",
    "RequestSyncApp.manifestURL",
    "RequestSyncApp.origin",
    "RequestSyncTask",
    "RequestSyncTask.app",
    "RequestSyncTask.data",
    "RequestSyncTask.lastSync",
    "RequestSyncTask.minInterval",
    "RequestSyncTask.oneShot",
    "RequestSyncTask.overwrittenMinInterval",
    "RequestSyncTask.runNow",
    "RequestSyncTask.setPolicy",
    "RequestSyncTask.state",
    "RequestSyncTask.task",
    "RequestSyncTask.wakeUpPage",
    "RequestSyncTask.wifiOnly",
    "ResourceStats",
    "ResourceStats.component",
    "ResourceStats.end",
    "ResourceStats.getData",
    "ResourceStats.manifestURL",
    "ResourceStats.serviceType",
    "ResourceStats.start",
    "ResourceStats.type",
    "ResourceStatsAlarm",
    "ResourceStatsAlarm.alarmId",
    "ResourceStatsAlarm.component",
    "ResourceStatsAlarm.data",
    "ResourceStatsAlarm.manifestURL",
    "ResourceStatsAlarm.serviceType",
    "ResourceStatsAlarm.threshold",
    "ResourceStatsAlarm.type",
    "ResourceStatsManager",
    "ResourceStatsManager.addAlarm",
    "ResourceStatsManager.clearAllStats",
    "ResourceStatsManager.clearStats",
    "ResourceStatsManager.getAlarms",
    "ResourceStatsManager.getAvailableComponents",
    "ResourceStatsManager.getStats",
    "ResourceStatsManager.maxStorageAge",
    "ResourceStatsManager.removeAlarm",
    "ResourceStatsManager.removeAllAlarms",
    "ResourceStatsManager.resourceTypes",
    "ResourceStatsManager.sampleRate",
    "SEChannel",
    "SEChannel.close",
    "SEChannel.isClosed",
    "SEChannel.openResponse",
    "SEChannel.session",
    "SEChannel.transmit",
    "SEChannel.type",
    "SEReader",
    "SEReader.closeAll",
    "SEReader.isSEPresent",
    "SEReader.openSession",
    "SEReader.type",
    "SEResponse",
    "SEResponse.channel",
    "SEResponse.data",
    "SEResponse.sw1",
    "SEResponse.sw2",
    "SESession",
    "SESession.closeAll",
    "SESession.isClosed",
    "SESession.openLogicalChannel",
    "SESession.reader",
    "TVChannel",
    "TVChannel.getCurrentProgram",
    "TVChannel.getPrograms",
    "TVChannel.isEmergency",
    "TVChannel.isFree",
    "TVChannel.name",
    "TVChannel.networkId",
    "TVChannel.number",
    "TVChannel.serviceId",
    "TVChannel.source",
    "TVChannel.transportStreamId",
    "TVChannel.type",
    "TVCurrentChannelChangedEvent",
    "TVCurrentChannelChangedEvent.channel",
    "TVCurrentChannelChangedEvent.isTrusted",
    "TVCurrentSourceChangedEvent",
    "TVCurrentSourceChangedEvent.isTrusted",
    "TVCurrentSourceChangedEvent.source",
    "TVEITBroadcastedEvent",
    "TVEITBroadcastedEvent.isTrusted",
    "TVEITBroadcastedEvent.programs",
    "TVManager",
    "TVManager.getTuners",
    "TVProgram",
    "TVProgram.channel",
    "TVProgram.description",
    "TVProgram.duration",
    "TVProgram.eventId",
    "TVProgram.getAudioLanguages",
    "TVProgram.getSubtitleLanguages",
    "TVProgram.rating",
    "TVProgram.startTime",
    "TVProgram.title",
    "TVScanningStateChangedEvent",
    "TVScanningStateChangedEvent.channel",
    "TVScanningStateChangedEvent.isTrusted",
    "TVScanningStateChangedEvent.state",
    "TVSource",
    "TVSource.currentChannel",
    "TVSource.getChannels",
    "TVSource.isScanning",
    "TVSource.oncurrentchannelchanged",
    "TVSource.oneitbroadcasted",
    "TVSource.onscanningstatechanged",
    "TVSource.setCurrentChannel",
    "TVSource.startScanning",
    "TVSource.stopScanning",
    "TVSource.tuner",
    "TVSource.type",
    "TVTuner",
    "TVTuner.currentSource",
    "TVTuner.getSources",
    "TVTuner.getSupportedSourceTypes",
    "TVTuner.id",
    "TVTuner.oncurrentsourcechanged",
    "TVTuner.setCurrentSource",
    "TVTuner.stream",
    "UDPMessageEvent",
    "UDPMessageEvent.data",
    "UDPMessageEvent.isTrusted",
    "UDPMessageEvent.remoteAddress",
    "UDPMessageEvent.remotePort",
    "UDPSocket",
    "UDPSocket.addressReuse",
    "UDPSocket.close",
    "UDPSocket.closed",
    "UDPSocket.joinMulticastGroup",
    "UDPSocket.leaveMulticastGroup",
    "UDPSocket.localAddress",
    "UDPSocket.localPort",
    "UDPSocket.loopback",
    "UDPSocket.onmessage",
    "UDPSocket.opened",
    "UDPSocket.readyState",
    "UDPSocket.remoteAddress",
    "UDPSocket.remotePort",
    "UDPSocket.send",
    "USSDReceivedEvent",
    "USSDReceivedEvent.isTrusted",
    "USSDReceivedEvent.message",
    "USSDReceivedEvent.serviceId",
    "USSDReceivedEvent.session",
    "USSDSession",
    "USSDSession.cancel",
    "USSDSession.send",
    nullptr
  };
  const char* const* feature = FeatureList;
  while (*feature) {
    if (aFeature.EqualsASCII(*feature)) {
      return true;
    }
    ++feature;
  }

  return false;
}
} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_FeatureList_h
