/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_MessageEventBinding_h
#define mozilla_dom_MessageEventBinding_h

#include "EventBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/MessagePort.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

class nsGlobalWindow;
class nsIDOMWindow;

namespace mozilla {
namespace dom {

class MessageEvent;
struct MessageEventAtoms;
struct MessageEventInitAtoms;
class MessagePortBase;
struct NativePropertyHooks;
class OwningWindowOrMessagePort;
class OwningWindowProxyOrMessagePortOrClient;
class ProtoAndIfaceCache;
class WindowOrMessagePort;

namespace workers {

class ServiceWorkerClient;

} // namespace workers

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningWindowOrMessagePort& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningWindowProxyOrMessagePortOrClient& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningWindowOrMessagePort& aUnion);


void
ImplCycleCollectionUnlink(OwningWindowProxyOrMessagePortOrClient& aUnion);


class WindowOrMessagePort
{
  friend class WindowOrMessagePortArgument;
  enum Type
  {
    eUninitialized,
    eWindow,
    eMessagePort
  };

  union Value
  {
    UnionMember<NonNull<nsGlobalWindow> > mWindow;
    UnionMember<NonNull<mozilla::dom::MessagePortBase> > mMessagePort;

  };

  Type mType;
  Value mValue;

  WindowOrMessagePort(const WindowOrMessagePort&) = delete;
  void operator=(const WindowOrMessagePort) = delete;
public:
  explicit inline WindowOrMessagePort()
    : mType(eUninitialized)
  {
  }

  inline ~WindowOrMessagePort()
  {
    Uninit();
  }

  inline NonNull<nsGlobalWindow>&
  RawSetAsWindow()
  {
    if (mType == eWindow) {
      return mValue.mWindow.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWindow;
    return mValue.mWindow.SetValue();
  }

  inline NonNull<nsGlobalWindow>&
  SetAsWindow()
  {
    if (mType == eWindow) {
      return mValue.mWindow.Value();
    }
    Uninit();
    mType = eWindow;
    return mValue.mWindow.SetValue();
  }

  inline bool
  IsWindow() const
  {
    return mType == eWindow;
  }

  inline NonNull<nsGlobalWindow>&
  GetAsWindow()
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  inline nsGlobalWindow&
  GetAsWindow() const
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  inline NonNull<mozilla::dom::MessagePortBase>&
  RawSetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline NonNull<mozilla::dom::MessagePortBase>&
  SetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    Uninit();
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline NonNull<mozilla::dom::MessagePortBase>&
  GetAsMessagePort()
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline mozilla::dom::MessagePortBase&
  GetAsMessagePort() const
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eWindow: {
        DestroyWindow();
        break;
      }
      case eMessagePort: {
        DestroyMessagePort();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyWindow()
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    mValue.mWindow.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyMessagePort()
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    mValue.mMessagePort.Destroy();
    mType = eUninitialized;
  }
};


class OwningWindowOrMessagePort : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningWindowOrMessagePort& aUnion);
  enum Type
  {
    eUninitialized,
    eWindow,
    eMessagePort
  };

  union Value
  {
    UnionMember<OwningNonNull<nsGlobalWindow> > mWindow;
    UnionMember<OwningNonNull<mozilla::dom::MessagePortBase> > mMessagePort;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningWindowOrMessagePort()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningWindowOrMessagePort(const OwningWindowOrMessagePort& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningWindowOrMessagePort()
  {
    Uninit();
  }

  OwningNonNull<nsGlobalWindow>&
  RawSetAsWindow();

  OwningNonNull<nsGlobalWindow>&
  SetAsWindow();

  bool
  TrySetToWindow(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsWindow() const
  {
    return mType == eWindow;
  }

  inline OwningNonNull<nsGlobalWindow>&
  GetAsWindow()
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  inline OwningNonNull<nsGlobalWindow> const &
  GetAsWindow() const
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  OwningNonNull<mozilla::dom::MessagePortBase>&
  RawSetAsMessagePort();

  OwningNonNull<mozilla::dom::MessagePortBase>&
  SetAsMessagePort();

  bool
  TrySetToMessagePort(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline OwningNonNull<mozilla::dom::MessagePortBase>&
  GetAsMessagePort()
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline OwningNonNull<mozilla::dom::MessagePortBase> const &
  GetAsMessagePort() const
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningWindowOrMessagePort& aOther);

private:
  void
  DestroyWindow();

  void
  DestroyMessagePort();
};


class WindowProxyOrMessagePortOrClient
{
  friend class WindowProxyOrMessagePortOrClientArgument;
  enum Type
  {
    eUninitialized,
    eWindowProxy,
    eMessagePort,
    eClient
  };

  union Value
  {
    UnionMember<nsIDOMWindow* > mWindowProxy;
    UnionMember<NonNull<mozilla::dom::MessagePortBase> > mMessagePort;
    UnionMember<NonNull<mozilla::dom::workers::ServiceWorkerClient> > mClient;

  };

  Type mType;
  Value mValue;

  WindowProxyOrMessagePortOrClient(const WindowProxyOrMessagePortOrClient&) = delete;
  void operator=(const WindowProxyOrMessagePortOrClient) = delete;
public:
  explicit inline WindowProxyOrMessagePortOrClient()
    : mType(eUninitialized)
  {
  }

  inline ~WindowProxyOrMessagePortOrClient()
  {
    Uninit();
  }

  inline nsIDOMWindow*&
  RawSetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline nsIDOMWindow*&
  SetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    Uninit();
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline nsIDOMWindow*&
  GetAsWindowProxy()
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline nsIDOMWindow*
  GetAsWindowProxy() const
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline NonNull<mozilla::dom::MessagePortBase>&
  RawSetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline NonNull<mozilla::dom::MessagePortBase>&
  SetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    Uninit();
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline NonNull<mozilla::dom::MessagePortBase>&
  GetAsMessagePort()
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline mozilla::dom::MessagePortBase&
  GetAsMessagePort() const
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline NonNull<mozilla::dom::workers::ServiceWorkerClient>&
  RawSetAsClient()
  {
    if (mType == eClient) {
      return mValue.mClient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eClient;
    return mValue.mClient.SetValue();
  }

  inline NonNull<mozilla::dom::workers::ServiceWorkerClient>&
  SetAsClient()
  {
    if (mType == eClient) {
      return mValue.mClient.Value();
    }
    Uninit();
    mType = eClient;
    return mValue.mClient.SetValue();
  }

  inline bool
  IsClient() const
  {
    return mType == eClient;
  }

  inline NonNull<mozilla::dom::workers::ServiceWorkerClient>&
  GetAsClient()
  {
    MOZ_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline mozilla::dom::workers::ServiceWorkerClient&
  GetAsClient() const
  {
    MOZ_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eWindowProxy: {
        DestroyWindowProxy();
        break;
      }
      case eMessagePort: {
        DestroyMessagePort();
        break;
      }
      case eClient: {
        DestroyClient();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyWindowProxy()
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    mValue.mWindowProxy.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyMessagePort()
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    mValue.mMessagePort.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyClient()
  {
    MOZ_ASSERT(IsClient(), "Wrong type!");
    mValue.mClient.Destroy();
    mType = eUninitialized;
  }
};


class OwningWindowProxyOrMessagePortOrClient : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningWindowProxyOrMessagePortOrClient& aUnion);
  enum Type
  {
    eUninitialized,
    eWindowProxy,
    eMessagePort,
    eClient
  };

  union Value
  {
    UnionMember<nsRefPtr<nsIDOMWindow> > mWindowProxy;
    UnionMember<OwningNonNull<mozilla::dom::MessagePortBase> > mMessagePort;
    UnionMember<OwningNonNull<mozilla::dom::workers::ServiceWorkerClient> > mClient;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningWindowProxyOrMessagePortOrClient()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningWindowProxyOrMessagePortOrClient(const OwningWindowProxyOrMessagePortOrClient& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningWindowProxyOrMessagePortOrClient()
  {
    Uninit();
  }

  nsRefPtr<nsIDOMWindow>&
  RawSetAsWindowProxy();

  nsRefPtr<nsIDOMWindow>&
  SetAsWindowProxy();

  bool
  TrySetToWindowProxy(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline nsRefPtr<nsIDOMWindow>&
  GetAsWindowProxy()
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline nsRefPtr<nsIDOMWindow> const &
  GetAsWindowProxy() const
  {
    MOZ_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  OwningNonNull<mozilla::dom::MessagePortBase>&
  RawSetAsMessagePort();

  OwningNonNull<mozilla::dom::MessagePortBase>&
  SetAsMessagePort();

  bool
  TrySetToMessagePort(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline OwningNonNull<mozilla::dom::MessagePortBase>&
  GetAsMessagePort()
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline OwningNonNull<mozilla::dom::MessagePortBase> const &
  GetAsMessagePort() const
  {
    MOZ_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  OwningNonNull<mozilla::dom::workers::ServiceWorkerClient>&
  RawSetAsClient();

  OwningNonNull<mozilla::dom::workers::ServiceWorkerClient>&
  SetAsClient();

  bool
  TrySetToClient(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsClient() const
  {
    return mType == eClient;
  }

  inline OwningNonNull<mozilla::dom::workers::ServiceWorkerClient>&
  GetAsClient()
  {
    MOZ_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline OwningNonNull<mozilla::dom::workers::ServiceWorkerClient> const &
  GetAsClient() const
  {
    MOZ_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningWindowProxyOrMessagePortOrClient& aOther);

private:
  void
  DestroyWindowProxy();

  void
  DestroyMessagePort();

  void
  DestroyClient();
};


struct MessageEventInit : public EventInit
{
  JS::Value mData;
  Optional<nsString> mLastEventId;
  Optional<nsString> mOrigin;
  Optional<Nullable<Sequence<OwningNonNull<mozilla::dom::MessagePortBase>>>> mPorts;
  Nullable<OwningWindowOrMessagePort > mSource;

  MessageEventInit();

  explicit inline MessageEventInit(const FastDictionaryInitializer& )
    : EventInit(FastDictionaryInitializer()),
      mData(JS::UndefinedValue())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  MessageEventInit(const MessageEventInit&) = delete;
  void operator=(const MessageEventInit) = delete;

  static bool
  InitIds(JSContext* cx, MessageEventInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastMessageEventInit : public MessageEventInit
{
  inline FastMessageEventInit()
    : MessageEventInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MessageEventBinding {

  typedef mozilla::dom::MessageEvent NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MessageEvent* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MessageEventBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MessageEventBinding_h
