/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_SelectionStateChangedEvent_h
#define mozilla_dom_SelectionStateChangedEvent_h

#include "SelectionStateChangedEventBinding.h"
#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/SelectionStateChangedEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class SelectionStateChangedEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(SelectionStateChangedEvent, Event)
protected:
  virtual ~SelectionStateChangedEvent();
  explicit SelectionStateChangedEvent(mozilla::dom::EventTarget* aOwner);

  bool mVisible;
  nsString mSelectedText;
  nsRefPtr<DOMRectReadOnly> mBoundingClientRect;
  nsTArray<SelectionState> mStates;

public:
  virtual SelectionStateChangedEvent* AsSelectionStateChangedEvent() MOZ_OVERRIDE;

  virtual JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) MOZ_OVERRIDE;

  static already_AddRefed<SelectionStateChangedEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SelectionStateChangedEventInit& aEventInit);

  static already_AddRefed<SelectionStateChangedEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SelectionStateChangedEventInit& aEventInit, ErrorResult& aRv);

  bool Visible() const;

  void GetSelectedText(nsString& aRetVal) const;

  DOMRectReadOnly* GetBoundingClientRect() const;

  void GetStates(nsTArray<SelectionState>& aRetVal) const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SelectionStateChangedEvent_h
