/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_PopupBlockedEvent_h
#define mozilla_dom_PopupBlockedEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/PopupBlockedEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class PopupBlockedEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(PopupBlockedEvent, Event)
protected:
  virtual ~PopupBlockedEvent();
  explicit PopupBlockedEvent(mozilla::dom::EventTarget* aOwner);

  nsRefPtr<nsGlobalWindow> mRequestingWindow;
  nsRefPtr<nsIURI> mPopupWindowURI;
  nsString mPopupWindowName;
  nsString mPopupWindowFeatures;

public:
  virtual PopupBlockedEvent* AsPopupBlockedEvent() override;

  virtual JSObject* WrapObjectInternal(JSContext* aCx) override;

  static already_AddRefed<PopupBlockedEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PopupBlockedEventInit& aEventInitDict);

  static already_AddRefed<PopupBlockedEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PopupBlockedEventInit& aEventInitDict, ErrorResult& aRv);

  nsGlobalWindow* GetRequestingWindow() const;

  nsIURI* GetPopupWindowURI() const;

  void GetPopupWindowName(nsString& aRetVal) const;

  void GetPopupWindowFeatures(nsString& aRetVal) const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PopupBlockedEvent_h
