/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_CFStateChangeEvent_h
#define mozilla_dom_CFStateChangeEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CFStateChangeEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla {
namespace dom {

class CFStateChangeEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(CFStateChangeEvent, Event)
protected:
  virtual ~CFStateChangeEvent();
  explicit CFStateChangeEvent(mozilla::dom::EventTarget* aOwner);

  uint16_t mAction;
  uint16_t mReason;
  nsString mNumber;
  uint16_t mTimeSeconds;
  uint16_t mServiceClass;

public:
  virtual CFStateChangeEvent* AsCFStateChangeEvent() override;

  virtual JSObject* WrapObjectInternal(JSContext* aCx) override;

  static already_AddRefed<CFStateChangeEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const CFStateChangeEventInit& aEventInitDict);

  static already_AddRefed<CFStateChangeEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const CFStateChangeEventInit& aEventInitDict, ErrorResult& aRv);

  uint16_t Action() const;

  uint16_t Reason() const;

  void GetNumber(nsString& aRetVal) const;

  uint16_t TimeSeconds() const;

  uint16_t ServiceClass() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_CFStateChangeEvent_h
