/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_InstallTriggerBinding_h
#define mozilla_dom_InstallTriggerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/MozMap.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class InstallTriggerCallback;
struct InstallTriggerDataAtoms;
class InstallTriggerImpl;
struct InstallTriggerImplAtoms;
struct NativePropertyHooks;
class OwningStringOrInstallTriggerData;
class ProtoAndIfaceCache;
class StringOrInstallTriggerData;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct InstallTriggerData : public DictionaryBase
{
  Optional<nsString> mHash;
  Optional<nsString> mIconURL;
  Optional<nsString> mURL;

  InstallTriggerData();

  explicit inline InstallTriggerData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline InstallTriggerData(const InstallTriggerData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const InstallTriggerData& aOther);

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastInstallTriggerData : public InstallTriggerData
{
  inline FastInstallTriggerData()
    : InstallTriggerData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrInstallTriggerData
{
  friend class StringOrInstallTriggerDataArgument;
  enum Type
  {
    eUninitialized,
    eString,
    eInstallTriggerData
  };

  union Value
  {
    UnionMember<binding_detail::FakeString > mString;
    UnionMember<binding_detail::FastInstallTriggerData > mInstallTriggerData;

  };

  Type mType;
  Value mValue;

  StringOrInstallTriggerData(const StringOrInstallTriggerData&) = delete;
  void operator=(const StringOrInstallTriggerData) = delete;
public:
  explicit inline StringOrInstallTriggerData()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrInstallTriggerData()
  {
    Uninit();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline binding_detail::FastInstallTriggerData&
  RawSetAsInstallTriggerData()
  {
    if (mType == eInstallTriggerData) {
      return mValue.mInstallTriggerData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eInstallTriggerData;
    return mValue.mInstallTriggerData.SetValue();
  }

  inline binding_detail::FastInstallTriggerData&
  SetAsInstallTriggerData()
  {
    if (mType == eInstallTriggerData) {
      return mValue.mInstallTriggerData.Value();
    }
    Uninit();
    mType = eInstallTriggerData;
    return mValue.mInstallTriggerData.SetValue();
  }

  inline bool
  IsInstallTriggerData() const
  {
    return mType == eInstallTriggerData;
  }

  inline binding_detail::FastInstallTriggerData&
  GetAsInstallTriggerData()
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline const InstallTriggerData&
  GetAsInstallTriggerData() const
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eInstallTriggerData: {
        DestroyInstallTriggerData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyInstallTriggerData()
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    mValue.mInstallTriggerData.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrInstallTriggerData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrInstallTriggerData& aUnion);
  enum Type
  {
    eUninitialized,
    eString,
    eInstallTriggerData
  };

  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<InstallTriggerData > mInstallTriggerData;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningStringOrInstallTriggerData()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningStringOrInstallTriggerData(const OwningStringOrInstallTriggerData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrInstallTriggerData()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  InstallTriggerData&
  RawSetAsInstallTriggerData();

  InstallTriggerData&
  SetAsInstallTriggerData();

  bool
  TrySetToInstallTriggerData(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsInstallTriggerData() const
  {
    return mType == eInstallTriggerData;
  }

  inline InstallTriggerData&
  GetAsInstallTriggerData()
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline InstallTriggerData const &
  GetAsInstallTriggerData() const
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningStringOrInstallTriggerData& aOther);

private:
  void
  DestroyString();

  void
  DestroyInstallTriggerData();
};


class InstallTriggerCallback : public CallbackFunction
{
public:
  explicit inline InstallTriggerCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObjPtr, const nsAString& url, int16_t status, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), thisObjPtr));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext(),
                                    JS::ObjectValue(*thisObjJS));
    return Call(s.GetContext(), thisValJS, url, status, aRv);
  }

  inline void
  Call(const nsAString& url, int16_t status, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, url, status, aRv);
  }

  inline bool
  operator==(const InstallTriggerCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const nsAString& url, int16_t status, ErrorResult& aRv);
};


namespace InstallTriggerImplBinding {

  typedef mozilla::dom::InstallTriggerImpl NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::InstallTriggerImpl* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace InstallTriggerImplBinding



class InstallTriggerImplJSImpl : public CallbackInterface
{
public:
  explicit inline InstallTriggerImplJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  bool Enabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool Install(const MozMap<OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const InstallTriggerImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerImplAtoms* atomsCache);
};


class InstallTriggerImpl final : public nsSupportsWeakReference,
                                 public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(InstallTriggerImpl)

private:
  nsRefPtr<InstallTriggerImplJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  InstallTriggerImpl(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~InstallTriggerImpl();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) override;

  bool Enabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool Install(const MozMap<OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_InstallTriggerBinding_h
