/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_StyleSheetChangeEvent_h
#define mozilla_dom_StyleSheetChangeEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/StyleSheetChangeEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class StyleSheetChangeEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(StyleSheetChangeEvent, Event)
protected:
  virtual ~StyleSheetChangeEvent();
  explicit StyleSheetChangeEvent(mozilla::dom::EventTarget* aOwner);

  nsRefPtr<CSSStyleSheet> mStylesheet;
  bool mDocumentSheet;

public:
  virtual StyleSheetChangeEvent* AsStyleSheetChangeEvent() override;

  virtual JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<StyleSheetChangeEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const StyleSheetChangeEventInit& aEventInitDict);

  static already_AddRefed<StyleSheetChangeEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const StyleSheetChangeEventInit& aEventInitDict, ErrorResult& aRv);

  CSSStyleSheet* GetStylesheet() const;

  bool DocumentSheet() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_StyleSheetChangeEvent_h
