/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RTCPeerConnectionBinding_h
#define mozilla_dom_RTCPeerConnectionBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "nsWeakReference.h"

class nsIDOMDataChannel;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class DOMError;
struct DeprecatedRTCOfferOptionsSet;
struct DeprecatedRTCOfferOptionsSetAtoms;
class EventHandlerNonNull;
class MediaStreamTrack;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;
struct RTCConfiguration;
struct RTCDataChannelInit;
struct RTCDataChannelInitAtoms;
struct RTCOfferOptions;
struct RTCOfferOptionsAtoms;
class RTCPeerConnectionErrorCallback;
class RTCRtpReceiver;
class RTCRtpSender;
class RTCSessionDescriptionCallback;
class RTCStatsCallback;
class RTCStatsReport;
class VoidFunction;
class mozRTCIceCandidate;
class mozRTCPeerConnection;
struct mozRTCPeerConnectionAtoms;
class mozRTCSessionDescription;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {

enum class RTCSignalingState : uint32_t {
  Stable,
  Have_local_offer,
  Have_remote_offer,
  Have_local_pranswer,
  Have_remote_pranswer,
  Closed,
  EndGuard_
};

namespace RTCSignalingStateValues {
extern const EnumEntry strings[7];
} // namespace RTCSignalingStateValues


enum class RTCIceGatheringState : uint32_t {
  New,
  Gathering,
  Complete,
  EndGuard_
};

namespace RTCIceGatheringStateValues {
extern const EnumEntry strings[4];
} // namespace RTCIceGatheringStateValues


enum class RTCIceConnectionState : uint32_t {
  New,
  Checking,
  Connected,
  Completed,
  Failed,
  Disconnected,
  Closed,
  EndGuard_
};

namespace RTCIceConnectionStateValues {
extern const EnumEntry strings[8];
} // namespace RTCIceConnectionStateValues


struct DeprecatedRTCOfferOptionsSet : public DictionaryBase
{
  Optional<bool> mMozBundleOnly;
  Optional<bool> mMozDontOfferDataChannel;
  Optional<bool> mOfferToReceiveAudio;
  Optional<bool> mOfferToReceiveVideo;

  DeprecatedRTCOfferOptionsSet();

  explicit inline DeprecatedRTCOfferOptionsSet(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline DeprecatedRTCOfferOptionsSet(const DeprecatedRTCOfferOptionsSet& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const DeprecatedRTCOfferOptionsSet& aOther);

private:
  static bool
  InitIds(JSContext* cx, DeprecatedRTCOfferOptionsSetAtoms* atomsCache);
};

namespace binding_detail {
struct FastDeprecatedRTCOfferOptionsSet : public DeprecatedRTCOfferOptionsSet
{
  inline FastDeprecatedRTCOfferOptionsSet()
    : DeprecatedRTCOfferOptionsSet(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCDataChannelInit : public DictionaryBase
{
  Nullable<uint16_t> mId;
  Optional<uint16_t> mMaxRetransmitNum;
  Nullable<uint16_t> mMaxRetransmitTime;
  Nullable<uint16_t> mMaxRetransmits;
  bool mNegotiated;
  bool mOrdered;
  Optional<bool> mOutOfOrderAllowed;
  Optional<bool> mPreset;
  nsString mProtocol;
  Optional<uint16_t> mStream;

  RTCDataChannelInit();

  explicit inline RTCDataChannelInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCDataChannelInit(const RTCDataChannelInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCDataChannelInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCDataChannelInit : public RTCDataChannelInit
{
  inline FastRTCDataChannelInit()
    : RTCDataChannelInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCOfferOptions : public DictionaryBase
{
  DeprecatedRTCOfferOptionsSet mMandatory;
  Optional<bool> mMozBundleOnly;
  Optional<bool> mMozDontOfferDataChannel;
  Optional<int32_t> mOfferToReceiveAudio;
  Optional<int32_t> mOfferToReceiveVideo;
  Optional<Sequence<DeprecatedRTCOfferOptionsSet>> mOptional;

  RTCOfferOptions();

  explicit inline RTCOfferOptions(const FastDictionaryInitializer& )
    : mMandatory(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCOfferOptions(const RTCOfferOptions& aOther)
    : mMandatory(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCOfferOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCOfferOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCOfferOptions : public RTCOfferOptions
{
  inline FastRTCOfferOptions()
    : RTCOfferOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RTCSessionDescriptionCallback : public CallbackFunction
{
public:
  explicit inline RTCSessionDescriptionCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!WrapCallThisValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, sdp, aRv);
  }

  inline void
  Call(mozRTCSessionDescription& sdp, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, sdp, aRv);
  }

  inline bool
  operator==(const RTCSessionDescriptionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, mozRTCSessionDescription& sdp, ErrorResult& aRv);
};


class RTCPeerConnectionErrorCallback : public CallbackFunction
{
public:
  explicit inline RTCPeerConnectionErrorCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMError& error, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!WrapCallThisValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, error, aRv);
  }

  inline void
  Call(DOMError& error, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, error, aRv);
  }

  inline bool
  operator==(const RTCPeerConnectionErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, DOMError& error, ErrorResult& aRv);
};


class VoidFunction : public CallbackFunction
{
public:
  explicit inline VoidFunction(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VoidFunction(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!WrapCallThisValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, aRv);
  }

  inline bool
  operator==(const VoidFunction& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


class RTCStatsCallback : public CallbackFunction
{
public:
  explicit inline RTCStatsCallback(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, RTCStatsReport& report, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!WrapCallThisValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, report, aRv);
  }

  inline void
  Call(RTCStatsReport& report, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    CallSetup s(this, aRv, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, report, aRv);
  }

  inline bool
  operator==(const RTCStatsCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, RTCStatsReport& report, ErrorResult& aRv);
};


namespace mozRTCPeerConnectionBinding {

  typedef mozilla::dom::mozRTCPeerConnection NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::mozRTCPeerConnection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace mozRTCPeerConnectionBinding



class mozRTCPeerConnectionJSImpl : public CallbackInterface
{
public:
  explicit inline mozRTCPeerConnectionJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  void SetIdentityProvider(const nsAString& provider, const Optional<nsAString>& protocol, const Optional<nsAString>& username, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetIdentityAssertion(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateAnswer(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetLocalDescription(mozRTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetLocalDescription(mozRTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetRemoteDescription(mozRTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetRemoteDescription(mozRTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void UpdateIce(const RTCConfiguration& configuration, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> AddIceCandidate(mozRTCIceCandidate& candidate, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> AddIceCandidate(mozRTCIceCandidate& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<RTCRtpSender> AddTrack(MediaStreamTrack& track, DOMMediaStream& stream, const nsTArray<OwningNonNull<DOMMediaStream>>& moreStreams, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetSenders(nsTArray<nsRefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetReceivers(nsTArray<nsRefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const mozRTCPeerConnectionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetPeerIdentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddtrack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetId(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, mozRTCPeerConnectionAtoms* atomsCache);
};


class mozRTCPeerConnection final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(mozRTCPeerConnection, mozilla::DOMEventTargetHelper)

private:
  nsRefPtr<mozRTCPeerConnectionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  mozRTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~mozRTCPeerConnection();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<mozRTCPeerConnection> Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv);

  void SetIdentityProvider(const nsAString& provider, const Optional<nsAString>& protocol, const Optional<nsAString>& username, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetIdentityAssertion(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateAnswer(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetLocalDescription(mozRTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetLocalDescription(mozRTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetRemoteDescription(mozRTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetRemoteDescription(mozRTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<mozRTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<mozRTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void UpdateIce(const RTCConfiguration& configuration, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddIceCandidate(mozRTCIceCandidate& candidate, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddIceCandidate(mozRTCIceCandidate& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetPeerIdentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetId(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<nsRefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCRtpSender> AddTrack(MediaStreamTrack& track, DOMMediaStream& stream, const Sequence<OwningNonNull<DOMMediaStream>>& moreStreams, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetSenders(nsTArray<nsRefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetReceivers(nsTArray<nsRefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddtrack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCPeerConnectionBinding_h
